program SendOneMessage;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  BTJMSClient in '..\..\source\BTJMSClient.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas',
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas';

var
  Session: TBTJMSClient;
  Destination: IDestination;
  Producer: IMessageProducer;

begin
{$REGION FastMM4}
{$IF CompilerVersion>17}
{$WARN SYMBOL_PLATFORM OFF}
  ReportMemoryLeaksOnShutDown := debughook<>0;
{$WARN SYMBOL_PLATFORM ON}
{$IFEND}
{$ENDREGION}
  Session := TBTJMSClient.Create(nil);
  try
    Session.Connect;
    Session.Logger.Info('Send a message');

    Destination := Session.CreateQueue('/queue/onemessage');
    Producer := Session.CreateProducer(Destination);
    Producer.Send(Session.CreateTextMessage('This is a test message'));

    Session.Disconnect;
    WriteLn('Hit any key');
    ReadLn;
  finally
    Session.Free;
  end;

end.

