unit HabariExpressTests;

interface

uses
{$IFDEF FPC}
  fpcunit,
  testregistry,
{$ELSE}
  TestFramework,
  TestExtensions,
{$ENDIF}
  btHabariExpress,
  BTJMSInterfaces;

type
  THabariExpressTests = class(TTestCase)
  private
    ReceiveCount: Integer;
    Habari: THabariExpress;

    procedure OnTextMessage(Sender: TObject; JMSMessage: ITextMessage);
    procedure Pause;
  public
    procedure SetUp; override;
    procedure TearDown; override;

  published

    procedure TestConnect; virtual;

    procedure TestConnectTwice; virtual;

  end;

implementation

uses
  SysUtils;

{ THabariExpressTests }

procedure THabariExpressTests.SetUp;
begin
  inherited;

  Habari := THabariExpress.Create(nil);

  // todo /queue/ should no longer be neccessary
  // todo verify that settings are valid (queuename not empty ...) or raise exception
  Habari.OptionsDestination.DestinationName := '/queue/habari';

  Habari.OptionsSession.AcknowledgementMode := amAutoAcknowledge;

  // todo enable / disable consumer
  Habari.OnTextMessage := OnTextMessage;

  ReceiveCount := 0;

end;

procedure THabariExpressTests.TearDown;
begin
  Habari.Free;

  inherited;
end;

procedure THabariExpressTests.OnTextMessage(Sender: TObject;
  JMSMessage: ITextMessage);
begin
  CheckEquals('abc', JMSMessage.Text);
  Inc(ReceiveCount);
end;


procedure THabariExpressTests.TestConnect;
begin
  Habari.Active := True;
  Habari.MessageProducer.Send(Habari.Session.CreateTextMessage('abc'));

  Pause;

  Habari.Active := False;

  CheckEquals(1, ReceiveCount);
end;

procedure THabariExpressTests.TestConnectTwice;
begin
  Habari.Active := True;
  Habari.MessageProducer.Send(Habari.Session.CreateTextMessage('abc'));
  Pause;

  Habari.Active := False;

  Habari.Active := True;
  Habari.MessageProducer.Send(Habari.Session.CreateTextMessage('abc'));
  Pause;
  Habari.Active := False;

  CheckEquals(2, ReceiveCount);
end;

procedure THabariExpressTests.Pause;
var
  I: Integer;
begin
  for I := 0 to 10 do
    Sleep(100);
end;

initialization
  RegisterTests('Indy', [THabariExpressTests.Suite]);

end.
