unit CoreTests;

interface

uses
{$IFDEF FPC}
  fpcunit,
  testregistry,
{$ELSE}
  TestFramework,
  TestExtensions,
{$ENDIF}
  BTJMSInterfaces,
  BTJMSConnection;

const
  MSG_COUNT = 100;

type

  TSendReceiveTests = class(TTestCase, IMessageListener)
  private
    Connection: TBTJMSConnection;
    // Session: ISession;
    // Producer: IMessageProducer;
    // Consumer: IMessageConsumer;
    // Destination: IDestination;

    procedure OnMessage(Message: IMessage);

  protected
    procedure AssignCommAdapter; virtual; abstract;

  public
    procedure SetUp; override;
    procedure TearDown; override;

  published

    procedure TestStartStopClose; virtual;

    procedure TestConnected; virtual;
    procedure TestStopStart; virtual;
    

  end;

  TSendReceiveIndyTests = class(TSendReceiveTests)
  protected
    procedure AssignCommAdapter; override;
  end;

  TSendReceiveSynapseTests = class(TSendReceiveTests)
  protected
    procedure AssignCommAdapter; override;
  end;

  TSendReceiveIcs6Tests = class(TSendReceiveTests)
  protected
    procedure AssignCommAdapter; override;
  end;

  TSendReceiveScktCompTests = class(TSendReceiveTests)
  protected
    procedure AssignCommAdapter; override;
  end;

implementation
uses
  BTAdapterRegistry,
  BTCommAdapterIndy, BTCommAdapterSynapse,
  Forms, DateUtils, SysUtils;

const
  QUEUE_DUNIT = '/queue/unittests';
  TEXT_DUNIT = 'This is test message %d';
  BYTES_DUNIT = #0 + #1 + #0 + #2 + #0 + #3 + '%d';

  { TSendReceiveTests }

function MaxMsec: Integer;
begin
  Result := 6 * MSG_COUNT + 1000;
end;



procedure TSendReceiveTests.OnMessage(Message: IMessage);
begin

end;

procedure TSendReceiveTests.SetUp;

begin
  inherited;

  AssignCommAdapter;

  // Create the connection.
  Connection := TBTJMSConnection.MakeConnection('', '', 'localhost');


end;

procedure TSendReceiveTests.TearDown;
begin
  inherited;

  Connection.Close;

  Connection.Free;
end;

procedure TSendReceiveTests.TestConnected;
begin
  Connection.Start;
  CheckTrue(Connection.Transport.StompConnected);
end;

procedure TSendReceiveTests.TestStartStopClose;
begin
  CheckEquals(False, Connection.Closed, '1');
  Connection.Start;
  CheckEquals(False, Connection.Closed, '2');
  Connection.Close;
  CheckEquals(True, Connection.Closed, '3');
end;

procedure TSendReceiveTests.TestStopStart;
begin
  CheckEquals(False, Connection.Started, '1');

  // this should not raise an exception
  Connection.Stop;

  CheckEquals(False, Connection.Started, '2');

  // this should work too
  Connection.Start;

  CheckEquals(True, Connection.Started, '3');
end;

{ TSendReceiveIndyTests }

procedure TSendReceiveIndyTests.AssignCommAdapter;
begin
  SetDefaultAdapter(TBTCommAdapterIndy);
end;

{ TSendReceiveSynapseTests }

procedure TSendReceiveSynapseTests.AssignCommAdapter;
begin
  SetDefaultAdapter(TBTCommAdapterSynapse);
end;

{ TSendReceiveIcs6Tests }

procedure TSendReceiveIcs6Tests.AssignCommAdapter;
begin
  // Conn.CommAdapter := TBTCommAdapterIcs6.Create(Conn);
end;

{ TSendReceiveScktCompTests }

procedure TSendReceiveScktCompTests.AssignCommAdapter;
begin
  // Conn.CommAdapter := TBTCommAdapterScktComp.Create(Conn);
end;

initialization
  RegisterTests('Indy', [TSendReceiveIndyTests.Suite]);
  RegisterTests('Synapse', [TSendReceiveSynapseTests.Suite]);

end.

