program PublisherDemo;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  BTJMSClient in '..\..\source\BTJMSClient.pas',
  BTStompInterfaces in '..\..\source\BTStompInterfaces.pas',
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas',
  BTStompTypes in '..\..\source\BTStompTypes.pas',
  BTStompConnection in '..\..\source\BTStompConnection.pas',
  BTSupportInterfaces in '..\..\source\BTSupportInterfaces.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas',
  BTCommAdapter in '..\..\source\BTCommAdapter.pas',
  BTJMSConnection in '..\..\source\BTJMSConnection.pas',
  BTLogger in '..\..\source\BTLogger.pas';

const
  Dest = '/queue/a';

  SEND_COUNT = 2000;

var
  Connection: TBTJMSConnection;
  Session: ISession;
  Destination: IDestination;
  Producer: IMessageProducer;
  TextMessage: ITextMessage;

  I: Integer;
  L: ILogging;
  Compiler: string;

begin
  {$IFDEF FPC}
  Compiler := 'Free Pascal';
  {$ELSE}
  Compiler := 'Borland Delphi';
  {$ENDIF}

  L := TSimpleLogger.Create;
  L.Info('Compiler: '  + Compiler);
  L.Info('Connect to server');

  Connection := TBTJMSConnection.MakeConnection('', '', 'localhost');
  Connection.Start;

  Session := Connection.CreateSession(False, amAutoAcknowledge);

  try

    Sleep(1500);

    for I := 0 to SEND_COUNT - 1 do
    begin
      L.Info(Format('Sending test message %d to %s ...', [I+1, Dest]));

      Destination := Session.CreateQueue(Dest);
      Producer := Session.CreateProducer(Destination);
      TextMessage := Session.CreateTextMessage(Format('This is test message %d', [I+1]));
      Producer.Send(TextMessage);
      
    end;

  finally
    L.Info('Hit any key');
    ReadLn;

    Connection.Close;


  end;

end.

