unit MainFrm;

{$mode objfpc}{$H+}

interface

uses
  BTSupportInterfaces, // BTJMSClient,

  BTJMSInterfaces,
  BTStompInterfaces, Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, Menus,
  ActnList, ComCtrls, ExtCtrls, StdCtrls;

type

  { TMainForm }

  TMainForm = class(TForm, IMessageListener)
    ActionOptionsSend: TAction;
    ActionSendObjects: TAction;
    ActionOptionsSubscribe: TAction;
    ActionCloseSession: TAction;
    ActionSession: TAction;
    ActionDebugLevel: TAction;
    ActionNewDest: TAction;
    ActionCommit: TAction;
    ActionAbort: TAction;
    ActionBegin: TAction;
    ActionSendFile: TAction;
    ActionSend: TAction;
    ActionSub: TAction;
    ActionDisconnect: TAction;
    ActionConnect: TAction;
    ActionList1: TActionList;
    Button1: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button2: TButton;
    Button3: TButton;
    Button5: TButton;
    Button6: TButton;
    Button8: TButton;
    Button9: TButton;
    ComboCommLib: TComboBox;
    ComboBox1: TComboBox;
    EditDest: TEdit;
    EditRepeat: TEdit;
    EditHost: TEdit;
    EditPort: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    FrameList: TListBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    LbxDest: TListBox;
    JMSMessageList: TListView;
    MainMenu1: TMainMenu;
    MemoText: TMemo;
    MemoLog: TMemo;
    MenuItem1: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    MenuItem15: TMenuItem;
    MenuItem16: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem20: TMenuItem;
    MenuItem21: TMenuItem;
    MenuItem22: TMenuItem;
    MenuItem23: TMenuItem;
    MenuItem24: TMenuItem;
    MenuItem25: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    OpenDialog1: TOpenDialog;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel9: TPanel;
    StatusBar1: TStatusBar;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    UpDown1: TUpDown;
    procedure ActionAbortExecute(Sender: TObject);

    procedure ActionCommitExecute(Sender: TObject);
    procedure ActionConnectExecute(Sender: TObject);
    procedure ActionDebugLevelExecute(Sender: TObject);
    procedure ActionDisconnectExecute(Sender: TObject);
    procedure ActionList1Update(AAction: TBasicAction; var Handled: Boolean);
    procedure ActionNewDestExecute(Sender: TObject);
    procedure ActionSendExecute(Sender: TObject);
    procedure ActionSendFileExecute(Sender: TObject);
    procedure ActionCloseSessionExecute(Sender: TObject);
    procedure ActionSessionExecute(Sender: TObject);
    procedure ActionSubExecute(Sender: TObject);

    procedure ComboCommLibSelect(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);

    procedure AddFrameToList(Frame: IStompFrame);
    procedure MenuItem21Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    
  private
    { private declarations }

    
    function SelectedDestination: string;
    
     function NewDest: string;
    
    procedure MyOnLog(const ALogMessage: WideString; const ALogLevel:
      TLogLevel);
      
    procedure MyOnError(Sender: TObject; Frame:
      IStompFrame);
    procedure MyOnMessage(Sender: TObject; Frame:
      IStompFrame);
    procedure MyOnConnect(Sender: TObject; Frame:
      IStompFrame);
    procedure MyOnReceipt(Sender: TObject; Frame:
      IStompFrame);

    procedure MyOnJMSTextMessage(Sender: TObject; JMSMessage: ITextMessage);

    procedure MyOnJMSBytesMessage(Sender: TObject; JMSMessage: IBytesMessage);
    
    procedure OnMessage(Message: IMessage);
    
  public
    { public declarations }
    
    JMSMessage: ITextMessage;

    JMSMessages: TInterfaceList;
    
  end; 

var
  MainForm: TMainForm;

implementation

uses
  OptionsSessionFrm,
  // used ActiveMQ classes
  BTCommAdapterIndy,
  BTCommAdapterSynapse,
  BTAdapterRegistry,
  BTJMSConnection,
  // STOMP client
  BTJMSClient,
  BTStompConnection,
  // Delphi etc
  SyncObjs;

var
  Transport: TBTJMSClient;
  Connection: TBTJMSConnection;
  Session: ISession;
  Logger: ILogging;
  AcknowledgementMode: TAcknowledgementMode;
  //
  CS: TCriticalSection;
  
{ TMainForm }

procedure TMainForm.FormCreate(Sender: TObject);
begin
  
  // holds incommng JMS messages
  JMSMessages := TInterfaceList.Create;
  
  // Critical Section ?
  CS := TCriticalSection.Create;
  
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
  CanClose := True;
  
  if Assigned(Transport) and Transport.StompConnected then
  begin
    Transport.DisConnect
  end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  Caption := 'BTActiveMQClient GUI Demo (Free Pascal)';

  // default stomp port
  EditPort.Text := IntToStr(btPORT_STOMP);
  
  // Adapter
  ComboCommLib.Items.Text := AdapterNames;
  ComboCommLib.ItemIndex := 0;

  // set up gui
  PageControl1.ActivePageIndex := 0;
  LbxDest.ItemIndex := 0;
  
end;

procedure TMainForm.AddFrameToList(Frame: IStompFrame);
begin
 FrameList.Items.Add(Frame.Command + ' '
    + 'message-id=' + Frame.GetValue('message-id') + ' '
    + 'timestamp=' + Frame.GetValue('timestamp') + ' '
    + StringReplace(Frame.Body, #13#10, ' ', [rfReplaceAll]));
end;

procedure TMainForm.MenuItem2Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.MyOnLog(const ALogMessage: WideString;
  const ALogLevel: TLogLevel);
begin
  if System.IsConsole then
    // write to standard output
    WriteLn(Logger.FormatLogMessage(ALogMessage, ALogLevel))
  else
  begin
    // update GUI
    Application.ProcessMessages;
    // write to Memo
    MemoLog.Lines.Add(Logger.FormatLogMessage(ALogMessage, ALogLevel))
  end;
end;

procedure TMainForm.ComboCommLibSelect(Sender: TObject);
begin
  // tell BTAdapterRegistry which adapter we want
  SetDefaultAdapter(ComboCommLib.Items[ComboCommLib.ItemIndex]);
end;

//-----------------------------------------------------------
//  STOMP COMMUNICATION METHODS
//-----------------------------------------------------------

//-----------------------------------------------------------
//  Connect
//-----------------------------------------------------------

procedure TMainForm.ActionConnectExecute(Sender: TObject);
begin
  // create JMS Connection
  Connection := TBTJMSConnection.MakeConnection('', '', EditHost.Text,
    StrToIntDef(EditPort.Text, btPORT_STOMP));

  Transport := Connection.Transport;

  // get a Logger
  Logger := Connection.Transport.Logger;

  // set log writer method
  Logger.OnLog := @MyOnLog;

  // todo move these assignments to a custom event handler (onbeforeconnect)
  // of the communication adapter component
  // set low level (STOMP) event handlers
  Connection.Transport.OnStompConnect := @MyOnConnect;
  Connection.Transport.OnStompMessage := @MyOnMessage;
  Connection.Transport.OnStompReceipt := @MyOnReceipt;
  Connection.Transport.OnStompError := @MyOnError;

  // start
  Logger.Info('Connect with ' + Connection.Transport.Host);
  Connection.Start;
end;


//-----------------------------------------------------------
//  Abort Transaction
//-----------------------------------------------------------

procedure TMainForm.ActionAbortExecute(Sender: TObject);
begin
  Logger.Info('Abort Transaction');
  Session.Rollback;
end;

//-----------------------------------------------------------
//  Commit Transaction
//-----------------------------------------------------------

procedure TMainForm.ActionCommitExecute(Sender: TObject);
begin
  Logger.Info('Commit Transaction');
  Session.Commit;
end;

//-----------------------------------------------------------
// Disconnect
//-----------------------------------------------------------

procedure TMainForm.ActionDisConnectExecute(Sender: TObject);
begin
  Logger.Info('Disconnect');
  Connection.Close;
end;


//-----------------------------------------------------------
// Set log detail level
//-----------------------------------------------------------

procedure TMainForm.ActionDebugLevelExecute(Sender: TObject);
begin
    if ActionDebugLevel.Checked then
    Logger.LogLevel := logDebug
  else
    Logger.LogLevel := logInfo
end;


//-----------------------------------------------------------
// Set enabled buttons
//-----------------------------------------------------------

procedure TMainForm.ActionList1Update(AAction: TBasicAction;
  var Handled: Boolean);
begin

 (* ActionConnect.Enabled := not (Assigned(Transport) and Transport.StompConnected);
  ActionDisConnect.Enabled := Assigned(Transport) and Transport.StompConnected;
  
  ActionNewDest.Enabled := (LbxDest.Items.IndexOf(NewDest) = -1) and
    Assigned(Transport) and Transport.StompConnected;
    
  ActionSub.Enabled := (SelectedDestination <> '') and Assigned(Session);
  
  ActionSend.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionSendFile.Enabled := (SelectedDestination <> '') and Assigned(Session);

  ActionCommit.Enabled := Assigned(Session) and Session.Transacted;
  ActionAbort.Enabled := Assigned(Session) and Session.Transacted;

  ComboCommLib.Enabled := not Transport.StompConnected;

  StatusBar1.SimpleText :=
    Format('Received %d messages (in %d STOMP frames)',
    [JMSMessages.Count, FrameList.Items.Count]); *)
    
  ActionConnect.Enabled := not (Assigned(Transport) and Transport.StompConnected);
  ActionDisconnect.Enabled := Assigned(Transport) and Transport.StompConnected;

  ActionSession.Enabled := Assigned(Transport) and Transport.StompConnected and not Assigned(Session);
  ActionCloseSession.Enabled := Assigned(Session);

  ActionNewDest.Enabled := (LbxDest.Items.IndexOf(NewDest) = -1) and Assigned(Transport) and
    Transport.StompConnected;

  ActionSub.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionOptionsSubscribe.Enabled := False;

  ActionSend.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionSendFile.Enabled := (SelectedDestination <> '') and Assigned(Session);

  ActionSendObjects.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionOptionsSend.Enabled := (SelectedDestination <> '') and Assigned(Session);

  ActionCommit.Enabled := Assigned(Session) and Session.Transacted;
  ActionAbort.Enabled := Assigned(Session) and Session.Transacted;

  ComboCommLib.Enabled := not (Assigned(Transport) and Transport.StompConnected);

  StatusBar1.SimpleText :=
    Format('Received %d messages (in %d STOMP frames)',
    [JMSMessages.Count, FrameList.Items.Count]);
end;

//-----------------------------------------------------------
//  Add a destination to the selection list
//-----------------------------------------------------------

procedure TMainForm.ActionNewDestExecute(Sender: TObject);
begin
  LbxDest.Items.Add(NewDest);
  LbxDest.ItemIndex := LbxDest.Items.Count - 1;
end;

//-----------------------------------------------------------
// Send Text
//-----------------------------------------------------------

procedure TMainForm.ActionSendExecute(Sender: TObject);
var
  Count: Integer;
  I: Integer;
begin
  JMSMessage.Text := MemoText.Lines.Text;
  Count := StrToIntDef(EditRepeat.Text, 1);

  Logger.Info(Format('Sending (%d): ' + Trim(JMSMessage.Text), [Count]));

  CS.Enter;

  for I := 0 to Count - 1 do
  begin
    Connection.Transport.Send(JMSMessage, SelectedDestination);
  end;

  CS.Leave;
end;


//-----------------------------------------------------------
// Send File
//-----------------------------------------------------------
procedure TMainForm.ActionSendFileExecute(Sender: TObject);
var
  D: IDestination;
  Producer: IMessageProducer;
  FileStream: TFileStream;
  S: TStringStream;
  BytesMessage: IBytesMessage;
begin
  if not OpenDialog1.Execute then
  begin
    Exit;
  end;

  if Pos('/queue', SelectedDestination) > 0 then
    D := Session.CreateQueue(SelectedDestination)
  else
    D := Session.CreateTopic(SelectedDestination);

  Producer := Session.CreateProducer(D);

  S := TStringStream.Create('');
  try
    FileStream := TFileStream.Create(OpenDialog1.FileName, fmOpenRead or
      fmShareDenyWrite);
    try
      S.CopyFrom(FileStream, FileStream.Size);
      BytesMessage := Session.CreateBytesMessage;
      BytesMessage.Content := S.DataString;
      Producer.Send(BytesMessage);

    finally
      FileStream.Free;
    end;
  finally
    S.Free;
  end;

end;

//-----------------------------------------------------------
//  Close the session
//-----------------------------------------------------------

procedure TMainForm.ActionCloseSessionExecute(Sender: TObject);
begin
  Logger.Info('Close session');

  Session.Close;
  Session := nil;
end;

procedure TMainForm.ActionSessionExecute(Sender: TObject);
var
  OptionsSessionForm: TOptionsSessionForm;
  Transactional: Boolean;
begin
  AcknowledgementMode := amTransactional;

  Application.CreateForm(TOptionsSessionForm, OptionsSessionForm);
  with OptionsSessionForm do
  try
    // get Session Transactional Flag and AcknowledgementMode
    if OptionsSessionForm.ShowModal = mrOk then
    begin
      Transactional := GrpAckMode.ItemIndex = 0;
      case GrpAckMode.ItemIndex of
        0: AcknowledgementMode := amTransactional;
        1: AcknowledgementMode := amAutoAcknowledge;
        2: AcknowledgementMode := amClientAcknowledge;
      end;
    end
    else
    begin
      Exit;
    end;
  finally
    OptionsSessionForm.Free;
  end;

  // create JMS client session
  Session := Connection.CreateSession(Transactional, AcknowledgementMode);

  // value object for JMS message properties dialog
  JMSMessage := Session.CreateTextMessage;

end;


//-----------------------------------------------------------
// Subscribe
//-----------------------------------------------------------

procedure TMainForm.ActionSubExecute(Sender: TObject);
var
  D: IDestination;
  C: IMessageConsumer;
begin
  Logger.Info('Subscribe ' + SelectedDestination);

  if Pos('/queue', SelectedDestination) > 0 then
    D := Session.CreateQueue(SelectedDestination)
  else
    D := Session.CreateTopic(SelectedDestination);

  C := Session.CreateConsumer(D);

  C.MessageListener := Self;
  
end;


//-----------------------------------------------------------
//  Receive CONNECTED Frame
//-----------------------------------------------------------

procedure TMainForm.MyOnConnect(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info(Frame.Command);
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive MESSAGE Frame
//-----------------------------------------------------------

procedure TMainForm.MyOnMessage(Sender: TObject; Frame: IStompFrame);
begin
  if Frame.GetValue('content-length')<>'' then
    Logger.Info('Received: ' + IntToStr(Length(Frame.Body)) + ' bytes')
  else
    Logger.Info('Received: ' + Trim(Frame.Body));

  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive ERROR Frame
//-----------------------------------------------------------

procedure TMainForm.MyOnError(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info('Received ERROR: ' + Frame.GetValue('message') + ' ' +
    Frame.Body);
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive RECEIPT Frame
//-----------------------------------------------------------

procedure TMainForm.MyOnReceipt(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info('Receipt: ' + Frame.GetValue('receipt-id'));
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  END OF STOMP COMMUNICATION METHODS
//-----------------------------------------------------------

//-----------------------------------------------------------
//  JMS METHODS START
//-----------------------------------------------------------

//-----------------------------------------------------------
//  Receive Generic Message - see IMessageConsumer
//-----------------------------------------------------------

procedure TMainForm.OnMessage(Message: IMessage);
begin
// Acknowledge the message
  if AcknowledgementMode = amClientAcknowledge then
    // todo Ack has a second parameter TransactionID
    Connection.Transport.Ack(Message.MessageId);

  if Supports(Message, ITextMessage) then
  begin
    MyOnJMSTextMessage(Self, ITextMessage(Message));
  end else if Supports(Message, IBytesMessage) then
  begin
    MyOnJMSBytesMessage(Self, IBytesMessage(Message));
  end;
end;

//-----------------------------------------------------------
//  Receive Text Message
//-----------------------------------------------------------

procedure TMainForm.MyOnJMSTextMessage(Sender: TObject; JMSMessage:
  ITextMessage);
begin
  with JMSMessageList.Items.Add do
  begin
    Caption := JMSMessage.MessageId;
    SubItems.Add(JMSMessage.CorrelationID);
    SubItems.Add(IntToStr(JMSMessage.Priority));
    SubItems.Add(JMSMessage.ReplyTo);
    SubItems.Add(DateTimeToStr(JMSMessage.Timestamp) + ' UTC');
  end;

  JMSMessages.Add(JMSMessage);
end;

//-----------------------------------------------------------
//  Receive Bytes Message
//-----------------------------------------------------------

procedure TMainForm.MyOnJMSBytesMessage(Sender: TObject;
  JMSMessage: IBytesMessage);
begin
  with JMSMessageList.Items.Add do
  begin
    Caption := JMSMessage.MessageId;
    SubItems.Add(JMSMessage.CorrelationID);
    SubItems.Add(IntToStr(JMSMessage.Priority));
    SubItems.Add(JMSMessage.ReplyTo);
    SubItems.Add(DateTimeToStr(JMSMessage.Timestamp) + ' UTC');
  end;

  JMSMessages.Add(JMSMessage);
end;

//-----------------------------------------------------------
//  JMS METHODS END
//-----------------------------------------------------------


//-----------------------------------------------------------
// Returns the selected destination
//-----------------------------------------------------------

function TMainForm.SelectedDestination: string;
begin
  if LbxDest.ItemIndex = -1 then
    Result := ''
  else
    Result := LbxDest.Items[LbxDest.ItemIndex];
end;

//-----------------------------------------------------------
// Returns destination which cann be added to the list
//-----------------------------------------------------------

function TMainForm.NewDest: string;
begin
  Result := '/' + ComboBox1.Items[ComboBox1.ItemIndex] + '/' + EditDest.Text;
end;

//-----------------------------------------------------------
//  About me
//-----------------------------------------------------------

procedure TMainForm.MenuItem21Click(Sender: TObject);
begin
  ShowMessage(Caption + #13#10 + 'www.mikejustin.com');
end;

initialization
  {$I MainFrm.lrs}

end.

