/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.xpmenu;

import com.smardec.asc.animatepanel.JAnimateTab;

import javax.swing.*;
import java.awt.*;


/**
 * Sample class that demonstrates the usage of <code>JAnimatePanel</code>.
 */
public class JXPMenuTab extends JAnimateTab {
    private static final ImageIcon leftBody = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/leftBody.gif"));
    private static final ImageIcon rightBody = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/rightBody.gif"));
    private JPanel xpPanel;

    public JXPMenuTab(String text, Icon icon) {
        super(text, icon);
        xpPanel = new JPanel() {
            protected void paintComponent(Graphics g) {
                int l_width = leftBody.getImage().getWidth(this);
                int l_height = leftBody.getImage().getHeight(this);

                for (int j = 0; j <= getHeight(); j += (l_height))
                    g.drawImage(leftBody.getImage(), 0, j, l_width, l_height, this);


                int r_width = rightBody.getImage().getWidth(this);
                int r_height = rightBody.getImage().getHeight(this);
                int r_x = getWidth() - l_width - r_width;
                for (int j = 0; j <= getHeight(); j += (r_height))
                    g.drawImage(rightBody.getImage(), r_x, j, r_width, r_height, this);

                g.setColor(new Color(186, 201, 251));
                g.fillRect(l_width, 0, getWidth() - r_width, getHeight());

            }
        };
        xpPanel.setOpaque(false);
        xpPanel.setLayout(new BoxLayout(xpPanel, BoxLayout.Y_AXIS));
        addComponent(xpPanel);
    }

    public void addMenuItem(JXPMenuItem jxpMenuItem) {
        xpPanel.add(Box.createHorizontalStrut(5));
        xpPanel.add(jxpMenuItem);
        xpPanel.add(Box.createVerticalStrut(4));
    }
}
