/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.table;

import javax.swing.*;
import javax.swing.table.TableColumnModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;


/**
 * <code>MouseListener</code> that invokes sorting when a button is pressed on the
 * column's header.
 */
public class SortedTableHeaderMouseListener extends MouseAdapter {
    private JTable table;
    private SortedTableModel sortedTableModel;

    /**
     * Creates <code>SortedTableHeaderMouseListener</code> object with specified <code>JTable</code>
     * and <code>SortedTableModel</code>.
     *
     * @param table            <code>JTable</code> component
     * @param sortedTableModel <code>SortedTableModel</code> object
     */
    public SortedTableHeaderMouseListener(JTable table, SortedTableModel sortedTableModel) {
        this.table = table;
        this.sortedTableModel = sortedTableModel;
    }

    /**
     * Invoked when a mouse button has been pressed on a component.
     * Invokes sorting of the column.
     */
    public void mousePressed(MouseEvent e) {
        TableColumnModel tableColumnModel = table.getColumnModel();
        int viewColumnIndex = tableColumnModel.getColumnIndexAtX(e.getX());
        if (viewColumnIndex != tableColumnModel.getColumnIndexAtX(e.getX() - 3))
            return;
        if (viewColumnIndex != tableColumnModel.getColumnIndexAtX(e.getX() + 3))
            return;
        int modelColumnIndex = table.convertColumnIndexToModel(viewColumnIndex);
        if (modelColumnIndex != -1) {
            if (sortedTableModel.getSortingColumn() == modelColumnIndex)
                sortedTableModel.setAscending(!sortedTableModel.isAscending());
            else
                sortedTableModel.setAscending(true);
            sortedTableModel.setSortingColumn(modelColumnIndex);
            sortedTableModel.sort();
            table.getTableHeader().repaint();
        }
    }
}
