/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.outlookpanel;

import java.awt.*;

/**
 * Defines the renderer interface for {@link JOutlookButton} in {@link JOutlookTab}.
 */
public interface OutlookButtonRenderer {
    /**
     * Returns the component whose paint() method will render the specified button.
     *
     * @param jOutlookButton the button we're painting
     * @param mouseOver      indicates that the mouse is over the tab header
     * @param mousePressed   indicates that the mouse is pressed on the tab header
     * @return the component whose paint() method will render the specified button.
     */
    Component getOutlookButtonRendererComponent(JOutlookButton jOutlookButton, boolean mouseOver, boolean mousePressed);
}
