/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.hyperlink;

import javax.swing.*;
import java.awt.*;


/**
 * <code>JLabel</code> that displays hyperlink and opens internet browser on mouse click.
 */
public class JHyperlinkLabel extends JLabel {
    private HyperlinkMouseAdapter hyperlinkMouseAdapter = new HyperlinkMouseAdapter("");

    /**
     * Creates a <code>JHyperlinkLabel</code> instance with the specified image and url string.
     * The label is centered vertically and horizontally
     * in its display area.
     *
     * @param image The image to be displayed by the label
     * @param url   url string
     */
    public JHyperlinkLabel(Icon image, String url) {
        super(image);
        init(url);
    }

    /**
     * Creates a <code>JHyperlinkLabel</code> instance with the specified
     * image, url string and horizontal alignment.
     * The label is centered vertically in its display area.
     *
     * @param image               The image to be displayed by the label
     * @param url                 url string
     * @param horizontalAlignment One of the following constants
     *                            defined in <code>SwingConstants</code>:
     *                            <code>LEFT</code>,
     *                            <code>CENTER</code>,
     *                            <code>RIGHT</code>,
     *                            <code>LEADING</code> or
     *                            <code>TRAILING</code>
     */
    public JHyperlinkLabel(Icon image, String url, int horizontalAlignment) {
        super(image, horizontalAlignment);
        init(url);
    }

    /**
     * Creates a <code>JHyperlinkLabel</code> instance with the specified text and url string.
     * The label is aligned against the leading edge of its display area,
     * and centered vertically.
     *
     * @param text The text to be displayed by the label
     */
    public JHyperlinkLabel(String text, String url) {
        super(text);
        init(url);
    }

    /**
     * Creates a <code>JHyperlinkLabel</code> instance with the specified
     * text, url string and horizontal alignment.
     * The label is centered vertically in its display area.
     *
     * @param text                The text to be displayed by the label
     * @param url                 url string
     * @param horizontalAlignment One of the following constants
     *                            defined in <code>SwingConstants</code>:
     *                            <code>LEFT</code>,
     *                            <code>CENTER</code>,
     *                            <code>RIGHT</code>,
     *                            <code>LEADING</code> or
     *                            <code>TRAILING</code>
     */
    public JHyperlinkLabel(String text, String url, int horizontalAlignment) {
        super(text, horizontalAlignment);
        init(url);
    }

    /**
     * Creates a <code>JHyperlinkLabel</code> instance with the specified
     * text, image, url string and horizontal alignment.
     * The label is centered vertically in its display area.
     * The text is on the trailing edge of the image.
     *
     * @param text                The text to be displayed by the label
     * @param icon                The image to be displayed by the label
     * @param url                 url string
     * @param horizontalAlignment One of the following constants
     *                            defined in <code>SwingConstants</code>:
     *                            <code>LEFT</code>,
     *                            <code>CENTER</code>,
     *                            <code>RIGHT</code>,
     *                            <code>LEADING</code> or
     *                            <code>TRAILING</code>
     */
    public JHyperlinkLabel(String text, Icon icon, String url, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        init(url);
    }

    /**
     * Returns url string.
     *
     * @return url string.
     */
    public String getUrl() {
        return hyperlinkMouseAdapter.getUrl();
    }

    /**
     * Sets url string.
     *
     * @param url url string
     */
    public void setUrl(String url) {
        hyperlinkMouseAdapter.setUrl(url);
    }

    private void init(String url) {
        hyperlinkMouseAdapter.setUrl(url);
        addMouseListener(hyperlinkMouseAdapter);
        setForeground(Color.blue);
        setText("<html><u>" + getText() + "</u></html>");
        setFont(getFont().deriveFont(Font.PLAIN));
        setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }
}
