/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.hyperlink;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;


/**
 * <code>MouseAdapter</code> that opens internet browser on mouse click.
 */
public class HyperlinkMouseAdapter extends MouseAdapter {
    private String url;

    /**
     * Creates <code>HyperlinkMouseAdapter</code> instance with the specified url.
     *
     * @param url url to open
     */
    public HyperlinkMouseAdapter(String url) {
        this.url = url;
    }

    /**
     * Returns url string.
     *
     * @return url string.
     */
    public String getUrl() {
        return url;
    }

    /**
     * Sets url string.
     *
     * @param url url string
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Invoked when the mouse has been clicked on a component. Opens internet browser.
     */
    public void mouseClicked(MouseEvent e) {
        HyperlinkUtil.openInternetBrowser(url);
    }
}
