/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.animatepanel;

import java.awt.*;


/**
 * Defines the renderer interface for {@link JAnimateTabHeader} in {@link JAnimateTab}.
 */
public interface AnimateTabHeaderRenderer {
    /**
     * Returns the component whose paint() method will render the specified tab header.
     *
     * @param jAnimateTabHeader the tab header we're painting
     * @param mouseOver         indicates that the mouse is over the tab header
     * @param mousePressed      indicates that the mouse is pressed on the tab header
     * @return the component whose paint() method will render the specified tab header.
     */
    Component getAnimateTabHeaderRendererComponent(JAnimateTabHeader jAnimateTabHeader, boolean mouseOver, boolean mousePressed);
}
