/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.animatepanel;


/**
 * Interface for <code>JAnimatePanel</code> listener.
 */
public interface AnimateListener {
    /**
     * Invoked after the <code>JAnimatePanel</code>'s tab has changed it's state.
     *
     * @param index    the tab index of this <code>JAnimatePanel</code> that has been changed
     * @param oldValue old value of the tab state
     * @param newValue new value of the tab state
     */
    public void tabStateChanged(int index, boolean oldValue, boolean newValue);

    /**
     * Invoked after the <code>JAnimatePanel</code>'s animation process is started.
     *
     * @param index the tab index of this <code>JAnimatePanel</code> that has been animated
     */
    public void animationStarted(int index);

    /**
     * Invoked after the <code>JAnimatePanel</code>'s animation process is stopped.
     *
     * @param index the tab index of this <code>JAnimatePanel</code> that has been animated
     */
    public void animationStoped(int index);
}
