/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Hashtable;
import net.caigen.pyramid.PokerPanel;

final class Layout
implements LayoutManager {
    private Hashtable m_map = new Hashtable(540, 0.1f);
    private int m_width;
    private int m_height;
    private int charWidth;
    private int charHeight;
    private Container m_parent;
    static final int NONE = 10;
    static final int TOP = 20;
    static final int LEFT = 30;
    static final int VERTICAL = 40;
    static final int HORIZONTAL = 50;
    static final int ABSOLUTE = 60;
    private int resizekind = 10;

    public Layout(Container container, int i, int j) {
        this.m_parent = container;
        this.m_width = i;
        this.m_height = j;
        FontMetrics fontmetrics = this.m_parent.getFontMetrics(this.m_parent.getFont());
        this.charWidth = fontmetrics.stringWidth("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ") / "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
        if (this.charWidth <= 0) {
            this.charWidth = 1;
        }
        this.charHeight = fontmetrics.getHeight();
    }

    public Dimension dlgsize(int i, int j) {
        Insets insets = this.m_parent.getInsets();
        this.m_width = insets.left + insets.right + i * this.charWidth / 4;
        this.m_height = insets.top + insets.bottom + j * this.charHeight / 8;
        return new Dimension(this.m_width, this.m_height);
    }

    public void setResizeKind(int i) {
        this.resizekind = i;
    }

    public Rectangle bounds(Component component) {
        Rectangle rectangle = (Rectangle)this.m_map.get(component);
        if (rectangle == null) {
            return null;
        }
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addLayoutComponent(String s, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(this.m_width, this.m_height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void layoutContainer(Container container) {
        Container container2 = container;
        synchronized (container2) {
            int i = container.getComponentCount();
            if (i == 0) {
                return;
            }
            int j = 0;
            int k = 0;
            if (this.resizekind == 20 || this.resizekind == 30 || this.resizekind == 60) {
                j = container.getSize().width - this.m_width;
                k = container.getSize().height - this.m_height;
                if (container instanceof PokerPanel && (j != 0 || k != 0)) {
                    ((PokerPanel)container).setxy(true);
                }
            } else if (this.resizekind == 40) {
                j = container.getSize().width - this.m_width;
                k = (container.getSize().height - this.m_height) / i;
            } else if (this.resizekind == 50) {
                j = (container.getSize().width - this.m_width) / i;
                k = container.getSize().height - this.m_height;
            }
            Insets insets = container.getInsets();
            for (int l = 0; l < i; ++l) {
                Component component = container.getComponent(l);
                Rectangle rectangle = (Rectangle)this.m_map.get(component);
                if (rectangle == null) continue;
                rectangle = new Rectangle(rectangle);
                if (this.resizekind != 60) {
                    if (component instanceof Label) {
                        rectangle.x -= 12;
                        rectangle.width += 12;
                    }
                    rectangle.x += insets.left;
                    rectangle.y += insets.top;
                }
                if (this.resizekind == 10 || this.resizekind == 60) {
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    continue;
                }
                if (this.resizekind == 40) {
                    component.setBounds(rectangle.x, rectangle.y + l * k, rectangle.width + j, rectangle.height + k);
                    continue;
                }
                if (this.resizekind == 50) {
                    component.setBounds(rectangle.x + l * j, rectangle.y, rectangle.width + j, rectangle.height + k);
                    continue;
                }
                if (this.resizekind == 20) {
                    if (l == 0) {
                        component.setBounds(rectangle.x, rectangle.y, rectangle.width + j, rectangle.height + k);
                        continue;
                    }
                    component.setBounds(rectangle.x, rectangle.y + k, rectangle.width + j, rectangle.height);
                    continue;
                }
                if (this.resizekind != 30) continue;
                if (l == 0) {
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width + j, rectangle.height + k);
                    continue;
                }
                component.setBounds(rectangle.x + j, rectangle.y + k, rectangle.width, rectangle.height + k);
            }
        }
    }

    public void add(Component component, int i, int j, int k, int l) {
        this.m_parent.add(component);
        this.setBounds(component, i, j, k, l);
    }

    public void dlgxyadd(Component component, int i, int j, int k, int l) {
        i = i * this.charWidth / 4;
        j = j * this.charHeight / 8;
        this.m_parent.add(component);
        this.setBounds(component, i, j, k, l);
    }

    public void dlgadd(Component component, int i, int j, int k, int l) {
        i = i * this.charWidth / 4;
        j = j * this.charHeight / 8;
        k = k * this.charWidth / 4;
        l = l * this.charHeight / 8;
        this.m_parent.add(component);
        this.setBounds(component, i, j, k, l);
    }

    public void removeAll() {
        int i = this.m_parent.getComponentCount();
        for (int j = i - 1; j >= 0; --j) {
            try {
                Component component = this.m_parent.getComponent(j);
                this.remove(component);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public synchronized void remove(Component component) {
        this.m_parent.remove(component);
        this.m_map.remove(component);
    }

    public void move(Component component, int i, int j) {
        Rectangle rectangle = (Rectangle)this.m_map.get(component);
        if (rectangle != null) {
            this.setBounds(component, i, j, rectangle.width, rectangle.height);
        }
    }

    public void setSize(Component component, int i, int j) {
        Rectangle rectangle = (Rectangle)this.m_map.get(component);
        if (rectangle != null) {
            this.setBounds(component, rectangle.x, rectangle.y, i, j);
        }
    }

    public synchronized void setBounds(Component component, int i, int j, int k, int l) {
        this.m_map.put(component, new Rectangle(i, j, k, l));
        if (this.resizekind == 60) {
            component.setBounds(i, j, k, l);
            return;
        }
        Insets insets = this.m_parent.getInsets();
        if (component instanceof Label) {
            i -= 12;
            k += 12;
        }
        component.setBounds(i += insets.left, j += insets.top, k, l);
    }
}

