/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.core.syntaxtree.DateLiteral;
import com.edb.gridsql.parser.core.syntaxtree.FloatingPointNumber;
import com.edb.gridsql.parser.core.syntaxtree.FunctionCall;
import com.edb.gridsql.parser.core.syntaxtree.IntegerLiteral;
import com.edb.gridsql.parser.core.syntaxtree.IntervalLiterals;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.NullLiterals;
import com.edb.gridsql.parser.core.syntaxtree.PreparedStmtParameter;
import com.edb.gridsql.parser.core.syntaxtree.PseudoColumn;
import com.edb.gridsql.parser.core.syntaxtree.SQLComplexExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLMultiplicativeExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLMultiplicativeExpressionOperand;
import com.edb.gridsql.parser.core.syntaxtree.SQLPrimaryExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLSimpleExpression;
import com.edb.gridsql.parser.core.syntaxtree.SimpleExpressionOperand;
import com.edb.gridsql.parser.core.syntaxtree.TableColumn;
import com.edb.gridsql.parser.core.syntaxtree.TextLiterals;
import com.edb.gridsql.parser.core.syntaxtree.TimeLiteral;
import com.edb.gridsql.parser.core.syntaxtree.TimeStampLiteral;
import com.edb.gridsql.parser.core.syntaxtree.binaryLiteral;
import com.edb.gridsql.parser.core.syntaxtree.booleanLiteral;
import com.edb.gridsql.parser.core.syntaxtree.extendbObject;
import com.edb.gridsql.parser.core.syntaxtree.hex_decimalLiteral;
import com.edb.gridsql.parser.core.syntaxtree.numberValue;
import com.edb.gridsql.parser.core.syntaxtree.stringLiteral;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.core.visitor.ObjectVisitor;
import com.edb.gridsql.parser.handler.DataTypeHandler;
import com.edb.gridsql.parser.handler.ExpressionArgumentHelper;
import com.edb.gridsql.parser.handler.FromClauseHandler;
import com.edb.gridsql.parser.handler.FunctionHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.ProjectionListHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.parser.handler.WhereClauseHandler;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

public class SQLExpressionHandler
extends ObjectDepthFirst
implements Observer {
    private static final XLogger logger = XLogger.getLogger(SQLExpressionHandler.class);
    private Command commandToExecute;
    public SqlExpression aroot = null;
    Stack<SqlExpression> sCurrent = new Stack();
    SysDatabase database = null;

    public SQLExpressionHandler(Command command) {
        this.commandToExecute = command;
        this.database = MetaData.getMetaData().getSysDatabase(command.getDBName());
    }

    public Object visit(SQLSimpleExpression sQLSimpleExpression, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = new ExpressionArgumentHelper();
        expressionArgumentHelper.argument = new SqlExpression();
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        this.sCurrent.push(expressionArgumentHelper.argument);
        sQLSimpleExpression.f0.accept(this, expressionArgumentHelper);
        if (sQLSimpleExpression.f1.present()) {
            sQLSimpleExpression.f1.accept(this, expressionArgumentHelper);
            this.aroot = expressionArgumentHelper.argument;
        } else {
            this.aroot = expressionArgumentHelper.argument;
        }
        this.sCurrent.pop();
        return this.aroot;
    }

    public Object visit(SQLPrimaryExpression sQLPrimaryExpression, Object object) {
        Object object2;
        Object object3;
        String string = null;
        String string2 = null;
        if (sQLPrimaryExpression.f0.present()) {
            object3 = (NodeToken)((NodeChoice)sQLPrimaryExpression.f0.node).choice;
            string = ((NodeToken)object3).tokenImage;
        }
        if (sQLPrimaryExpression.f1.present()) {
            object3 = (NodeChoice)sQLPrimaryExpression.f1.node;
            switch (((NodeChoice)object3).which) {
                case 0: 
                case 1: {
                    object2 = (NodeToken)((NodeChoice)object3).choice;
                    if (sQLPrimaryExpression.f0.present()) {
                        string2 = ((NodeToken)object2).tokenImage;
                        break;
                    }
                    string = ((NodeToken)object2).tokenImage;
                }
            }
        }
        if (sQLPrimaryExpression.f3.present()) {
            object3 = (NodeToken)sQLPrimaryExpression.f3.node;
            if (sQLPrimaryExpression.f1.present()) {
                string2 = string;
            }
            string = ((NodeToken)object3).tokenImage;
        }
        sQLPrimaryExpression.f2.accept(this, object);
        object3 = ((ExpressionArgumentHelper)object).argument;
        if (string == null) {
            if (((SqlExpression)object3).getUnaryOperator().equals("")) {
                ((SqlExpression)object3).setUnaryOperator("+");
            }
        } else {
            if (!((SqlExpression)object3).getUnaryOperator().equals("")) {
                ((SqlExpression)object3).setOperandSign(((SqlExpression)object3).getUnaryOperator());
            }
            ((SqlExpression)object3).setUnaryOperator(string);
        }
        if (string2 != null) {
            ((SqlExpression)object3).setOperandSign(string2);
        }
        if (((SqlExpression)object3).getExprType() == 1024) {
            ((SqlExpression)object3).setExprDataType(new ExpressionType());
        }
        if (sQLPrimaryExpression.f4.present()) {
            object2 = new SqlExpression();
            ((SqlExpression)object2).setExprType(32);
            ((SqlExpression)object2).setFunctionId(106);
            ((SqlExpression)object2).setFunctionName("::");
            ((SqlExpression)object2).getFunctionParams().add((SqlExpression)object3);
            DataTypeHandler dataTypeHandler = new DataTypeHandler();
            sQLPrimaryExpression.f4.accept(dataTypeHandler, object);
            ((SqlExpression)object2).setExpTypeOfCast(dataTypeHandler);
            ((ExpressionArgumentHelper)object).argument = object3 = object2;
        }
        return object3;
    }

    public Object visit(PseudoColumn pseudoColumn, Object object) {
        Object object2;
        Object var3_3 = null;
        SqlExpression sqlExpression = ((ExpressionArgumentHelper)object).argument;
        QueryTree queryTree = new QueryTree();
        QueryTree queryTree2 = null;
        queryTree2 = this.commandToExecute.getaQueryTreeTracker().GetCurrentTree();
        this.commandToExecute.getaQueryTreeTracker().registerTree(queryTree);
        pseudoColumn.f0.accept(this, object);
        if (pseudoColumn.f2.present()) {
            object2 = (NodeChoice)pseudoColumn.f2.node;
            if (((NodeChoice)object2).which == 0) {
                queryTree.setDistinct(false);
            } else {
                queryTree.setDistinct(true);
            }
        } else {
            queryTree.setDistinct(false);
        }
        pseudoColumn.f1.accept(this, object);
        pseudoColumn.f2.accept(this, object);
        object2 = new ProjectionListHandler(this.commandToExecute);
        pseudoColumn.f3.accept((ObjectVisitor)object2, queryTree);
        FromClauseHandler fromClauseHandler = new FromClauseHandler(this.commandToExecute);
        pseudoColumn.f4.accept(fromClauseHandler, queryTree);
        WhereClauseHandler whereClauseHandler = new WhereClauseHandler(this.commandToExecute);
        pseudoColumn.f5.accept(whereClauseHandler, queryTree);
        pseudoColumn.f6.accept(this, object);
        QueryTreeHandler.checkAndExpand(queryTree.getProjectionList(), queryTree.getRelationNodeList(), this.database, this.commandToExecute);
        QueryTreeHandler.checkAndFillTableNames(queryTree.getProjectionList(), queryTree.getRelationNodeList(), queryTree.getProjectionList(), 1, this.commandToExecute.getaQueryTreeTracker(), this.database);
        if (queryTree.getWhereRootCondition() != null) {
            QueryTreeHandler.ProcessWhereCondition(queryTree.getWhereRootCondition(), queryTree, this.commandToExecute.getaQueryTreeTracker(), this.database);
        }
        QueryTreeHandler.FillAllExprDataTypes(queryTree, MetaData.getMetaData().getSysDatabase(this.commandToExecute.getDBName()));
        sqlExpression.setExprType(64);
        sqlExpression.setSubqueryTree(queryTree);
        queryTree.setQueryType(6);
        queryTree.setParentQueryTree(queryTree2);
        this.commandToExecute.getaQueryTreeTracker().deRegisterCurrentTree();
        queryTree.setContainsAggregates(QueryTreeHandler.isAggregateQuery(queryTree));
        queryTree.processSubTree(sqlExpression, this.commandToExecute.getaQueryTreeTracker());
        return var3_3;
    }

    public Object visit(FunctionCall functionCall, Object object) {
        SqlExpression sqlExpression = ((ExpressionArgumentHelper)object).argument;
        sqlExpression.setExprType(32);
        FunctionHandler functionHandler = new FunctionHandler(sqlExpression, this.commandToExecute);
        functionCall.f0.choice.accept(functionHandler, object);
        return null;
    }

    public Object visit(SQLMultiplicativeExpression sQLMultiplicativeExpression, Object object) {
        sQLMultiplicativeExpression.f0.accept(this, object);
        if (sQLMultiplicativeExpression.f1.present()) {
            sQLMultiplicativeExpression.f1.accept(this, object);
        }
        return null;
    }

    public Object visit(SQLMultiplicativeExpressionOperand sQLMultiplicativeExpressionOperand, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        SqlExpression sqlExpression2 = new SqlExpression();
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        SqlExpression sqlExpression3 = this.sCurrent.pop();
        sqlExpression2.setExprString(sqlExpression2.getExprString() + sqlExpression3.getExprString());
        this.sCurrent.push(sqlExpression2);
        sqlExpression2.setLeftExpr(sqlExpression);
        switch (sQLMultiplicativeExpressionOperand.f0.which) {
            case 0: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("*");
                break;
            }
            case 1: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("\\");
                break;
            }
            case 2: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("MOD");
                break;
            }
            case 3: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("DIV");
                break;
            }
            case 4: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("%");
                break;
            }
            case 5: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("&");
                break;
            }
            case 6: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("|");
                break;
            }
            case 7: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("#");
                break;
            }
            case 8: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("<<");
                break;
            }
            case 9: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator(">>");
                break;
            }
        }
        sQLMultiplicativeExpressionOperand.f0.accept(this, object);
        SqlExpression sqlExpression4 = new SqlExpression();
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        this.sCurrent.push(sqlExpression4);
        expressionArgumentHelper.argument = sqlExpression4;
        sQLMultiplicativeExpressionOperand.f1.accept(this, object);
        sqlExpression2.setRightExpr(expressionArgumentHelper.argument);
        expressionArgumentHelper.argument = sqlExpression2;
        sqlExpression3 = this.sCurrent.pop();
        sqlExpression2.setExprString(sqlExpression2.getExprString() + sqlExpression3.getExprString());
        return null;
    }

    public Object visit(SimpleExpressionOperand simpleExpressionOperand, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        SqlExpression sqlExpression2 = new SqlExpression();
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        SqlExpression sqlExpression3 = this.sCurrent.pop();
        sqlExpression2.setExprString(sqlExpression2.getExprString() + sqlExpression3.getExprString());
        this.sCurrent.push(sqlExpression2);
        sqlExpression2.setLeftExpr(sqlExpression);
        switch (simpleExpressionOperand.f0.which) {
            case 0: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("+");
                break;
            }
            case 1: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("-");
                break;
            }
            case 2: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("||");
                break;
            }
            case 3: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("|/");
                break;
            }
            case 4: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("||/");
                break;
            }
            case 5: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("!!");
                break;
            }
            case 6: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("@");
                break;
            }
            case 7: {
                sqlExpression2.setExprType(16);
                sqlExpression2.setOperator("~");
                break;
            }
        }
        simpleExpressionOperand.f0.accept(this, object);
        SqlExpression sqlExpression4 = new SqlExpression();
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        this.sCurrent.push(sqlExpression4);
        expressionArgumentHelper.argument = sqlExpression4;
        simpleExpressionOperand.f1.accept(this, object);
        sqlExpression2.setRightExpr(expressionArgumentHelper.argument);
        expressionArgumentHelper.argument = sqlExpression2;
        sqlExpression3 = this.sCurrent.pop();
        sqlExpression2.setExprString(sqlExpression2.getExprString() + sqlExpression3.getExprString());
        return null;
    }

    public Object visit(TableColumn tableColumn, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        tableColumn.f0.accept(this, object);
        return sqlExpression;
    }

    public Object visit(extendbObject extendbObject2, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(4);
        sqlExpression.setColumn(new AttributeColumn());
        IdentifierHandler identifierHandler = new IdentifierHandler();
        switch (extendbObject2.f0.which) {
            case 0: {
                TableNameHandler tableNameHandler = new TableNameHandler(this.commandToExecute.getClientContext());
                ((NodeSequence)extendbObject2.f0.choice).elementAt(0).accept(tableNameHandler, null);
                String string = tableNameHandler.getTableName();
                sqlExpression.getColumn().columnName = (String)((NodeSequence)extendbObject2.f0.choice).elementAt(2).accept(identifierHandler, object);
                sqlExpression.getColumn().setTableAlias(string);
                sqlExpression.setOuterAlias(sqlExpression.getColumn().columnName);
                break;
            }
            case 1: {
                sqlExpression.getColumn().columnName = (String)extendbObject2.f0.choice.accept(identifierHandler, object);
                sqlExpression.setAlias(sqlExpression.setOuterAlias(sqlExpression.getColumn().columnName));
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
        }
        return null;
    }

    public Object visit(numberValue numberValue2, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        numberValue2.f0.accept(this, object);
        return null;
    }

    public Object visit(stringLiteral stringLiteral2, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setConstantValue(stringLiteral2.f0.tokenImage);
        sqlExpression.setExprType(2);
        stringLiteral2.f0.accept(this, object);
        return null;
    }

    public Object visit(TextLiterals textLiterals, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = 2005;
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(textLiterals.f0.tokenImage);
        return null;
    }

    public Object visit(PreparedStmtParameter preparedStmtParameter, Object object) {
        SqlExpression sqlExpression = this.getSqlExpression(object);
        sqlExpression.setExprType(1024);
        sqlExpression.setExprDataType(new ExpressionType());
        int n = Integer.parseInt(preparedStmtParameter.f0.tokenImage.substring(1));
        this.commandToExecute.registerParameter(n, sqlExpression);
        sqlExpression.setParamNumber(Integer.valueOf(preparedStmtParameter.f0.tokenImage.substring(1)));
        return null;
    }

    public Object visit(hex_decimalLiteral hex_decimalLiteral2, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = -2;
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(hex_decimalLiteral2.f0.tokenImage);
        return null;
    }

    public Object visit(binaryLiteral binaryLiteral2, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = -2;
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(binaryLiteral2.f0.tokenImage);
        return null;
    }

    public Object visit(FloatingPointNumber floatingPointNumber, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        NodeToken nodeToken = (NodeToken)floatingPointNumber.f0.choice;
        sqlExpression.setConstantValue(nodeToken.tokenImage);
        return null;
    }

    private SqlExpression getSqlExpression(Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        if (sqlExpression == null) {
            sqlExpression = new SqlExpression();
        }
        return sqlExpression;
    }

    public Object visit(SQLComplexExpression sQLComplexExpression, Object object) {
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
        SqlExpression sqlExpression = this.getSqlExpression(object);
        sQLComplexExpression.accept(queryConditionHandler, object);
        QueryCondition queryCondition = queryConditionHandler.aRootCondition;
        if (queryCondition.getCondType() == 4) {
            SqlExpression.copy(queryCondition.getExpr(), sqlExpression);
            sqlExpression.setExprString("(" + sqlExpression.getExprString());
        } else {
            sqlExpression.setQueryCondition(queryCondition);
            sqlExpression.setExprType(128);
            this.makeExpressionString(queryCondition.getCondString());
        }
        return null;
    }

    public Object visit(NodeToken nodeToken, Object object) {
        this.makeExpressionString(nodeToken.tokenImage);
        return null;
    }

    private void makeExpressionString(String string) {
        try {
            SqlExpression sqlExpression = this.sCurrent.peek();
            sqlExpression.setExprString(sqlExpression.getExprString() + string);
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
    }

    public void updateQuery(String string) {
        this.makeExpressionString(string);
    }

    public void update(Observable observable, Object object) {
        this.updateQuery((String)object);
    }

    public Object visit(booleanLiteral booleanLiteral2, Object object) {
        booleanLiteral2.f0.accept(this, object);
        NodeToken nodeToken = (NodeToken)booleanLiteral2.f0.choice;
        SqlExpression sqlExpression = this.getSqlExpression(object);
        sqlExpression.setConstantValue(nodeToken.tokenImage);
        sqlExpression.setExprType(2);
        return null;
    }

    public Object visit(NullLiterals nullLiterals, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setConstantValue(null);
        sqlExpression.setExprType(2);
        nullLiterals.f0.accept(this, object);
        return null;
    }

    public Object visit(IntervalLiterals intervalLiterals, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = 1111;
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(intervalLiterals.f0.tokenImage);
        return null;
    }

    public Object visit(IntegerLiteral integerLiteral, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = 4;
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(integerLiteral.f0.tokenImage);
        return null;
    }

    public Object visit(TimeStampLiteral timeStampLiteral, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, ExpressionType.TIMESTAMPLEN, 0, 0);
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(timeStampLiteral.f0.tokenImage);
        return null;
    }

    public Object visit(TimeLiteral timeLiteral, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(92, ExpressionType.TIMELEN, 0, 0);
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(timeLiteral.f0.tokenImage);
        return null;
    }

    public Object visit(DateLiteral dateLiteral, Object object) {
        ExpressionArgumentHelper expressionArgumentHelper = (ExpressionArgumentHelper)object;
        SqlExpression sqlExpression = expressionArgumentHelper.argument;
        sqlExpression.setExprType(2);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(91, ExpressionType.DATELEN, 0, 0);
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(dateLiteral.f0.tokenImage);
        return null;
    }
}

