/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QuerySubTreeHelper;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.core.syntaxtree.ExistsClause;
import com.edb.gridsql.parser.core.syntaxtree.IsBooleanClause;
import com.edb.gridsql.parser.core.syntaxtree.IsNullClause;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.Relop;
import com.edb.gridsql.parser.core.syntaxtree.SQLAndExp;
import com.edb.gridsql.parser.core.syntaxtree.SQLAndExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLBetweenClause;
import com.edb.gridsql.parser.core.syntaxtree.SQLComplexExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLCondResult;
import com.edb.gridsql.parser.core.syntaxtree.SQLInClause;
import com.edb.gridsql.parser.core.syntaxtree.SQLLikeClause;
import com.edb.gridsql.parser.core.syntaxtree.SQLORExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLRelationalExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLRelationalOperatorExpression;
import com.edb.gridsql.parser.core.syntaxtree.SQLUnaryLogicalExpression;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.QueryConditionHelper;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.SQLExpressionHandler;
import com.edb.gridsql.parser.handler.SQLExpressionListHandler;
import java.util.Observable;
import java.util.Stack;
import java.util.Vector;

public class QueryConditionHandler
extends ObjectDepthFirst {
    private static final XLogger logger = XLogger.getLogger(QueryConditionHandler.class);
    public QueryCondition aRootCondition;
    private Command commandToExecute;
    private boolean handleLeftOuterNeeded;
    private boolean handleInnerJoinNeeded;
    public Vector<QueryCondition> queryCondList = new Vector();
    public Vector<QueryCondition> innerQueryCondList = new Vector();
    private Stack<QueryCondition> sCurrent = new Stack();

    public QueryConditionHandler(Command command) {
        this.commandToExecute = command;
    }

    public boolean isHandleLeftOuterNeeded() {
        return this.handleLeftOuterNeeded;
    }

    public void setHandleLeftOuterNeeded(boolean bl) {
        this.handleLeftOuterNeeded = bl;
    }

    public boolean isHandleInnerJoinNeeded() {
        return this.handleInnerJoinNeeded;
    }

    public void setHandleInnerJoinNeeded(boolean bl) {
        this.handleInnerJoinNeeded = bl;
    }

    public Object visit(SQLComplexExpression sQLComplexExpression, Object object) {
        QueryCondition queryCondition = this.createQueryCondition();
        this.sCurrent.push(queryCondition);
        QueryConditionHelper queryConditionHelper = new QueryConditionHelper(queryCondition);
        sQLComplexExpression.f0.accept(this, queryConditionHelper);
        sQLComplexExpression.f1.accept(this, queryConditionHelper);
        this.aRootCondition = (QueryCondition)queryConditionHelper.getArgument();
        this.sCurrent.pop();
        return null;
    }

    public Object visit(SQLAndExpression sQLAndExpression, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        sQLAndExpression.f0.accept(this, queryConditionHelper);
        if (sQLAndExpression.f1.present()) {
            this.handleLeftOuterNeeded = true;
            this.queryCondList.add((QueryCondition)queryConditionHelper.getArgument());
        } else if (((QueryCondition)queryConditionHelper.getArgument()).getRightCond() != null && ((QueryCondition)queryConditionHelper.getArgument()).getRightCond().getExpr() != null && ((QueryCondition)queryConditionHelper.getArgument()).getRightCond().getExpr().getExprType() == 4) {
            this.handleInnerJoinNeeded = true;
            this.innerQueryCondList.add((QueryCondition)queryConditionHelper.getArgument());
        }
        sQLAndExpression.f2.accept(this, queryConditionHelper);
        return null;
    }

    public Object visit(SQLAndExp sQLAndExp, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = this.sCurrent.pop();
        QueryCondition queryCondition2 = this.createQueryCondition();
        queryCondition2.setCondString(queryCondition2.getCondString() + queryCondition.getCondString());
        queryCondition2.setOperator("AND");
        queryCondition2.setCondType(8);
        queryCondition2.setLeftCond((QueryCondition)queryConditionHelper.getArgument());
        this.sCurrent.push(queryCondition2);
        sQLAndExp.f0.accept(this, object);
        QueryCondition queryCondition3 = this.createQueryCondition();
        this.sCurrent.push(queryCondition3);
        QueryConditionHelper queryConditionHelper2 = new QueryConditionHelper(queryCondition3);
        sQLAndExp.f1.accept(this, queryConditionHelper2);
        queryCondition2.setRightCond((QueryCondition)queryConditionHelper2.getArgument());
        if (sQLAndExp.f2.present()) {
            if (!this.handleLeftOuterNeeded) {
                this.handleLeftOuterNeeded = true;
            }
            this.queryCondList.add(queryCondition2.getRightCond());
        } else if (queryCondition2.getRightCond().getRightCond() != null && queryCondition2.getRightCond().getRightCond().getExpr() != null && queryCondition2.getRightCond().getRightCond().getExpr().getExprType() == 4) {
            if (!this.handleInnerJoinNeeded) {
                this.handleInnerJoinNeeded = true;
            }
            this.innerQueryCondList.add(queryCondition2.getRightCond());
        }
        ((QueryConditionHelper)object).setArgument(queryCondition2);
        queryCondition2.setCondString(queryCondition2.getCondString() + ((QueryCondition)queryConditionHelper2.getArgument()).getCondString());
        this.sCurrent.pop();
        return null;
    }

    public Object visit(SQLORExpression sQLORExpression, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = this.createQueryCondition();
        QueryCondition queryCondition2 = this.sCurrent.pop();
        queryCondition.setCondString(queryCondition2.getCondString() + queryCondition.getCondString());
        this.sCurrent.push(queryCondition);
        queryCondition.setOperator("OR");
        queryCondition.setCondType(8);
        queryCondition.setLeftCond((QueryCondition)queryConditionHelper.getArgument());
        sQLORExpression.f0.accept(this, object);
        QueryCondition queryCondition3 = this.createQueryCondition();
        this.sCurrent.push(queryCondition3);
        QueryConditionHelper queryConditionHelper2 = new QueryConditionHelper(queryCondition3);
        sQLORExpression.f1.accept(this, queryConditionHelper2);
        queryCondition.setRightCond((QueryCondition)queryConditionHelper2.getArgument());
        ((QueryConditionHelper)object).setArgument(queryCondition);
        queryCondition.setCondString(queryCondition.getCondString() + queryCondition3.getCondString());
        this.sCurrent.pop();
        return null;
    }

    public Object visit(SQLUnaryLogicalExpression sQLUnaryLogicalExpression, Object object) {
        switch (sQLUnaryLogicalExpression.f0.which) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                NodeSequence nodeSequence = (NodeSequence)sQLUnaryLogicalExpression.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(0);
                if (!nodeOptional.present()) break;
                QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
                QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
                queryCondition.setPositive(false);
            }
        }
        sQLUnaryLogicalExpression.f0.accept(this, object);
        return null;
    }

    public Object visit(SQLCondResult sQLCondResult, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        queryCondition.setCondType(4);
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setRightExpr(null);
        sqlExpression.setLeftExpr(null);
        sqlExpression.setConstantValue("1");
        sqlExpression.setExprType(2);
        queryCondition.setExpr(sqlExpression);
        QueryCondition queryCondition2 = new QueryCondition();
        queryCondition2.setCondType(4);
        queryCondition2.setExpr(sqlExpression);
        QueryCondition queryCondition3 = new QueryCondition();
        queryCondition3.setLeftCond(queryCondition);
        queryCondition3.setRightCond(queryCondition2);
        String string = "";
        string = sQLCondResult.f0.which == 0 ? "=" : "<>";
        queryCondition3.setOperator(string);
        queryCondition3.setCondType(16);
        queryConditionHelper.setArgument(queryCondition3);
        return null;
    }

    public Object visit(SQLRelationalExpression sQLRelationalExpression, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        switch (sQLRelationalExpression.f0.which) {
            case 0: {
                sQLRelationalExpression.f0.accept(this, object);
                break;
            }
            case 1: {
                SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
                sQLRelationalExpression.f0.accept(sQLExpressionHandler, object);
                if (sQLExpressionHandler.aroot.getExprType() == 128) {
                    queryConditionHelper.setArgument(sQLExpressionHandler.aroot.getQueryCondition());
                    break;
                }
                ((QueryCondition)queryConditionHelper.getArgument()).setExpr(sQLExpressionHandler.aroot);
                ((QueryCondition)queryConditionHelper.getArgument()).setCondType(4);
                ((QueryCondition)queryConditionHelper.getArgument()).setCondString(sQLExpressionHandler.aroot.getExprString());
                if (sQLExpressionHandler.aroot.getExprType() != 64) break;
                sQLExpressionHandler.aroot.getSubqueryTree().setQueryType(6);
                break;
            }
        }
        sQLRelationalExpression.f1.accept(this, queryConditionHelper);
        return null;
    }

    public Object visit(SQLRelationalOperatorExpression sQLRelationalOperatorExpression, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        if (queryConditionHelper == null || queryConditionHelper.getArgument() == null) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_FUNCTION_CALL + "(  visit (SQLRElationalOperator" + "Expression) ) ", 0, ErrorMessageRepository.ILLEGAL_FUNCTION_CALL_CODE);
        }
        QueryCondition queryCondition = this.createQueryCondition();
        QueryCondition queryCondition2 = this.sCurrent.pop();
        queryCondition.setCondString(queryCondition2.getCondString() + queryCondition.getCondString());
        this.sCurrent.push(queryCondition);
        QueryConditionHelper queryConditionHelper2 = new QueryConditionHelper(queryCondition);
        sQLRelationalOperatorExpression.f0.accept(this, queryConditionHelper2);
        QueryCondition queryCondition3 = (QueryCondition)queryConditionHelper2.getArgument();
        QueryCondition queryCondition4 = this.createQueryCondition();
        this.sCurrent.push(queryCondition4);
        SqlExpression sqlExpression = null;
        String string = null;
        boolean bl = false;
        switch (sQLRelationalOperatorExpression.f1.which) {
            case 0: {
                NodeChoice nodeChoice;
                NodeSequence nodeSequence = (NodeSequence)sQLRelationalOperatorExpression.f1.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(0);
                boolean bl2 = true;
                if (nodeOptional.present()) {
                    bl2 = false;
                    nodeChoice = (NodeChoice)nodeOptional.node;
                    switch (nodeChoice.which) {
                        case 0: {
                            string = "ALL ";
                            break;
                        }
                        case 1: {
                            string = "ANY  ";
                            break;
                        }
                        case 2: {
                            string = "SOME  ";
                            break;
                        }
                    }
                    bl = true;
                } else {
                    bl2 = true;
                }
                nodeChoice = (NodeChoice)nodeSequence.elementAt(1);
                if (nodeChoice.which == 0) {
                    QueryTree queryTree = new QueryTree();
                    QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
                    NodeSequence nodeSequence2 = (NodeSequence)nodeChoice.choice;
                    Node node = nodeSequence2.elementAt(1);
                    node.accept(queryTreeHandler, queryTree);
                    sqlExpression = new SqlExpression();
                    if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
                        // empty if block
                    }
                    sqlExpression.setExprType(64);
                    sqlExpression.setSubqueryTree(queryTree);
                    if (bl2) {
                        queryTree.setQueryType(6);
                    } else {
                        queryTree.setQueryType(24);
                    }
                    if (this.commandToExecute.getCommandToExecute() == 1) {
                        QuerySubTreeHelper querySubTreeHelper = queryTree.processSubTree(sqlExpression, this.commandToExecute.getaQueryTreeTracker());
                        if (querySubTreeHelper.createdRelationNode != null) {
                            queryCondition4.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                        }
                        if (querySubTreeHelper.projectedSqlExpression != null) {
                            queryCondition4.setProjectedColumns(querySubTreeHelper.projectedSqlExpression);
                        }
                        if (querySubTreeHelper.correlatedColumnExprList != null) {
                            queryCondition4.setCorrelatedColumns(querySubTreeHelper.getCorrelatedColumnAttributed());
                        }
                    }
                } else {
                    SQLExpressionListHandler sQLExpressionListHandler = new SQLExpressionListHandler(this.commandToExecute);
                    NodeSequence nodeSequence3 = (NodeSequence)nodeChoice.choice;
                    Node node = nodeSequence3.elementAt(1);
                    node.accept(sQLExpressionListHandler, object);
                    sqlExpression = new SqlExpression();
                    sqlExpression.setExprType(512);
                    sqlExpression.setExpressionList(sQLExpressionListHandler.vSqlExpressionList);
                }
                if (!bl) break;
                queryCondition4.setAnyAllFlag(bl);
                queryCondition4.setAnyAllString(string);
                break;
            }
            case 1: {
                SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
                sQLRelationalOperatorExpression.f1.accept(sQLExpressionHandler, object);
                sqlExpression = sQLExpressionHandler.aroot;
                break;
            }
        }
        if (sqlExpression == null) {
            throw new XDBServerException(ErrorMessageRepository.COMMAND_NOT_IMPLEMENTED, 0, ErrorMessageRepository.COMMAND_NOT_IMPLEMENTED_CODE);
        }
        queryCondition4.setCondType(4);
        queryCondition4.setExpr(sqlExpression);
        queryCondition4.setCondString(sqlExpression.getExprString());
        queryCondition3.setRightCond(queryCondition4);
        queryCondition3.setLeftCond((QueryCondition)queryConditionHelper.getArgument());
        queryConditionHelper.setArgument(queryCondition3);
        this.sCurrent.pop();
        queryCondition3.setCondString(queryCondition3.getCondString() + queryCondition4.getCondString());
        return null;
    }

    public Object visit(Relop relop, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        queryCondition.setOperator(((NodeToken)relop.f0.choice).tokenImage);
        queryCondition.setCondType(16);
        relop.f0.accept(this, object);
        return null;
    }

    public Object visit(SQLInClause sQLInClause, Object object) {
        sQLInClause.f0.accept(this, object);
        boolean bl = true;
        if (sQLInClause.f0.present()) {
            bl = false;
        }
        sQLInClause.f1.accept(this, object);
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        SqlExpression sqlExpression = null;
        if (queryCondition.getCondType() == 4) {
            sqlExpression = queryCondition.getExpr();
        }
        Vector vector = null;
        switch (sQLInClause.f2.which) {
            case 1: {
                SQLExpressionListHandler sQLExpressionListHandler = new SQLExpressionListHandler(this.commandToExecute);
                sQLInClause.f2.accept(sQLExpressionListHandler, object);
                vector = sQLExpressionListHandler.vSqlExpressionList;
                QueryCondition queryCondition2 = queryCondition;
                queryCondition2.getClass();
                queryCondition.setACompositeClause(queryCondition2.new QueryCondition.InClauseList(vector, sqlExpression, bl, this.commandToExecute));
                break;
            }
            case 0: {
                QueryTree queryTree = new QueryTree();
                QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
                sQLInClause.f2.accept(queryTreeHandler, queryTree);
                QueryCondition queryCondition3 = queryCondition;
                queryCondition3.getClass();
                queryCondition.setACompositeClause(queryCondition3.new QueryCondition.InClauseTree(queryTree, sqlExpression, bl, this.commandToExecute));
                break;
            }
        }
        sQLInClause.f3.accept(this, object);
        queryCondition.setCondType(2);
        queryConditionHelper.setArgument(queryCondition);
        queryCondition.setCondString(queryCondition.getACompositeClause().rebuildString());
        return null;
    }

    public Object visit(SQLBetweenClause sQLBetweenClause, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        SqlExpression sqlExpression = null;
        if (queryCondition.getCondType() == 4) {
            sqlExpression = queryCondition.getExpr();
        }
        boolean bl = true;
        sQLBetweenClause.f0.accept(this, object);
        if (sQLBetweenClause.f0.present()) {
            bl = false;
        }
        sQLBetweenClause.f1.accept(this, object);
        SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
        sQLBetweenClause.f2.accept(sQLExpressionHandler, object);
        SqlExpression sqlExpression2 = sQLExpressionHandler.aroot;
        sQLBetweenClause.f3.accept(this, object);
        SQLExpressionHandler sQLExpressionHandler2 = new SQLExpressionHandler(this.commandToExecute);
        sQLBetweenClause.f4.accept(sQLExpressionHandler2, object);
        SqlExpression sqlExpression3 = sQLExpressionHandler2.aroot;
        QueryCondition queryCondition2 = queryCondition;
        queryCondition2.getClass();
        queryCondition.setACompositeClause(queryCondition2.new QueryCondition.BetweenClause(sqlExpression2, sqlExpression3, sqlExpression, bl, this.commandToExecute));
        queryCondition.setCondType(2);
        queryConditionHelper.setArgument(queryCondition);
        queryCondition.setCondString(queryCondition.getACompositeClause().rebuildString());
        return null;
    }

    public Object visit(SQLLikeClause sQLLikeClause, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        SqlExpression sqlExpression = null;
        if (queryCondition.getCondType() == 4) {
            sqlExpression = queryCondition.getExpr();
        }
        boolean bl = true;
        String string = null;
        SqlExpression sqlExpression2 = null;
        SqlExpression sqlExpression3 = null;
        NodeSequence nodeSequence = (NodeSequence)sQLLikeClause.f0.choice;
        if (sQLLikeClause.f0.which == 0) {
            if (((NodeOptional)nodeSequence.elementAt(0)).present()) {
                bl = false;
            }
            string = ((NodeToken)((NodeChoice)nodeSequence.elementAt((int)1)).choice).tokenImage;
            SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
            nodeSequence.elementAt(2).accept(sQLExpressionHandler, object);
            sqlExpression2 = sQLExpressionHandler.aroot;
            NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(3);
            if (nodeOptional.present()) {
                SQLExpressionHandler sQLExpressionHandler2 = new SQLExpressionHandler(this.commandToExecute);
                NodeSequence nodeSequence2 = (NodeSequence)nodeOptional.node;
                nodeSequence2.elementAt(1).accept(sQLExpressionHandler2, object);
                sqlExpression3 = sQLExpressionHandler2.aroot;
            }
        } else {
            string = ((NodeToken)((NodeChoice)nodeSequence.elementAt((int)0)).choice).tokenImage;
            SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
            nodeSequence.elementAt(1).accept(sQLExpressionHandler, object);
            sqlExpression2 = sQLExpressionHandler.aroot;
        }
        QueryCondition queryCondition2 = queryCondition;
        queryCondition2.getClass();
        queryCondition.setACompositeClause(queryCondition2.new QueryCondition.CLikeClause(sqlExpression, sqlExpression2, bl, string, this.commandToExecute, sqlExpression3));
        return null;
    }

    public Object visit(IsNullClause isNullClause, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        SqlExpression sqlExpression = null;
        if (queryCondition.getCondType() == 4) {
            sqlExpression = queryCondition.getExpr();
        }
        boolean bl = true;
        switch (isNullClause.f0.which) {
            case 0: {
                NodeSequence nodeSequence = (NodeSequence)isNullClause.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
                if (!nodeOptional.present()) break;
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
            }
        }
        QueryCondition queryCondition2 = queryCondition;
        queryCondition2.getClass();
        queryCondition.setACompositeClause(queryCondition2.new QueryCondition.CheckNullClause(sqlExpression, bl, this.commandToExecute));
        return null;
    }

    public Object visit(IsBooleanClause isBooleanClause, Object object) {
        Object var3_3 = null;
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        SqlExpression sqlExpression = null;
        if (queryCondition.getCondType() == 4) {
            sqlExpression = queryCondition.getExpr();
        }
        boolean bl = true;
        switch (isBooleanClause.f0.which) {
            case 0: {
                NodeSequence nodeSequence = (NodeSequence)isBooleanClause.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
                if (!nodeOptional.present()) break;
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
            }
        }
        boolean bl2 = true;
        switch (isBooleanClause.f1.which) {
            case 1: {
                bl2 = false;
            }
        }
        QueryCondition queryCondition2 = queryCondition;
        queryCondition2.getClass();
        queryCondition.setACompositeClause(queryCondition2.new QueryCondition.CheckBooleanClause(sqlExpression, bl, bl2, this.commandToExecute));
        return var3_3;
    }

    private QueryCondition createQueryCondition() {
        QueryCondition queryCondition = new QueryCondition();
        return queryCondition;
    }

    public Object visit(NodeToken nodeToken, Object object) {
        switch (nodeToken.kind) {
            default: 
        }
        this.MakeExpressionString(nodeToken.tokenImage);
        return null;
    }

    private void MakeExpressionString(String string) {
        try {
            QueryCondition queryCondition = this.sCurrent.peek();
            queryCondition.setCondString("" + queryCondition.getCondString() + " " + string);
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.IMBALANCE_IN_EXPRESSION_STACK, 0, ErrorMessageRepository.IMBALANCE_IN_EXPRESSION_STACK_CODE);
        }
    }

    public void updateQuery(String string) {
        this.MakeExpressionString(string);
    }

    public void update(Observable observable, Object object) {
        this.updateQuery((String)object);
    }

    public Object visit(ExistsClause existsClause, Object object) {
        QueryConditionHelper queryConditionHelper = (QueryConditionHelper)object;
        QueryCondition queryCondition = (QueryCondition)queryConditionHelper.getArgument();
        existsClause.f0.accept(this, object);
        boolean bl = true;
        if (existsClause.f0.present()) {
            bl = false;
        }
        existsClause.f1.accept(this, object);
        existsClause.f2.accept(this, object);
        QueryTree queryTree = new QueryTree();
        queryTree.setPartOfExistClause(true);
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        existsClause.f3.accept(queryTreeHandler, queryTree);
        existsClause.f4.accept(this, object);
        QueryCondition queryCondition2 = queryCondition;
        queryCondition2.getClass();
        queryCondition.setACompositeClause(queryCondition2.new QueryCondition.ExistClause(queryTree, bl, this.commandToExecute));
        queryCondition.setCondType(2);
        queryConditionHelper.setArgument(queryCondition);
        queryCondition.setCondString(queryCondition.getACompositeClause().rebuildString());
        return null;
    }
}

