/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.metadata.SysViewColumns;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import com.edb.gridsql.parser.core.ParseException;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.FromTableSpec;
import com.edb.gridsql.parser.core.syntaxtree.JoinSpec;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.SelectAliasSpec;
import com.edb.gridsql.parser.core.syntaxtree.TableName;
import com.edb.gridsql.parser.core.syntaxtree.TableSpec;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.AliasSpecHandler;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromClauseHandler
extends ObjectDepthFirst {
    Command commandToExecute;
    short outerCounter = 0;

    public FromClauseHandler(Command command) {
        this.commandToExecute = command;
    }

    @Override
    public Object visit(FromTableSpec fromTableSpec, Object object) {
        QueryTree queryTree = (QueryTree)object;
        QueryCondition queryCondition = null;
        RelationNode relationNode = null;
        ArrayList<SqlExpression> arrayList = null;
        RelationNode relationNode2 = (RelationNode)fromTableSpec.f0.accept(this, object);
        relationNode2.handleAliasForSingleTableSubQueryNode();
        if (fromTableSpec.f1.present()) {
            Enumeration enumeration = fromTableSpec.f1.elements();
            block23: while (enumeration.hasMoreElements()) {
                NodeChoice nodeChoice = (NodeChoice)enumeration.nextElement();
                relationNode = relationNode2;
                NodeChoice nodeChoice2 = null;
                block0 : switch (nodeChoice.which) {
                    case 0: {
                        NodeSequence nodeSequence = (NodeSequence)nodeChoice.choice;
                        TableSpec tableSpec = (TableSpec)nodeSequence.nodes.get(2);
                        relationNode2 = (RelationNode)tableSpec.accept(this, object);
                        relationNode2.handleAliasForSingleTableSubQueryNode();
                        relationNode2.addSiblingJoin(relationNode);
                        break;
                    }
                    case 1: {
                        Object object2;
                        Node node;
                        TableSpec tableSpec;
                        NodeSequence nodeSequence;
                        nodeChoice2 = (NodeChoice)nodeChoice.choice;
                        block5 : switch (nodeChoice2.which) {
                            case 0: {
                                nodeSequence = (NodeSequence)nodeChoice2.choice;
                                tableSpec = (TableSpec)nodeSequence.nodes.get(2);
                                relationNode2 = (RelationNode)tableSpec.accept(this, object);
                                relationNode2.handleAliasForSingleTableSubQueryNode();
                                node = (JoinSpec)nodeSequence.nodes.get(3);
                                object2 = (QueryCondition)((JoinSpec)node).accept(this, object);
                                Vector<QueryCondition> vector = QueryCondition.getNodes((QueryCondition)object2, 4);
                                arrayList = new ArrayList<SqlExpression>();
                                for (QueryCondition queryCondition2 : vector) {
                                    arrayList.add(queryCondition2.getExpr());
                                }
                                QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(arrayList.iterator(), queryTree.getRelationNodeList(), null, 2, this.commandToExecute.getaQueryTreeTracker(), this.commandToExecute.getClientContext().getSysDatabase());
                                HashSet<RelationNode> hashSet = new HashSet();
                                for (Object object3 : queryTree.getRelationNodeList()) {
                                    if (object3 == relationNode2) continue;
                                    for (QueryCondition queryCondition3 : vector) {
                                        if (!queryCondition3.getExpr().contains((RelationNode)object3)) continue;
                                        relationNode2.addSiblingJoin((RelationNode)object3);
                                    }
                                }
                                continue block23;
                            }
                            case 1: {
                                HashSet<RelationNode> hashSet;
                                Vector<QueryCondition> vector;
                                NodeSequence nodeSequence2 = (NodeSequence)nodeChoice2.choice;
                                queryTree.setOuterJoin(true);
                                switch (((NodeChoice)nodeSequence2.elementAt((int)0)).which) {
                                    case 0: {
                                        Object object3;
                                        relationNode2 = (RelationNode)nodeSequence2.elementAt(3).accept(this, object);
                                        relationNode2.handleAliasForSingleTableSubQueryNode();
                                        object2 = (QueryCondition)nodeSequence2.elementAt(4).accept(this, object);
                                        vector = QueryCondition.getNodes((QueryCondition)object2, 4);
                                        arrayList = new ArrayList();
                                        for (QueryCondition queryCondition4 : vector) {
                                            arrayList.add(queryCondition4.getExpr());
                                        }
                                        QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(arrayList.iterator(), queryTree.getRelationNodeList(), null, 2, this.commandToExecute.getaQueryTreeTracker(), this.commandToExecute.getClientContext().getSysDatabase());
                                        hashSet = new HashSet<RelationNode>();
                                        object3 = queryTree.getRelationNodeList().iterator();
                                        block28: while (object3.hasNext()) {
                                            RelationNode relationNode3 = (RelationNode)object3.next();
                                            if (relationNode3 == relationNode2) continue;
                                            for (QueryCondition queryCondition5 : vector) {
                                                if (!queryCondition5.getExpr().contains(relationNode3)) continue;
                                                hashSet.add(relationNode3);
                                                continue block28;
                                            }
                                        }
                                        this.outerCounter = (short)(this.outerCounter + 1);
                                        relationNode2.addParentNodes(hashSet, true, this.outerCounter);
                                        break block5;
                                    }
                                    case 1: {
                                        throw new XDBServerException("Not implemented yet (right outer join).");
                                    }
                                    case 2: {
                                        throw new XDBServerException("Not implemented yet (full join).");
                                    }
                                }
                            }
                        }
                        continue block23;
                    }
                    case 2: {
                        Object object2;
                        Node node = (NodeSequence)nodeChoice.choice;
                        nodeChoice2 = (NodeChoice)((NodeSequence)node).elementAt(1);
                        switch (nodeChoice2.which) {
                            case 0: {
                                relationNode2 = (RelationNode)((NodeSequence)nodeChoice2.choice).elementAt(2).accept(this, object);
                                relationNode2.handleAliasForSingleTableSubQueryNode();
                                queryCondition = this.createQueryConditionForNaturalJoin(queryTree);
                                queryTree.getFromClauseConditions().add(queryCondition);
                                relationNode2.addSiblingJoin(relationNode);
                                break block0;
                            }
                            case 1: {
                                object2 = (NodeSequence)nodeChoice2.choice;
                                queryTree.setOuterJoin(true);
                                switch (((NodeChoice)((NodeSequence)object2).elementAt((int)0)).which) {
                                    case 0: {
                                        relationNode2 = (RelationNode)((NodeSequence)nodeChoice2.choice).elementAt(3).accept(this, object);
                                        relationNode2.handleAliasForSingleTableSubQueryNode();
                                        queryCondition = this.createQueryConditionForNaturalJoin(queryTree);
                                        queryTree.getFromClauseConditions().add(queryCondition);
                                        this.outerCounter = (short)(this.outerCounter + 1);
                                        relationNode2.addParentNodes(Collections.singleton(relationNode), true, this.outerCounter);
                                        break block0;
                                    }
                                    case 1: {
                                        throw new XDBServerException("Not implemented yet (natural right join).");
                                    }
                                    case 2: {
                                        throw new XDBServerException("Not implemented yet (natural full join).");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Object visit(JoinSpec joinSpec, Object object) {
        QueryTree queryTree = (QueryTree)object;
        QueryCondition queryCondition = null;
        switch (joinSpec.f0.which) {
            case 0: {
                NodeSequence nodeSequence = (NodeSequence)joinSpec.f0.choice;
                Node node = nodeSequence.elementAt(1);
                QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
                node.accept(queryConditionHandler, object);
                queryCondition = queryConditionHandler.aRootCondition;
                queryTree.getFromClauseConditions().add(queryCondition);
                break;
            }
            case 1: {
                NodeSequence nodeSequence = (NodeSequence)joinSpec.f0.choice;
                Node node = nodeSequence.elementAt(2);
                ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
                node.accept(columnNameListHandler, object);
                List<String> list = columnNameListHandler.getColumnNameList();
                List<RelationNode> list2 = queryTree.getRelationNodeList();
                ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = string = iterator.next();
                    RelationNode relationNode = list2.get(list2.size() - 1);
                    RelationNode relationNode2 = list2.get(list2.size() - 2);
                    SqlExpression sqlExpression = SqlExpression.getSqlColumnExpression(string2, relationNode.getTableName(), relationNode.getAlias(), string2, "+");
                    SqlExpression sqlExpression2 = SqlExpression.getSqlColumnExpression(string2, relationNode2.getTableName(), relationNode2.getAlias(), string2, "+");
                    QueryCondition queryCondition2 = new QueryCondition();
                    queryCondition2.setOperator("=");
                    queryCondition2.setCondType(16);
                    QueryCondition queryCondition3 = new QueryCondition();
                    queryCondition3.setCondType(4);
                    QueryCondition queryCondition4 = new QueryCondition();
                    queryCondition4.setCondType(4);
                    queryCondition3.setExpr(sqlExpression);
                    queryCondition4.setExpr(sqlExpression2);
                    queryCondition4.rebuildCondString();
                    queryCondition4.rebuildString();
                    queryCondition3.rebuildCondString();
                    queryCondition3.rebuildString();
                    queryCondition2.setLeftCond(queryCondition3);
                    queryCondition2.setRightCond(queryCondition4);
                    queryCondition2.rebuildCondString();
                    queryCondition2.rebuildString();
                    arrayList.add(queryCondition2);
                }
                queryCondition = this.createQueryConditionFromQueryConditionList(arrayList);
                queryTree.getFromClauseConditions().add(queryCondition);
            }
        }
        return queryCondition;
    }

    @Override
    public Object visit(TableSpec tableSpec, Object object) {
        QueryTree queryTree = (QueryTree)object;
        RelationNode relationNode = queryTree.newRelationNode();
        switch (tableSpec.f0.which) {
            case 0: {
                NodeSequence nodeSequence = (NodeSequence)tableSpec.f0.choice;
                TableName tableName = (TableName)nodeSequence.elementAt(0);
                TableNameHandler tableNameHandler = new TableNameHandler(this.commandToExecute.getClientContext());
                tableName.accept(tableNameHandler, null);
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
                if (this.commandToExecute.getClientContext().getSysDatabase().isViewExists(tableNameHandler.getTableName())) {
                    String string = this.commandToExecute.getClientContext().getSysDatabase().getSysView(tableNameHandler.getTableName()).getViewText();
                    Parser parser = new Parser(this.commandToExecute.getClientContext());
                    try {
                        parser.parseStatement(string);
                    }
                    catch (ParseException parseException) {
                        throw new XDBServerException("Failed to parse view statement: " + string);
                    }
                    relationNode.setNodeType(4);
                    SqlSelect sqlSelect = (SqlSelect)parser.getSqlObject();
                    QueryTree queryTree2 = sqlSelect.aQueryTree;
                    SysView sysView = this.commandToExecute.getClientContext().getSysDatabase().getSysView(tableNameHandler.getTableName());
                    if (sysView.getViewColumns() != null && sysView.getViewColumns().size() > 0) {
                        int n = 0;
                        Iterator<SysViewColumns> iterator = sysView.getViewColumns().iterator();
                        while (iterator.hasNext()) {
                            SysViewColumns sysViewColumns;
                            SysViewColumns sysViewColumns2 = sysViewColumns = iterator.next();
                            queryTree2.getProjectionList().get(n).setAlias(sysViewColumns2.getViewColumn());
                            queryTree2.getProjectionList().get(n).setOuterAlias(sysViewColumns2.getViewColumn());
                            ++n;
                        }
                    }
                    queryTree2.setParentTree(queryTree);
                    relationNode.setAlias(tableNameHandler.getTableName());
                    NodeOptional nodeOptional2 = (NodeOptional)nodeSequence.elementAt(1);
                    if (nodeOptional2.present()) {
                        relationNode.setAlias(((SelectAliasSpec)nodeOptional2.node).f1.f0.f0.choice.toString());
                    }
                    relationNode.setSubqueryTree(queryTree2);
                    if (relationNode.getAlias() == null || relationNode.getAlias().equals("")) {
                        relationNode.setAlias("TempTableGenerated" + RelationNode.getNextCount());
                        relationNode.setTableName(relationNode.getAlias());
                    } else {
                        relationNode.setTableName(relationNode.getAlias());
                    }
                    queryTree.getRelationSubqueryList().add(relationNode);
                    break;
                }
                relationNode.setNodeType(2);
                relationNode.setTableName(tableNameHandler.getTableName());
                relationNode.setTemporaryTable(tableNameHandler.isTemporary());
                relationNode.setClient(this.commandToExecute.getClientContext());
                relationNode.setAlias(tableNameHandler.getReferenceName());
                tableSpec.f0.accept(this, object);
                object = relationNode;
                this.HandleAlias(nodeOptional, object, relationNode, relationNode.getTableName());
                break;
            }
            case 1: {
                relationNode.setNodeType(4);
                QueryTree queryTree3 = new QueryTree();
                NodeSequence nodeSequence = (NodeSequence)tableSpec.f0.choice;
                Node node = nodeSequence.elementAt(1);
                QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
                queryTree3.setParentTree(queryTree);
                node.accept(queryTreeHandler, queryTree3);
                relationNode.setSubqueryTree(queryTree3);
                Node node2 = nodeSequence.elementAt(3);
                this.HandleAlias((NodeOptional)node2, object, relationNode, "");
                if (relationNode.getAlias() == null || relationNode.getAlias().equals("")) {
                    relationNode.setAlias("TempTableGenerated" + RelationNode.getNextCount());
                    relationNode.setTableName(relationNode.getAlias());
                } else {
                    relationNode.setTableName(relationNode.getAlias());
                }
                Node node3 = nodeSequence.elementAt(4);
                this.HandleColumnList((NodeOptional)node3, queryTree3);
                queryTree.getRelationSubqueryList().add(relationNode);
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
        }
        queryTree.getRelHandlerInfo().put(relationNode.getTableName(), relationNode);
        return relationNode;
    }

    private void HandleColumnList(NodeOptional nodeOptional, QueryTree queryTree) {
        if (nodeOptional.present()) {
            class ColumnNameListHandler
            extends ObjectDepthFirst {
                public Vector<String> nameList = new Vector();

                ColumnNameListHandler() {
                }

                public Object visit(ColumnNameList columnNameList, Object object) {
                    columnNameList.f0.accept(this, object);
                    columnNameList.f1.accept(this, object);
                    return null;
                }

                public Object visit(NodeToken nodeToken, Object object) {
                    if (!(nodeToken.tokenImage.equals(",") || nodeToken.tokenImage.equals(")") || nodeToken.tokenImage.equals("("))) {
                        this.nameList.add(nodeToken.tokenImage);
                    }
                    return null;
                }
            }
            ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
            nodeOptional.accept(columnNameListHandler, queryTree);
            Vector<String> vector = columnNameListHandler.nameList;
            if (vector.size() != queryTree.getProjectionList().size()) {
                throw new XDBServerException(ErrorMessageRepository.ALIAS_COUNT_UNEQUAL_SUBQUERY_PROJ + queryTree.rebuildString(), 0, ErrorMessageRepository.ALIAS_COUNT_UNEQUAL_SUBQUERY_PROJ_CODE);
            }
            int n = 0;
            for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
                sqlExpression.setOuterAlias(vector.get(n));
                sqlExpression.setAlias(sqlExpression.getOuterAlias());
                ++n;
            }
        }
    }

    private void HandleAlias(NodeOptional nodeOptional, Object object, RelationNode relationNode, String string) {
        if (nodeOptional.present()) {
            AliasSpecHandler aliasSpecHandler = new AliasSpecHandler();
            nodeOptional.accept(aliasSpecHandler, object);
            relationNode.setAlias(aliasSpecHandler.getAliasName());
        } else {
            relationNode.setAlias(string);
        }
    }

    private QueryCondition createQueryConditionForNaturalJoin(QueryTree queryTree) {
        List<RelationNode> list = queryTree.getRelationNodeList();
        RelationNode relationNode = list.get(list.size() - 1);
        Vector<SqlExpression> vector = this.GetListOfColumnsForNode(relationNode);
        Vector<SqlExpression> vector2 = new Vector<SqlExpression>();
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        for (int i = 0; i < list.size() - 1; ++i) {
            Vector<SqlExpression> vector3 = this.GetListOfColumnsForNode(list.get(i));
            for (SqlExpression sqlExpression : vector3) {
                for (SqlExpression sqlExpression2 : vector) {
                    if (!sqlExpression2.getAlias().toUpperCase().equals(sqlExpression.getAlias())) continue;
                    vector2.add(sqlExpression2);
                    QueryCondition queryCondition = new QueryCondition();
                    queryCondition.setOperator("=");
                    queryCondition.setCondType(16);
                    QueryCondition queryCondition2 = new QueryCondition();
                    queryCondition2.setCondType(4);
                    QueryCondition queryCondition3 = new QueryCondition();
                    queryCondition3.setCondType(4);
                    queryCondition2.setExpr(sqlExpression2);
                    queryCondition3.setExpr(sqlExpression);
                    queryCondition3.rebuildCondString();
                    queryCondition3.rebuildString();
                    queryCondition2.rebuildCondString();
                    queryCondition2.rebuildString();
                    queryCondition.setLeftCond(queryCondition2);
                    queryCondition.setRightCond(queryCondition3);
                    queryCondition.rebuildCondString();
                    queryCondition.rebuildString();
                    arrayList.add(queryCondition);
                }
            }
        }
        if (arrayList.size() == 0) {
            throw new XDBServerException("Tables do not have same columns.");
        }
        return this.createQueryConditionFromQueryConditionList(arrayList);
    }

    private QueryCondition createQueryConditionFromQueryConditionList(ArrayList arrayList) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.setCondType(8);
        int n = arrayList.size();
        if (n == 1) {
            queryCondition = (QueryCondition)arrayList.get(0);
        } else {
            QueryCondition queryCondition2 = new QueryCondition();
            queryCondition2.setLeftCond((QueryCondition)arrayList.get(n - 2));
            queryCondition2.setRightCond((QueryCondition)arrayList.get(n - 1));
            queryCondition2.setCondType(8);
            queryCondition2.setOperator("AND");
            for (int i = n - 3; i >= 0; --i) {
                QueryCondition queryCondition3 = new QueryCondition();
                queryCondition3.setLeftCond((QueryCondition)arrayList.get(i));
                queryCondition3.setRightCond(queryCondition2);
                queryCondition3.setCondType(8);
                queryCondition3.setOperator("AND");
                queryCondition3.rebuildCondString();
                queryCondition2 = queryCondition3;
            }
            queryCondition = queryCondition2;
        }
        queryCondition.rebuildCondString();
        queryCondition.rebuildString();
        return queryCondition;
    }

    private Vector<SqlExpression> GetListOfColumnsForNode(RelationNode relationNode) {
        Vector<SqlExpression> vector = new Vector<SqlExpression>();
        if (relationNode.getNodeType() == 2) {
            for (SysColumn sysColumn : MetaData.getMetaData().getSysDatabase(this.commandToExecute.getDBName()).getSysTable(relationNode.getTableName()).getColumns()) {
                if (sysColumn.getColName().equalsIgnoreCase("xrowid")) continue;
                SqlExpression sqlExpression = new SqlExpression();
                sqlExpression.setExprType(4);
                sqlExpression.setAlias(sysColumn.getColName().toUpperCase());
                AttributeColumn attributeColumn = new AttributeColumn();
                attributeColumn.columnAlias = sysColumn.getColName();
                attributeColumn.columnName = sysColumn.getColName();
                attributeColumn.setTableAlias(relationNode.getAlias());
                attributeColumn.setTableName(relationNode.getTableName());
                attributeColumn.rebuildString();
                sqlExpression.setColumn(attributeColumn);
                sqlExpression.rebuildExpression();
                vector.add(sqlExpression);
            }
        } else {
            vector.addAll(relationNode.getSubqueryTree().getProjectionList());
        }
        return vector;
    }
}

