/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Truncate;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTruncate
extends ObjectDepthFirst
implements IXDBSql,
IExecutable,
IPreparable {
    private XDBSessionContext client;
    private String aTableName;
    private String truncateStatement;
    private SysTable table;

    public SqlTruncate(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.table.getNodeList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, Collections.singletonList(this.table));
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.table.getNodeList());
        multinodeExecutor.executeCommand(this.truncateStatement, this.table.getNodeList(), true);
        return ExecutionResult.createSuccessResult(30);
    }

    @Override
    public boolean isPrepared() {
        return this.truncateStatement != null;
    }

    @Override
    public void prepare() throws Exception {
        this.table = this.client.getSysDatabase().getSysTable(this.aTableName);
        if (!this.table.getSysReferences().isEmpty()) {
            throw new XDBServerException("cannot truncate a table referenced in a foreign key constraint");
        }
        this.truncateStatement = "TRUNCATE TABLE " + IdentifierHandler.quote(this.table.getTableName());
    }

    @Override
    public Object visit(Truncate truncate, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        truncate.f2.accept(tableNameHandler, object);
        this.aTableName = tableNameHandler.getTableName();
        return var3_3;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

