/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncDropView;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DropView;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SqlDropView
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropView.class);
    private XDBSessionContext client;
    private String iViewName = null;
    private boolean prepare = false;

    public SqlDropView(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    public Object visit(DropView dropView, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        dropView.f2.accept(tableNameHandler, object);
        this.iViewName = tableNameHandler.getTableName();
        return var3_3;
    }

    public long getCost() {
        return 1L;
    }

    public LockSpecification getLockSpecs() {
        LockSpecification lockSpecification = new LockSpecification(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return lockSpecification;
    }

    public Collection getNodeList() {
        return new ArrayList(Collections.EMPTY_LIST);
    }

    public String getViewrName() {
        return this.iViewName;
    }

    public boolean isPrepared() {
        return this.prepare;
    }

    public void prepare() throws Exception {
        if (!this.isPrepared()) {
            if (this.client.getCurrentUser().getUserClass() != 0) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can drop users");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            this.prepare = true;
        }
    }

    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncDropView syncDropView = new SyncDropView(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncDropView.execute(this.client);
            metaData.commitTransaction(syncDropView);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        return ExecutionResult.createSuccessResult(23);
    }

    public boolean needCoordinatorConnection() {
        return false;
    }
}

