/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncDropUser;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DropUser;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropUser
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropUser.class);
    private XDBSessionContext client;
    private String iUserName = null;
    private SysLogin login;

    public SqlDropUser(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(DropUser dropUser, Object object) {
        Object var3_3 = null;
        this.iUserName = (String)dropUser.f2.accept(new IdentifierHandler(), object);
        return var3_3;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(list, list);
        return lockSpecification;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        List list = Collections.emptyList();
        return new ArrayList<DBNode>(list);
    }

    public String getUserName() {
        return this.iUserName;
    }

    public SysLogin getLogin() {
        return this.login;
    }

    @Override
    public boolean isPrepared() {
        return this.login != null;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.isPrepared()) {
            if (this.client.getCurrentUser().getUserClass() != 0) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can drop users");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            this.login = MetaData.getMetaData().getSysLogin(this.iUserName);
            this.login.canSetUserClass("STANDARD");
        }
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncDropUser syncDropUser = new SyncDropUser(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncDropUser.execute(this.client);
            metaData.commitTransaction(syncDropUser);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        return ExecutionResult.createSuccessResult(22);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

