/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncDropTable;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.dropTable;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropTable
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private XDBSessionContext client;
    private SysDatabase database;
    private SysTable table;
    private String dropTableSQL;
    private LinkedList<SysTable> refs = null;
    private boolean temporary;
    private String tablename;
    private String referenceName;

    public SqlDropTable(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public Object visit(dropTable dropTable2, Object object) {
        Object var3_3 = null;
        dropTable2.f0.accept(this, object);
        dropTable2.f1.accept(this, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        dropTable2.f2.accept(tableNameHandler, object);
        this.tablename = tableNameHandler.getTableName();
        this.referenceName = tableNameHandler.getReferenceName();
        this.temporary = tableNameHandler.isTemporary();
        return var3_3;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    public Collection<SysTable> getRelatedTables() {
        if (this.refs == null) {
            this.refs = new LinkedList();
            if (!this.isPrepared()) {
                try {
                    this.prepare();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Vector<SysReference> vector = this.table.getSysFkReferenceList();
            Vector<SysReference> vector2 = this.table.getSysReferences();
            for (SysReference sysReference : vector) {
                this.refs.add(this.database.getSysTable(sysReference.getRefTableID()));
            }
            for (SysReference sysReference : vector2) {
                SysForeignKey sysForeignKey = (SysForeignKey)sysReference.getForeignKeys().elementAt(0);
                SysTable sysTable = sysForeignKey.getReferringSysColumn(this.database).getSysTable();
                this.refs.add(sysTable);
            }
        }
        return this.refs;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        return new LockSpecification<SysTable>(this.getRelatedTables(), Collections.singletonList(this.table));
    }

    @Override
    public Collection<DBNode> getNodeList() {
        HashSet<DBNode> hashSet = new HashSet<DBNode>();
        if (this.table != null) {
            hashSet.addAll(this.table.getNodeList());
        }
        for (SysTable sysTable : this.getRelatedTables()) {
            hashSet.addAll(sysTable.getNodeList());
        }
        return hashSet;
    }

    public String getTablename() {
        return this.tablename;
    }

    public boolean isTempTable() {
        return this.temporary;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public boolean isPrepared() {
        return this.table != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        Vector<SysReference> vector;
        this.table = this.database.getSysTable(this.tablename);
        Enumeration enumeration = this.database.getAllViews();
        while (enumeration.hasMoreElements()) {
            vector = (SysView)enumeration.nextElement();
            if (!((SysView)((Object)vector)).hasDependedTable(this.table.getTableId())) continue;
            XDBSecurityException xDBSecurityException = new XDBSecurityException("cannot drop table " + this.tablename + " because other objects depend on it");
            throw xDBSecurityException;
        }
        if (this.client.getCurrentUser().getUserClass() != 0 && this.table.getOwner() != this.client.getCurrentUser()) {
            vector = new XDBSecurityException("You are not allowed to drop table " + this.tablename);
            throw vector;
        }
        if (this.table.getChildrenTables().size() > 0) {
            throw new XDBServerException("Table " + this.getReferenceName() + " has children tables. Please, remove them first");
        }
        vector = this.table.getSysReferences();
        if (vector != null && !vector.isEmpty()) {
            throw new XDBServerException("Table " + this.getReferenceName() + " has foreign references. Please, remove them first");
        }
        this.dropTableSQL = "DROP TABLE " + IdentifierHandler.quote(this.tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.dropTableSQL, this.table.getNodeList(), (IMetaDataUpdate)new SyncDropTable(this), this.client);
        if (this.temporary) {
            this.client.deregisterTempTableWithSession(this.referenceName);
        }
        this.table = null;
        ExecutionResult executionResult = ExecutionResult.createSuccessResult(19);
        return executionResult;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

