/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.HelperSysIndex;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncDropIndex;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DropIndex;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropIndex
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropIndex.class);
    private String indexName;
    private String tableName;
    private XDBSessionContext client;
    private SysDatabase database;
    private SysTable table;
    private SysIndex index;
    private String dropIndexSQL;

    public SqlDropIndex(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public Object visit(DropIndex dropIndex, Object object) {
        Object var3_3 = null;
        this.indexName = (String)dropIndex.f2.accept(new IdentifierHandler(), object);
        dropIndex.f3.accept(this, object);
        if (dropIndex.f3.present()) {
            TableNameHandler tableNameHandler = new TableNameHandler(this.client);
            dropIndex.f3.node.accept(tableNameHandler, object);
            this.tableName = tableNameHandler.getTableName();
        }
        return var3_3;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.table.getTableName();
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List<SysTable> list = Collections.singletonList(this.table);
        List list2 = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list2);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.table.getNodeList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPrepared() {
        boolean bl = this.index != null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        List<SysColumn> list;
        if (this.tableName == null) {
            list = this.database.getSysIndexByName(this.indexName);
            if (list == null) {
                throw new XDBServerException(ErrorMessageRepository.NO_INDEX_FOUND + "( " + this.indexName + " )", 0, ErrorMessageRepository.NO_INDEX_FOUND_CODE);
            }
            this.table = ((HelperSysIndex)((Object)list)).aSysTable;
            this.index = ((HelperSysIndex)((Object)list)).aSysIndex;
        } else {
            this.table = this.database.getSysTable(this.tableName);
            this.index = this.table.getSysIndex(this.indexName);
            if (this.index == null) {
                throw new XDBServerException(ErrorMessageRepository.NO_SUCH_INDEX + "( " + this.indexName + " )", 0, ErrorMessageRepository.NO_SUCH_INDEX_CODE);
            }
        }
        if (this.table.getParentTable() != null && this.table.getParentTable().getSysIndex(this.index.idxid) == this.index) {
            throw new XDBServerException("Can not drop inherited index");
        }
        if (this.client.getCurrentUser().getUserClass() != 0 && this.table.getOwner() != this.client.getCurrentUser()) {
            list = new XDBSecurityException("You are not allowed to drop indexes on table " + this.tableName);
            logger.throwing((Throwable)((Object)list));
            throw list;
        }
        if (this.table.getPrimaryIndex() != this.index && this.index.is_constrained) {
            throw new XDBServerException(ErrorMessageRepository.INDEX_REF_IN_CONSTRAINT + "( " + this.indexName + " )", 0, ErrorMessageRepository.INDEX_REF_IN_CONSTRAINT_CODE);
        }
        if (this.index.issyscreated == 1) {
            throw new XDBServerException(ErrorMessageRepository.XDB_CREATED_INDEX + "( " + this.indexName + " )", 0, ErrorMessageRepository.XDB_CREATED_INDEX_CODE);
        }
        list = this.index.getKeyColumns();
        if (list.size() != 1 || list.get(0) != this.table.getSerialColumn()) {
            this.dropIndexSQL = "DROP INDEX " + IdentifierHandler.quote(this.index.idxname);
            if (this.tableName != null) {
                this.dropIndexSQL = this.dropIndexSQL + " ON " + IdentifierHandler.quote(this.table.getTableName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.dropIndexSQL, this.table.getNodeList(), (IMetaDataUpdate)new SyncDropIndex(this), this.client);
        ExecutionResult executionResult = ExecutionResult.createSuccessResult(18);
        return executionResult;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

