/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateTable;
import com.edb.gridsql.metadata.SyncTempCreateTable;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.metadata.partitions.RobinPartitionMap;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import com.edb.gridsql.parser.core.syntaxtree.CheckDef;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.syntaxtree.CreateDefinition;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodePartitionList;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.OnCommitClause;
import com.edb.gridsql.parser.core.syntaxtree.PartitionChoice;
import com.edb.gridsql.parser.core.syntaxtree.PartitionDeclare;
import com.edb.gridsql.parser.core.syntaxtree.PrimaryKeyDef;
import com.edb.gridsql.parser.core.syntaxtree.SelectWithoutOrderAndSet;
import com.edb.gridsql.parser.core.syntaxtree.TableName;
import com.edb.gridsql.parser.core.syntaxtree.WithXRowID;
import com.edb.gridsql.parser.core.syntaxtree.createTable;
import com.edb.gridsql.parser.core.syntaxtree.inheritsDef;
import com.edb.gridsql.parser.core.syntaxtree.tablespaceDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.ForeignKeyHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateTable
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateTable.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private Command commandToExecute;
    private String referenceName;
    private String tableName;
    public boolean temporary;
    public List<SqlCreateTableColumn> columnDefinitions;
    public String partColumn;
    private int partScheme = 6;
    private List<ForeignKeyHandler> aForeignKeyDefsVector = new ArrayList<ForeignKeyHandler>();
    private List<String> primaryKeyNameColList;
    private Vector<String> checkList;
    private Vector<String> inheritsTables;
    private SysTable parentTable = null;
    private String pKConstraintName = null;
    private String constraintName = null;
    private Vector<String> checkConstraintName = new Vector();
    private Collection<Integer> partitionNodeList = null;
    private PartitionMap partitionMap;
    private String rowidIndexName;
    private String tablespaceName = null;
    private SysTablespace tablespace = null;
    private String serialColumnIndexString = null;
    private String createRowIDIndex = null;
    private String sqlStatement = null;
    private QueryProcessor qProcessor;
    private QueryTree aQueryTree = null;
    private List<String> colNameList;
    private ArrayList<DBNode> nodeList;

    public SqlCreateTable(XDBSessionContext xDBSessionContext) {
        this.columnDefinitions = new ArrayList<SqlCreateTableColumn>();
        this.checkList = new Vector();
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.commandToExecute = new Command(4, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public long getCost() {
        return 10000000000L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        Vector<SysTable> vector = new Vector<SysTable>();
        Vector vector2 = new Vector();
        for (ForeignKeyHandler foreignKeyHandler : this.aForeignKeyDefsVector) {
            vector.add(foreignKeyHandler.getForeignTable());
        }
        return new LockSpecification<SysTable>(vector, vector2);
    }

    public Collection<Integer> getPartitionList() {
        return this.partitionNodeList;
    }

    @Override
    public Object visit(CreateDefinition createDefinition, Object object) {
        Object var3_3 = null;
        block0 : switch (createDefinition.f0.which) {
            case 0: {
                SqlCreateTableColumn sqlCreateTableColumn = new SqlCreateTableColumn(this.commandToExecute);
                createDefinition.f0.accept(sqlCreateTableColumn, object);
                if (sqlCreateTableColumn.isPrimaryKey) {
                    this.isDefinePrimaryKey();
                    this.primaryKeyNameColList = new ArrayList<String>();
                    this.primaryKeyNameColList.add(sqlCreateTableColumn.columnName);
                }
                this.columnDefinitions.add(sqlCreateTableColumn);
                break;
            }
            case 1: {
                NodeSequence nodeSequence = (NodeSequence)createDefinition.f0.choice;
                NodeChoice nodeChoice = (NodeChoice)nodeSequence.elementAt(1);
                if (((NodeOptional)nodeSequence.elementAt(0)).present()) {
                    this.constraintName = (String)nodeSequence.elementAt(0).accept(this, object);
                }
                switch (nodeChoice.which) {
                    case 0: 
                    case 2: {
                        nodeChoice.accept(this, object);
                        break block0;
                    }
                    case 1: {
                        ForeignKeyHandler foreignKeyHandler = new ForeignKeyHandler(this.client);
                        createDefinition.accept(foreignKeyHandler, object);
                        this.aForeignKeyDefsVector.add(foreignKeyHandler);
                    }
                }
            }
        }
        return var3_3;
    }

    @Override
    public Object visit(CheckDef checkDef, Object object) {
        Object var3_3 = null;
        if (this.constraintName != null) {
            this.checkConstraintName.add(this.constraintName);
            this.constraintName = null;
        } else {
            this.checkConstraintName.add("");
        }
        this.checkList.add(checkDef.f2.str);
        return var3_3;
    }

    @Override
    public Object visit(inheritsDef inheritsDef2, Object object) {
        Object var3_3 = null;
        this.inheritsTables = new Vector();
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        inheritsDef2.f2.accept(tableNameHandler, object);
        this.inheritsTables.add(tableNameHandler.getTableName());
        for (int i = 0; i < inheritsDef2.f3.size(); ++i) {
            NodeSequence nodeSequence = (NodeSequence)inheritsDef2.f3.elementAt(i);
            TableName tableName = (TableName)nodeSequence.elementAt(1);
            TableNameHandler tableNameHandler2 = new TableNameHandler(this.client);
            tableName.accept(tableNameHandler2, object);
            this.inheritsTables.add(tableNameHandler2.getTableName());
        }
        return var3_3;
    }

    @Override
    public Object visit(PrimaryKeyDef primaryKeyDef, Object object) {
        Object var3_3 = null;
        if (this.constraintName != null) {
            this.pKConstraintName = this.constraintName;
            this.constraintName = null;
        }
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        primaryKeyDef.f2.accept(columnNameListHandler, null);
        this.isDefinePrimaryKey();
        this.primaryKeyNameColList = columnNameListHandler.getColumnNameList();
        return var3_3;
    }

    @Override
    public Object visit(Constraint constraint, Object object) {
        return constraint.f1.accept(new IdentifierHandler(), object);
    }

    @Override
    public Object visit(PartitionDeclare partitionDeclare, Object object) {
        NodeSequence nodeSequence;
        switch (partitionDeclare.f0.which) {
            case 0: {
                this.partScheme = 3;
                nodeSequence = (NodeSequence)partitionDeclare.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
                if (nodeOptional.present()) {
                    this.partColumn = (String)nodeOptional.node.accept(new IdentifierHandler(), object);
                }
                partitionDeclare.f0.accept(this, object);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.partScheme = 2;
                Collection<DBNode> collection = this.database.getDBNodeList();
                this.partitionNodeList = new ArrayList<Integer>(collection.size());
                for (DBNode dBNode : collection) {
                    this.partitionNodeList.add(dBNode.getNodeId());
                }
                break;
            }
            case 3: {
                this.partScheme = 1;
                nodeSequence = (NodeSequence)partitionDeclare.f0.choice;
                NodeToken nodeToken = (NodeToken)nodeSequence.elementAt(2);
                this.partitionNodeList = Collections.singletonList(Integer.parseInt(nodeToken.tokenImage));
                break;
            }
            case 4: {
                this.partScheme = 5;
                partitionDeclare.f0.accept(this, object);
            }
        }
        nodeSequence = null;
        return nodeSequence;
    }

    @Override
    public Object visit(PartitionChoice partitionChoice, Object object) {
        Object var3_3 = null;
        try {
            switch (partitionChoice.f0.which) {
                case 0: {
                    this.partitionNodeList = new ArrayList<Integer>(this.database.getDBNodeList().size());
                    for (DBNode dBNode : this.database.getDBNodeList()) {
                        this.partitionNodeList.add(dBNode.getNodeId());
                    }
                    break;
                }
                case 1: {
                    partitionChoice.f0.accept(this, object);
                }
            }
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.NODEINFO_CORRUPT, exception, ErrorMessageRepository.NODEINFO_CORRUPT_CODE);
        }
        return var3_3;
    }

    @Override
    public Object visit(NodePartitionList nodePartitionList, Object object) {
        try {
            this.partitionNodeList = new ArrayList<Integer>();
            Object var3_3 = null;
            nodePartitionList.f0.accept(this, object);
            this.partitionNodeList.add(Integer.parseInt(nodePartitionList.f0.tokenImage));
            nodePartitionList.f1.accept(this, object);
            for (Object e : nodePartitionList.f1.nodes) {
                NodeSequence nodeSequence = (NodeSequence)e;
                NodeToken nodeToken = (NodeToken)nodeSequence.elementAt(1);
                this.partitionNodeList.add(Integer.parseInt(nodeToken.tokenImage));
            }
            return var3_3;
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.NODEINFO_CORRUPT, exception, ErrorMessageRepository.NODEINFO_CORRUPT_CODE);
        }
    }

    private boolean validPartitioningKey(String string) {
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            if (!string.equals(sqlCreateTableColumn.columnName)) continue;
            return sqlCreateTableColumn.canBePartitioningKey();
        }
        throw new XDBServerException("Column not found: " + string);
    }

    private String findPartitioningKey() {
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            if (!sqlCreateTableColumn.canBePartitioningKey()) continue;
            return sqlCreateTableColumn.columnName;
        }
        return null;
    }

    private void defaultPartition() {
        if (this.primaryKeyNameColList != null && this.primaryKeyNameColList.size() > 0) {
            for (String object : this.primaryKeyNameColList) {
                if (!this.validPartitioningKey(object)) continue;
                this.partColumn = object;
                break;
            }
        } else {
            this.partColumn = this.findPartitioningKey();
        }
        this.partitionNodeList = new ArrayList<Integer>(this.database.getDBNodeList().size());
        for (DBNode dBNode : this.database.getDBNodeList()) {
            this.partitionNodeList.add(dBNode.getNodeId());
        }
        this.partScheme = this.partColumn == null ? 5 : 3;
    }

    @Override
    public Object visit(createTable createTable2, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        createTable2.f3.accept(tableNameHandler, object);
        this.referenceName = tableNameHandler.getReferenceName();
        this.temporary = createTable2.f1.present() || tableNameHandler.isTemporary();
        this.tableName = this.temporary ? this.client.getSysDatabase().getUniqueTempTableName(this.referenceName) : tableNameHandler.getTableName();
        createTable2.f4.accept(this, object);
        return var3_3;
    }

    @Override
    public Object visit(SelectWithoutOrderAndSet selectWithoutOrderAndSet, Object object) {
        if (selectWithoutOrderAndSet.f3.present()) {
            throw new XDBServerException("Syntax error: INTO");
        }
        this.aQueryTree = new QueryTree();
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        selectWithoutOrderAndSet.accept(queryTreeHandler, this.aQueryTree);
        this.aQueryTree.setIntoTable(this.tableName, this.referenceName, this.temporary);
        this.aQueryTree.setIntoTablePartitioning((short)this.partScheme, this.partColumn, this.partitionMap);
        this.aQueryTree.setIntoTableColumns(this.colNameList);
        return null;
    }

    @Override
    public Object visit(WithXRowID withXRowID, Object object) {
        if (withXRowID.f0.which == 0) {
            this.columnDefinitions.add(SqlCreateTableColumn.ROW_ID_COLUMN);
            if (this.isPossibleToCreateIndex()) {
                this.rowidIndexName = "IDX_XROWID_" + this.getTableName();
                this.createRowIDIndex = "create unique index " + this.rowidIndexName + " on " + this.getTableName() + " ( " + "xrowid" + " ) ";
            }
        }
        return null;
    }

    @Override
    public Object visit(OnCommitClause onCommitClause, Object object) {
        switch (onCommitClause.f1.which) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                throw new XDBServerException("Not supported: " + onCommitClause.f1.choice);
            }
        }
        return null;
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        columnNameList.accept(columnNameListHandler, object);
        this.colNameList = columnNameListHandler.getColumnNameList();
        return null;
    }

    @Override
    public Object visit(tablespaceDef tablespaceDef2, Object object) {
        this.tablespaceName = (String)tablespaceDef2.f1.accept(new IdentifierHandler(), object);
        return null;
    }

    public String rebuildString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.isTempTable()) {
            stringBuffer.append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_START);
        } else {
            stringBuffer.append("CREATE TABLE");
        }
        stringBuffer.append(" ").append(IdentifierHandler.quote(this.getTableName())).append(" (");
        for (SqlCreateTableColumn object : this.columnDefinitions) {
            stringBuffer.append(object.rebuildString());
            stringBuffer.append(", ");
        }
        if (this.primaryKeyNameColList != null && this.primaryKeyNameColList.size() > 0) {
            if (this.pKConstraintName == null) {
                this.pKConstraintName = "PK_IDX_" + this.getReferenceName();
            }
            stringBuffer.append("CONSTRAINT " + IdentifierHandler.quote(this.pKConstraintName) + " PRIMARY KEY (");
            for (String string : this.primaryKeyNameColList) {
                stringBuffer.append(IdentifierHandler.quote(string));
                stringBuffer.append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append("), ");
        }
        if (this.aForeignKeyDefsVector != null) {
            for (ForeignKeyHandler foreignKeyHandler : this.aForeignKeyDefsVector) {
                if (foreignKeyHandler.isSoft(this.partColumn, this.getPartitionMap())) continue;
                if (foreignKeyHandler.getConstraintName() != null) {
                    stringBuffer.append("CONSTRAINT ").append(IdentifierHandler.quote(foreignKeyHandler.getConstraintName())).append(" ");
                }
                stringBuffer.append("FOREIGN KEY (");
                for (String string : foreignKeyHandler.getLocalColumnNames()) {
                    stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(") REFERENCES ").append(IdentifierHandler.quote(foreignKeyHandler.getForeignTableName())).append(" (");
                for (String string : foreignKeyHandler.getForeignColumnNames()) {
                    stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append("), ");
            }
        }
        if (this.checkList != null) {
            int n = 0;
            for (String string : this.checkList) {
                if ("".equals(this.checkConstraintName.elementAt(n))) {
                    stringBuffer.append("CHECK (").append(string).append("), ");
                } else {
                    stringBuffer.append("CONSTRAINT " + this.checkConstraintName.elementAt(n) + " CHECK (").append(string).append("), ");
                }
                ++n;
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append(")");
        if (this.parentTable != null) {
            stringBuffer.append(" INHERITS (").append(IdentifierHandler.quote(this.parentTable.getTableName())).append(")");
        }
        if (this.isTempTable()) {
            stringBuffer.append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_SUFFIX);
        }
        return stringBuffer.toString();
    }

    private SqlCreateTableColumn getColumn(String string) {
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            if (!sqlCreateTableColumn.columnName.toUpperCase().equals(string.toUpperCase())) continue;
            return sqlCreateTableColumn;
        }
        return null;
    }

    private boolean checkSemantics(SysDatabase sysDatabase) {
        int n;
        boolean bl = true;
        if (this.tableName.length() > 255) {
            throw new XDBServerException(ErrorMessageRepository.TABLE_NAME_CANNOT_EXCEED_255 + "(" + this.tableName + ")", 0, ErrorMessageRepository.TABLE_NAME_CANNOT_EXCEED_255_CODE);
        }
        if (!this.temporary && this.tableName.startsWith(Props.XDB_TEMPTABLEPREFIX)) {
            throw new XDBServerException("Table name can not start with \"" + Props.XDB_TEMPTABLEPREFIX + "\", this prefix is reserved for internal temp tables");
        }
        if (sysDatabase.isTableExists(this.tableName) || sysDatabase.isTableExists(this.referenceName) || this.client.getTempTableName(this.referenceName) != null) {
            throw new XDBServerException(ErrorMessageRepository.DUP_TABLE_NAME + "(" + this.referenceName + ")", 0, ErrorMessageRepository.DUP_TABLE_NAME_CODE);
        }
        if (this.inheritsTables != null && !this.inheritsTables.isEmpty()) {
            this.parentTable = sysDatabase.getSysTable(this.inheritsTables.get(0));
            if (this.partScheme != 6 && this.parentTable.getPartitionScheme() != this.partScheme || this.partColumn != null && this.partColumn.length() > 0 && !this.partColumn.equalsIgnoreCase(this.parentTable.getPartitionColumn())) {
                throw new XDBServerException("Child table must have same partitioning as parent table");
            }
            if (this.client.getCurrentUser() != this.parentTable.getOwner()) {
                throw new XDBServerException("You can inherit only from own table");
            }
        }
        for (n = 0; n < this.columnDefinitions.size(); ++n) {
            Iterator<SqlCreateTableColumn> iterator2 = this.columnDefinitions.get(n);
            String object = ((SqlCreateTableColumn)((Object)iterator2)).columnName;
            for (int i = 0; i < n; ++i) {
                SqlCreateTableColumn sqlCreateTableColumn = this.columnDefinitions.get(i);
                if (!object.equals(sqlCreateTableColumn.columnName)) continue;
                throw new XDBServerException(ErrorMessageRepository.DUP_COLUMN_NAME + "(" + object + ")", 0, ErrorMessageRepository.DUP_COLUMN_NAME_CODE);
            }
            if (this.parentTable == null || this.parentTable.getSysColumn(object) == null) continue;
            throw new XDBServerException(ErrorMessageRepository.DUP_COLUMN_NAME + "(" + object + ")", 0, ErrorMessageRepository.DUP_COLUMN_NAME_CODE);
        }
        n = this.parentTable != null && this.parentTable.getSerialColumn() != null ? 1 : 0;
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            if (!sqlCreateTableColumn.isSerial() || ++n <= 1) continue;
            throw new XDBServerException("The number of serial columns should not be greater than 1");
        }
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            Object object;
            Object object2;
            if (sqlCreateTableColumn.checkCondition != null) {
                for (QueryCondition queryCondition : QueryCondition.getNodes(sqlCreateTableColumn.checkCondition, 4)) {
                    for (SqlExpression sqlExpression : queryCondition.getExpr().getNodes(queryCondition.getExpr(), 4)) {
                        object2 = sqlExpression.getColumn();
                        object = ((AttributeColumn)object2).columnName;
                        for (SqlCreateTableColumn sqlCreateTableColumn2 : this.columnDefinitions) {
                            if (!sqlCreateTableColumn2.columnName.equals(object) || sqlCreateTableColumn2.getDefaultValue() == null || !sqlCreateTableColumn2.getDefaultValue().equalsIgnoreCase("NULL")) continue;
                            throw new XDBServerException(ErrorMessageRepository.UNKOWN_COLUMN_NAME + "(" + (String)object + ")", 0, ErrorMessageRepository.UNKOWN_COLUMN_NAME_CODE);
                        }
                    }
                }
            }
            HashSet hashSet = new HashSet();
            for (ForeignKeyHandler foreignKeyHandler : this.aForeignKeyDefsVector) {
                while (!hashSet.add(foreignKeyHandler.getConstraintName())) {
                    foreignKeyHandler.clearConstraintName();
                }
            }
            for (ForeignKeyHandler foreignKeyHandler : this.aForeignKeyDefsVector) {
                SysTable sysTable = foreignKeyHandler.getForeignTable();
                object2 = null;
                object2 = sysTable.getPrimaryOrUniqueIndex(foreignKeyHandler.getForeignColumnNames());
                if (object2 == null) {
                    throw new XDBServerException(ErrorMessageRepository.COLUMN_MUST_PRIMARY_KEY_OR_UNIQUE_INDEX, 0, ErrorMessageRepository.COLUMN_MUST_PRIMARY_KEY_OR_UNIQUE_INDEX_CODE);
                }
                object = ((SysIndex)object2).getKeyColumns();
                Iterator<SqlCreateTableColumn> iterator = object.iterator();
                for (String string : foreignKeyHandler.getLocalColumnNames()) {
                    SqlCreateTableColumn sqlCreateTableColumn3 = this.getColumn(string);
                    if (sqlCreateTableColumn3 == null) {
                        throw new XDBServerException(ErrorMessageRepository.COLUMN_NOT_IN_TABLE + " (" + string + " )", 0, ErrorMessageRepository.COLUMN_NOT_IN_TABLE_CODE);
                    }
                    if (!iterator.hasNext()) {
                        throw new XDBServerException(ErrorMessageRepository.KEY_COUNT_NOT_EQUAL, 0, ErrorMessageRepository.KEY_COUNT_NOT_EQUAL_CODE);
                    }
                    SysColumn sysColumn = (SysColumn)((Object)iterator.next());
                    if (sqlCreateTableColumn3.getColumnType() == sysColumn.getColType()) continue;
                    throw new XDBServerException(ErrorMessageRepository.DATA_TYPE_MISMATCH + "(" + string + "," + sysColumn.getColName() + ")", 0, ErrorMessageRepository.DATA_TYPE_MISMATCH_CODE);
                }
            }
        }
        if (this.parentTable == null && this.partScheme == 3) {
            if (this.partColumn == null) {
                this.partColumn = this.findPartitioningKey();
                if (this.partColumn == null) {
                    throw new XDBServerException("Can not choose column for partitioning key");
                }
            } else if (!this.validPartitioningKey(this.partColumn)) {
                throw new XDBServerException(ErrorMessageRepository.PARTITION_COLUMN_NOT_FOUND_IN_COLUMNLIST, 0, ErrorMessageRepository.PARTITION_COLUMN_NOT_FOUND_IN_COLUMNLIST_CODE);
            }
        }
        if (this.tablespaceName != null) {
            this.tablespace = MetaData.getMetaData().getTablespace(this.tablespaceName);
            for (DBNode dBNode : this.getNodeList()) {
                if (this.tablespace.getLocations().containsKey(dBNode.getNodeId())) continue;
                throw new XDBServerException("Tablespace " + IdentifierHandler.quote(this.tablespaceName) + " does not exist on Node " + dBNode.getNodeId());
            }
        }
        return bl;
    }

    public List<String> getPrimaryKeyNameColList() {
        return this.primaryKeyNameColList;
    }

    public List<ForeignKeyHandler> getForeignKeyDefs() {
        return this.aForeignKeyDefsVector;
    }

    public boolean isTempTable() {
        return this.temporary;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public SqlCreateTableColumn getSerialColumnDef() {
        for (SqlCreateTableColumn sqlCreateTableColumn : this.columnDefinitions) {
            if (!sqlCreateTableColumn.isSerial()) continue;
            return sqlCreateTableColumn;
        }
        return null;
    }

    private String getSerialColumnIndexStrings() {
        SqlCreateTableColumn sqlCreateTableColumn = this.getSerialColumnDef();
        if (sqlCreateTableColumn != null) {
            String string = "create  index " + IdentifierHandler.quote(SqlCreateTableColumn.IDX_SERIAL_NAME + "_" + this.getTableName()) + " on " + IdentifierHandler.quote(this.getTableName()) + " ( " + IdentifierHandler.quote(sqlCreateTableColumn.columnName) + " ) ";
            return string;
        }
        return null;
    }

    public boolean isPossibleToCreateIndex() {
        return Props.XDB_ALLOWTEMPTABLEINDEX > 0 || !this.isTempTable();
    }

    public List<DBNode> getNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList();
            if (this.qProcessor != null) {
                this.nodeList.addAll(this.qProcessor.getNodeList());
            } else if (this.parentTable != null) {
                this.nodeList.addAll(this.parentTable.getNodeList());
            } else {
                if (this.partitionNodeList == null) {
                    this.defaultPartition();
                }
                for (Integer n : this.partitionNodeList) {
                    this.nodeList.add(this.database.getDBNode(n));
                }
            }
            Collections.sort(this.nodeList, new Comparator<DBNode>(){

                @Override
                public int compare(DBNode dBNode, DBNode dBNode2) {
                    int n;
                    int n2 = dBNode.getNodeId();
                    return n2 == (n = dBNode2.getNodeId()) ? 0 : (n2 > n ? 1 : -1);
                }
            });
        }
        return this.nodeList;
    }

    public SysTablespace getTablespace() {
        return this.tablespace;
    }

    @Override
    public boolean isPrepared() {
        return this.sqlStatement != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        if (this.client.getCurrentUser().getUserClass() == 2) {
            XDBSecurityException xDBSecurityException = new XDBSecurityException("You are not allowed to create tables");
            logger.throwing(xDBSecurityException);
            throw xDBSecurityException;
        }
        SysDatabase sysDatabase = this.client.getSysDatabase();
        if (this.aQueryTree != null) {
            this.aQueryTree.setIntoTableSpace(this.tablespace);
            this.qProcessor = new QueryProcessor(this.client, this.aQueryTree);
            this.qProcessor.prepare();
            for (SqlExpression sqlExpression : this.aQueryTree.getProjectionList()) {
                this.columnDefinitions.add(new SqlCreateTableColumn(sqlExpression));
            }
        }
        this.checkSemantics(sysDatabase);
        if (this.isPossibleToCreateIndex()) {
            this.serialColumnIndexString = this.getSerialColumnIndexStrings();
        }
        this.sqlStatement = this.rebuildString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        Object object;
        block15: {
            if (!this.isPrepared()) {
                this.prepare();
            }
            if (this.qProcessor == null) break block15;
            ExecutionResult executionResult = this.qProcessor.execute(engine);
            return executionResult;
        }
        SysDatabase sysDatabase = this.client.getSysDatabase();
        IMetaDataUpdate iMetaDataUpdate = this.temporary ? new SyncTempCreateTable(this) : new SyncCreateTable(this);
        Collection collection = this.getNodeList();
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            iMetaDataUpdate.execute(this.client);
            object = this.client.getMultinodeExecutor(collection);
            if (!this.client.isInTransaction()) {
                engine.beginTransaction(this.client, collection);
            }
            try {
                if (this.tablespace == null) {
                    ((MultinodeExecutor)object).executeCommand(this.sqlStatement, collection);
                } else {
                    HashMap<DBNode, String> hashMap = new HashMap<DBNode, String>();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        DBNode dBNode;
                        DBNode dBNode2 = dBNode = (DBNode)iterator.next();
                        String string = this.sqlStatement + " TABLESPACE " + this.tablespace.getNodeTablespaceName(dBNode2.getNodeId());
                        hashMap.put(dBNode2, string);
                    }
                    ((MultinodeExecutor)object).executeCommand(hashMap);
                }
                if (this.serialColumnIndexString != null) {
                    ((MultinodeExecutor)object).executeCommand(this.serialColumnIndexString, collection);
                }
                if (this.createRowIDIndex != null) {
                    ((MultinodeExecutor)object).executeCommand(this.createRowIDIndex, collection);
                }
                engine.commitTransaction(this.client, collection);
            }
            catch (Exception exception) {
                engine.rollbackTransaction(this.client, collection);
                throw exception;
            }
            metaData.commitTransaction(iMetaDataUpdate);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        if (this.temporary) {
            this.client.registerTempTableWithSession(this.getReferenceName(), this.getTableName());
            object = sysDatabase.getSysTable(this.getTableName());
            ((SysTable)object).setTableTemporary(true);
        }
        object = ExecutionResult.createSuccessResult(11);
        return object;
    }

    public String getRowidIndexName() {
        return this.rowidIndexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SysTable getParentTable() {
        return this.parentTable;
    }

    public List<String> getChecks() {
        return this.checkList;
    }

    private void isDefinePrimaryKey() {
        if (this.primaryKeyNameColList != null) {
            throw new XDBServerException("multiple primary keys for table " + this.tableName + " are not allowed");
        }
    }

    public String getPKConstraintName() {
        return this.pKConstraintName;
    }

    public Vector<String> getCheckConstraintName() {
        return this.checkConstraintName;
    }

    public short getPartScheme() {
        if (this.partScheme == 6) {
            this.defaultPartition();
        }
        return (short)this.partScheme;
    }

    public PartitionMap getPartitionMap() {
        if (this.partitionMap == null) {
            switch (this.getPartScheme()) {
                case 3: {
                    this.partitionMap = new HashPartitionMap();
                    break;
                }
                case 1: 
                case 2: {
                    this.partitionMap = new ReplicatedPartitionMap();
                    break;
                }
                case 5: {
                    this.partitionMap = new RobinPartitionMap();
                }
            }
            this.partitionMap.generateDistribution(this.partitionNodeList);
        }
        return this.partitionMap;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

