/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.CreateDatabase;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.util.DbGateway;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateDatabase
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateDatabase.class);
    private XDBSessionContext client;
    private boolean prepared = false;
    private String[] nodeList;
    private String dbName;
    private boolean manual = false;

    public SqlCreateDatabase(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        if (!this.prepared && this.client.getCurrentUser().getLogin().getUserClass() != 0) {
            throw new XDBSecurityException("You are not allowed to create database");
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        XDBSessionContext xDBSessionContext = XDBSessionContext.createSession();
        try {
            NodeDBConnectionInfo[] nodeDBConnectionInfoArray;
            xDBSessionContext.useDB(this.dbName, "C");
            xDBSessionContext.login(this.client.getCurrentUser().getLogin());
            ExecutionResult executionResult = xDBSessionContext.createDatabase(this.nodeList);
            if (!this.manual) {
                nodeDBConnectionInfoArray = xDBSessionContext.getConnectionInfos(this.nodeList);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                DbGateway dbGateway = new DbGateway();
                dbGateway.createDbOnNodes(hashMap, nodeDBConnectionInfoArray);
            }
            xDBSessionContext.persistDatabase();
            nodeDBConnectionInfoArray = executionResult;
            xDBSessionContext.logout();
            return nodeDBConnectionInfoArray;
        }
        catch (Throwable throwable) {
            xDBSessionContext.logout();
            throw throwable;
        }
    }

    @Override
    public Object visit(CreateDatabase createDatabase, Object object) {
        this.dbName = (String)createDatabase.f1.accept(new IdentifierHandler(), object);
        this.manual = createDatabase.f3.present();
        this.nodeList = new String[createDatabase.f7.size() + 1];
        int n = 0;
        this.nodeList[n++] = createDatabase.f6.tokenImage;
        Enumeration enumeration = createDatabase.f7.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = ((NodeSequence)e).nodes.elementAt(1);
            this.nodeList[n++] = e2.toString();
        }
        return null;
    }
}

