/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBulkInsertNext
implements IXDBSql,
IExecutable {
    private static final XLogger logger = XLogger.getLogger(SqlBulkInsertNext.class);
    private XDBSessionContext client;
    private SysTable table;
    private boolean serial = false;
    private int range = 10000;
    private LockSpecification<SysTable> lockSpecs = null;

    public SqlBulkInsertNext(String string, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        int n = string.indexOf("|");
        String string2 = string.substring(0, n);
        if (string.startsWith("SERIAL|", n += "|".length())) {
            this.serial = true;
            n += 6 + "|".length();
        }
        try {
            this.range = Integer.parseInt(string.substring(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.table = xDBSessionContext.getSysDatabase().getSysTable(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBNode> getNodeList() {
        List<DBNode> list = Collections.emptyList();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        long l = 1L;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        if (this.lockSpecs == null) {
            this.lockSpecs = new LockSpecification();
        }
        LockSpecification<SysTable> lockSpecification = this.lockSpecs;
        return lockSpecification;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        long l = this.serial ? this.table.getSerialHandler().allocateRange(this.range, this.client) : this.table.getRowIDHandler().allocateRange(this.range, this.client);
        return ExecutionResult.createGeneratorRangeResult(26, l);
    }
}

