/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockType;
import com.edb.gridsql.parser.IXDBSql;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBulkInsert
implements IXDBSql,
IExecutable {
    private static final XLogger logger = XLogger.getLogger(SqlBulkInsert.class);
    private SysTable table;
    private XDBSessionContext client;
    private String address;
    private LockSpecification<SysTable> lockSpecs = null;

    public SqlBulkInsert(String string, XDBSessionContext xDBSessionContext) {
        String string2;
        this.client = xDBSessionContext;
        int n = string.indexOf("|");
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            this.address = string.substring(n + "|".length());
        }
        this.table = xDBSessionContext.getSysDatabase().getSysTable(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBNode> getNodeList() {
        Collection<DBNode> collection = this.table.getNodeList();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        long l = 10000000000L;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        if (this.lockSpecs == null) {
            this.lockSpecs = new LockSpecification();
            this.lockSpecs.add(this.table, LockType.get(2, false));
        }
        LockSpecification<SysTable> lockSpecification = this.lockSpecs;
        return lockSpecification;
    }

    public SysTable getSysTable() {
        return this.table;
    }

    public void startLoaders(Engine engine) throws Exception {
        if (this.address != null) {
            engine.startLoaders(this.table.getTableName(), this.address, this.getNodeList(), this.client);
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.client.isInTransaction()) {
            engine.beginTransaction(this.client, this.getNodeList());
        }
        this.startLoaders(engine);
        PartitionMap partitionMap = this.table.getPartitionMap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ExecutionResult executionResult;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(partitionMap);
                objectOutputStream.flush();
                executionResult = ExecutionResult.createSerializedObjectResult(26, byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                objectOutputStream.close();
                throw throwable;
            }
            objectOutputStream.close();
            return executionResult;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }
}

