/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncAlterTablespace;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.AlterTableSpace;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterTableSpace
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterTableSpace.class);
    private XDBSessionContext client;
    private String tablespaceName;
    private String newName;
    private SysTablespace tablespace;
    private HashMap<DBNode, String> statements = null;

    public SqlAlterTableSpace(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(AlterTableSpace alterTableSpace, Object object) {
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.tablespaceName = (String)alterTableSpace.f1.accept(identifierHandler, object);
        this.newName = (String)alterTableSpace.f4.accept(identifierHandler, object);
        return null;
    }

    public SysTablespace getTablespace() {
        return this.tablespace;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        if (!this.isPrepared()) {
            try {
                this.prepare();
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
        return this.statements.keySet();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean isPrepared() {
        return this.statements != null;
    }

    @Override
    public void prepare() throws Exception {
        MetaData metaData = MetaData.getMetaData();
        SysTablespace sysTablespace = metaData.getTablespace(this.tablespaceName);
        if (sysTablespace == null) {
            throw new XDBServerException("Tablespace \"" + this.tablespaceName + "\" does not exist");
        }
        if (sysTablespace.getOwnerID() != this.client.getCurrentUser().getUserID()) {
            throw new XDBServerException("Only Owner can alter tablespace");
        }
        if (metaData.hasTablespace(this.newName)) {
            throw new XDBServerException("Tablespace \"" + this.tablespaceName + "\" already exists");
        }
        this.statements = new HashMap();
        for (Integer n : sysTablespace.getLocations().keySet()) {
            DBNode dBNode = this.client.getSysDatabase().getDBNode(n);
            String string = "ALTER TABLESPACE " + IdentifierHandler.quote(this.tablespaceName + "_" + n) + " RENAME TO " + IdentifierHandler.quote(this.newName + "_" + n);
            this.statements.put(dBNode, string);
        }
        this.tablespace = sysTablespace;
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncAlterTablespace syncAlterTablespace = new SyncAlterTablespace(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncAlterTablespace.execute(this.client);
            MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.getNodeList());
            multinodeExecutor.executeCommand(this.statements, true);
            metaData.commitTransaction(syncAlterTablespace);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            logger.throwing(exception);
            throw exception;
        }
        return ExecutionResult.createSuccessResult(3);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

