/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.Lexer;

public class ParserHelper {
    public static QueryCondition getSimpleCondition(Lexer lexer, SysTable sysTable, QueryTree queryTree, XDBSessionContext xDBSessionContext) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.setCondType(4);
        queryCondition.setExpr(ParserHelper.createSimpleSqlExpression(lexer, sysTable, queryTree.getRelationNodeList().get(0), xDBSessionContext));
        if (queryCondition.getExpr() == null) {
            return null;
        }
        if (lexer.hasMoreTokens()) {
            if (!lexer.isOperator(lexer.peekToken(0))) {
                return queryCondition;
            }
        } else {
            return queryCondition;
        }
        String string = lexer.nextToken();
        QueryCondition queryCondition2 = new QueryCondition();
        queryCondition2.setCondType(4);
        queryCondition2.setExpr(ParserHelper.createSimpleSqlExpression(lexer, sysTable, queryTree.getRelationNodeList().get(0), xDBSessionContext));
        if (queryCondition2.getExpr() == null) {
            return null;
        }
        QueryCondition queryCondition3 = new QueryCondition();
        queryCondition3.setCondType(16);
        queryCondition3.setOperator(string);
        queryCondition3.setLeftCond(queryCondition);
        queryCondition3.setRightCond(queryCondition2);
        queryCondition3.getRelationNodeList().addAll(queryTree.getRelationNodeList());
        return queryCondition3;
    }

    public static QueryCondition chainQueryConditions(QueryCondition queryCondition, String string, QueryCondition queryCondition2) {
        QueryCondition queryCondition3 = new QueryCondition();
        queryCondition3.setCondType(8);
        queryCondition3.setOperator(string);
        queryCondition3.setLeftCond(queryCondition);
        queryCondition3.setRightCond(queryCondition2);
        return queryCondition3;
    }

    private static SqlExpression createColumnSqlExpression(String string, SysTable sysTable, RelationNode relationNode) {
        SysColumn sysColumn = sysTable.getSysColumn(string);
        if (sysColumn == null) {
            throw new XDBServerException("Invalid column name " + string);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = sysColumn.getColType();
        expressionType.length = sysColumn.getColumnLength();
        AttributeColumn attributeColumn = new AttributeColumn();
        attributeColumn.setTableName(sysTable.getTableName());
        attributeColumn.columnName = string;
        attributeColumn.relationNode = relationNode;
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setExprType(4);
        sqlExpression.setColumn(attributeColumn);
        sqlExpression.setExprDataType(expressionType);
        return sqlExpression;
    }

    public static SqlExpression createSimpleSqlExpression(Lexer lexer, SysTable sysTable, RelationNode relationNode, XDBSessionContext xDBSessionContext) {
        boolean bl;
        if (!lexer.hasMoreTokens()) {
            return null;
        }
        SqlExpression sqlExpression = null;
        String string = lexer.nextToken();
        if ("(".equals(string)) {
            bl = true;
            sqlExpression = ParserHelper.createSimpleSqlExpression(lexer, sysTable, relationNode, xDBSessionContext);
        } else {
            bl = false;
            if (Character.isDigit(string.charAt(0))) {
                sqlExpression = new SqlExpression();
                sqlExpression.setExprType(2);
                sqlExpression.setConstantValue(string);
                sqlExpression.setExprString(string);
            } else if (string.charAt(0) == '\'') {
                sqlExpression = new SqlExpression();
                sqlExpression.setExprType(2);
                sqlExpression.setConstantValue(string);
                sqlExpression.setExprString(string);
            } else if (Character.isLetter(string.charAt(0)) || string.charAt(0) == '_') {
                if (sysTable.getTableName().equalsIgnoreCase(string) && ".".equals(lexer.peekToken(0))) {
                    lexer.nextToken();
                    string = lexer.nextToken();
                } else if (string.toUpperCase().startsWith("CURRENT")) {
                    sqlExpression = new SqlExpression();
                    if (string.equalsIgnoreCase("CURRENT") || string.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                        sqlExpression.getCurrentTimestamp();
                    } else if (string.equalsIgnoreCase("CURRENT_TIME")) {
                        sqlExpression.getCurrentTime();
                    } else if (string.equalsIgnoreCase("CURRENT_DATE")) {
                        sqlExpression.getCurrentDate();
                    } else if (string.equalsIgnoreCase("CURRENT_USER")) {
                        sqlExpression.setExprType(2);
                        sqlExpression.setConstantValue("'" + xDBSessionContext.getCurrentUser().getName() + "'");
                        sqlExpression.setExprString(sqlExpression.getConstantValue());
                    }
                } else if (string.equalsIgnoreCase("SYSDATE")) {
                    sqlExpression = new SqlExpression();
                    sqlExpression.getSysDate();
                } else if (string.equalsIgnoreCase("USER")) {
                    sqlExpression = new SqlExpression();
                    sqlExpression.setExprType(2);
                    sqlExpression.setConstantValue("'" + xDBSessionContext.getCurrentUser().getName() + "'");
                    sqlExpression.setExprString(sqlExpression.getConstantValue());
                }
                if (sqlExpression == null) {
                    sqlExpression = ParserHelper.createColumnSqlExpression(string, sysTable, relationNode);
                }
            }
        }
        if (bl ? ")".equals(lexer.peekToken(0)) : !lexer.hasMoreTokens()) {
            return sqlExpression;
        }
        if (sqlExpression == null) {
            return null;
        }
        SqlExpression sqlExpression2 = new SqlExpression();
        sqlExpression2.setExprType(16);
        string = lexer.peekToken(0);
        if (string.charAt(0) != '+' && string.charAt(0) != '-' && string.charAt(0) != '*' && string.charAt(0) != '/' && string.charAt(0) != '%' && !"DIV".equalsIgnoreCase(string) && !"MOD".equalsIgnoreCase(string)) {
            return sqlExpression;
        }
        sqlExpression2.setOperator(lexer.nextToken());
        SqlExpression sqlExpression3 = ParserHelper.createSimpleSqlExpression(lexer, sysTable, relationNode, xDBSessionContext);
        if (sqlExpression3 == null) {
            return null;
        }
        sqlExpression2.setLeftExpr(sqlExpression);
        if (sqlExpression3.getExprType() == 16 && ParserHelper.getOperatorPrecedence(sqlExpression2.getOperator()) > ParserHelper.getOperatorPrecedence(sqlExpression3.getOperator())) {
            sqlExpression2.setRightExpr(sqlExpression3.getLeftExpr());
            sqlExpression3.setLeftExpr(sqlExpression2);
            sqlExpression2 = sqlExpression3;
        } else {
            sqlExpression2.setRightExpr(sqlExpression3);
        }
        sqlExpression2.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression2, sysTable.getSysDatabase()));
        return sqlExpression2;
    }

    private static int getOperatorPrecedence(String string) {
        if ("+".equals(string) || "-".equals(string)) {
            return 1;
        }
        return 2;
    }

    public static boolean parseProjectionsForSingleTable(String string, QueryTree queryTree, RelationNode relationNode, SysTable sysTable, XDBSessionContext xDBSessionContext) {
        Lexer lexer = new Lexer(string.trim());
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        while (lexer.hasMoreTokens()) {
            String string2;
            boolean bl = false;
            if ("*".equals(lexer.peekToken(0))) {
                bl = true;
                lexer.nextToken();
            } else if (sysTable.getTableName().equalsIgnoreCase(lexer.peekToken(0)) && ".".equals(lexer.peekToken(1)) && "*".equals(lexer.peekToken(2))) {
                lexer.nextToken();
                lexer.nextToken();
                lexer.nextToken();
            }
            if (bl) {
                for (SysColumn sysColumn : sysTable.getColumns()) {
                    if (sysColumn.getColName().equalsIgnoreCase("xrowid")) continue;
                    SqlExpression sqlExpression = ParserHelper.createColumnSqlExpression(sysColumn.getColName(), sysTable, relationNode);
                    relationNode.getProjectionList().add(sqlExpression);
                    queryTree.getProjectionList().add(sqlExpression);
                }
                if (!lexer.hasMoreTokens() || ",".equals(lexer.nextToken())) continue;
                return false;
            }
            SqlExpression sqlExpression = ParserHelper.createSimpleSqlExpression(lexer, sysTable, relationNode, xDBSessionContext);
            if (lexer.hasMoreTokens() && !",".equals(string2 = lexer.nextToken()) && string2.matches("^[a-zA-Z_]([a-zA-Z0-9_$#])*+$")) {
                sqlExpression.setAlias(string2);
                if (lexer.hasMoreTokens() && !",".equals(lexer.nextToken())) {
                    return false;
                }
            }
            relationNode.getProjectionList().add(sqlExpression);
            queryTree.getProjectionList().add(sqlExpression);
        }
        return true;
    }
}

