/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    public static final int SELECT = 1;
    public static final int UPDATE = 2;
    public static final int INSERT = 3;
    public static final int CREATE = 4;
    public static final int DELETE = 5;
    public static final int DROP = 6;
    public static final int ALTER = 7;
    public static final int MODIFY = 8;
    private boolean cmdForCreateView = false;
    private XDBSessionContext client;
    private Object commandObj;
    private int commandToExecute;
    private QueryTreeTracker aQueryTreeTracker;
    private ArrayList<SqlExpression> parameters;

    public Command(int n, Object object, QueryTreeTracker queryTreeTracker, XDBSessionContext xDBSessionContext) {
        this.commandToExecute = n;
        this.commandObj = object;
        this.aQueryTreeTracker = queryTreeTracker;
        this.client = xDBSessionContext;
    }

    public Object getCommandObj() {
        return this.commandObj;
    }

    public boolean isCmdForView() {
        return this.cmdForCreateView;
    }

    public void setCmdForCreateView() {
        this.cmdForCreateView = true;
    }

    public int getCommandToExecute() {
        return this.commandToExecute;
    }

    public QueryTreeTracker getaQueryTreeTracker() {
        return this.aQueryTreeTracker;
    }

    public XDBSessionContext getClientContext() {
        return this.client;
    }

    public String getDBName() {
        return this.client.getDBName();
    }

    public void registerParameter(int n, SqlExpression sqlExpression) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.ensureCapacity(n);
        while (n > this.parameters.size()) {
            this.parameters.add(null);
        }
        this.parameters.set(n - 1, sqlExpression);
    }

    public SqlExpression getParameter(int n) {
        return this.parameters.get(n - 1);
    }

    public List<SqlExpression> getParameters() {
        return this.parameters == null ? null : Collections.unmodifiableList(this.parameters);
    }

    public int getParamCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }
}

