/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryNode {
    public static final int JOIN = 1;
    public static final int RELATION = 2;
    private int nodeType = 2;
    private boolean preserveSubtree = false;
    private QueryNode rightNode;
    private QueryNode leftNode;
    private QueryNode parent = null;
    private RelationNode relationNode;
    private List<SqlExpression> projectionList = new ArrayList<SqlExpression>();
    private List<QueryCondition> conditionList = new ArrayList<QueryCondition>();
    private List<Integer> joinList = new ArrayList<Integer>();
    private List<SqlExpression> groupByList = new ArrayList<SqlExpression>();
    private List<RelationNode> uncorrelatedCondTreeList = new ArrayList<RelationNode>();
    private int rowsize;
    private int selectRowSize;
    private long estCost;
    private long estRowsReturned;
    private long baseNumRows;
    private String label = "";
    private int nodeId;
    private QueryTree parentTree;
    private short outerLevel = 0;
    private short outerGroup = 0;
    private boolean isSubtreeOuter = false;
    private boolean isTreeDownJoin = false;
    private double rowReductionFactor = 1.0;

    public QueryNode() {
    }

    public QueryNode(RelationNode relationNode) {
        this();
        this.relationNode = relationNode;
        this.nodeId = relationNode.getNodeId();
        this.projectionList = relationNode.getProjectionList();
        this.conditionList = relationNode.getConditionList();
        this.selectRowSize = this.rowsize = relationNode.getRowsize();
        this.estCost = relationNode.getEstCost();
        this.estRowsReturned = relationNode.getEstRowsReturned();
        this.outerLevel = relationNode.getOuterLevel();
        if (relationNode.getNodeType() == 7) {
            this.setRowsize(1);
            this.setSelectRowSize(1);
            this.setEstRowsReturned(1L);
            this.setEstCost(1L);
        }
    }

    public QueryNode baseCopy() {
        QueryNode queryNode = new QueryNode();
        queryNode.nodeType = this.nodeType;
        queryNode.preserveSubtree = this.preserveSubtree;
        queryNode.relationNode = this.relationNode;
        queryNode.projectionList = this.projectionList;
        queryNode.conditionList = this.conditionList;
        queryNode.uncorrelatedCondTreeList = this.uncorrelatedCondTreeList;
        queryNode.groupByList = this.groupByList;
        queryNode.rowsize = this.rowsize;
        queryNode.selectRowSize = this.selectRowSize;
        queryNode.estCost = this.estCost;
        queryNode.estRowsReturned = this.estRowsReturned;
        queryNode.baseNumRows = this.baseNumRows;
        queryNode.label = this.label;
        queryNode.nodeId = this.nodeId;
        queryNode.isSubtreeOuter = this.isSubtreeOuter;
        queryNode.joinList.addAll(this.joinList);
        queryNode.outerLevel = this.outerLevel;
        queryNode.outerGroup = this.outerGroup;
        queryNode.rowReductionFactor = this.rowReductionFactor;
        queryNode.isTreeDownJoin = this.isTreeDownJoin;
        return queryNode;
    }

    public QueryNode subtreeFind(String string, String string2) {
        QueryNode queryNode = null;
        if (this.relationNode != null) {
            if (string.compareTo(this.relationNode.getTableName()) == 0 && string2.compareTo(this.relationNode.getAlias()) == 0) {
                return this;
            }
            return null;
        }
        if (this.leftNode != null) {
            queryNode = this.leftNode.subtreeFind(string, string2);
        }
        if (queryNode == null) {
            queryNode = this.rightNode != null ? this.rightNode.subtreeFind(string, string2) : null;
        }
        return queryNode;
    }

    public String toString(String string) {
        return null;
    }

    public boolean subtreeContains(QueryNode queryNode) {
        return this == queryNode || this.leftNode != null && (this.leftNode.subtreeContains(queryNode) || this.rightNode.subtreeContains(queryNode));
    }

    public boolean subtreeContains(RelationNode relationNode) {
        return this.relationNode == relationNode || this.leftNode != null && (this.leftNode.subtreeContains(relationNode) || this.rightNode.subtreeContains(relationNode));
    }

    public boolean isCorrelatedSubquery() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isCorrelatedSubquery();
        }
        return false;
    }

    public boolean isCorrelatedPlaceholder() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isCorrelatedPlaceholder();
        }
        return false;
    }

    public boolean isUncorrelatedSubquery() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isUncorrelatedSubquery();
        }
        return false;
    }

    public boolean isScalarSubquery() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isScalarSubquery();
        }
        return false;
    }

    public boolean isRelationSubquery() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isRelationSubquery();
        }
        return false;
    }

    public boolean isTable() {
        if (this.relationNode != null) {
            return this.nodeType == 2 && this.relationNode.isTable();
        }
        return false;
    }

    public void setBaseNumRows(long l) {
        this.baseNumRows = l;
    }

    public long getBaseNumRows() {
        return this.baseNumRows;
    }

    public void setConditionList(List<QueryCondition> list) {
        this.conditionList = list;
    }

    public List<QueryCondition> getConditionList() {
        return this.conditionList;
    }

    public void setEstCost(long l) {
        this.estCost = l;
    }

    public long getEstCost() {
        return this.estCost;
    }

    public void setEstRowsReturned(long l) {
        this.estRowsReturned = l;
    }

    public long getEstRowsReturned() {
        return this.estRowsReturned;
    }

    public void setGroupByList(List<SqlExpression> list) {
        this.groupByList = list;
    }

    public List<SqlExpression> getGroupByList() {
        return this.groupByList;
    }

    public void setSubtreeOuter(boolean bl) {
        this.isSubtreeOuter = bl;
    }

    public boolean isSubtreeOuter() {
        return this.isSubtreeOuter;
    }

    public void setTreeDownJoin(boolean bl) {
        this.isTreeDownJoin = bl;
    }

    public boolean isTreeDownJoin() {
        return this.isTreeDownJoin;
    }

    public List<Integer> getJoinList() {
        return this.joinList;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLeftNode(QueryNode queryNode) {
        this.leftNode = queryNode;
    }

    public QueryNode getLeftNode() {
        return this.leftNode;
    }

    public void setNodeId(int n) {
        this.nodeId = n;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setOuterGroup(short s) {
        this.outerGroup = s;
    }

    public short getOuterGroup() {
        return this.outerGroup;
    }

    public void setOuterLevel(short s) {
        this.outerLevel = s;
    }

    public short getOuterLevel() {
        return this.outerLevel;
    }

    public void setParent(QueryNode queryNode) {
        this.parent = queryNode;
    }

    public QueryNode getParent() {
        return this.parent;
    }

    public void setParentTree(QueryTree queryTree) {
        this.parentTree = queryTree;
    }

    public QueryTree getParentTree() {
        return this.parentTree;
    }

    public void setPreserveSubtree(boolean bl) {
        this.preserveSubtree = bl;
    }

    public boolean isPreserveSubtree() {
        return this.preserveSubtree;
    }

    public void setProjectionList(List<SqlExpression> list) {
        this.projectionList = list;
    }

    public List<SqlExpression> getProjectionList() {
        return this.projectionList;
    }

    public RelationNode getRelationNode() {
        return this.relationNode;
    }

    public void setRightNode(QueryNode queryNode) {
        this.rightNode = queryNode;
    }

    public QueryNode getRightNode() {
        return this.rightNode;
    }

    public void setRowReductionFactor(double d) {
        this.rowReductionFactor = d;
    }

    public double getRowReductionFactor() {
        return this.rowReductionFactor;
    }

    public void setRowsize(int n) {
        this.rowsize = n;
    }

    public int getRowsize() {
        return this.rowsize;
    }

    public void setSelectRowSize(int n) {
        this.selectRowSize = n;
    }

    public int getSelectRowSize() {
        return this.selectRowSize;
    }

    public List<RelationNode> getUncorrelatedCondTreeList() {
        return this.uncorrelatedCondTreeList;
    }
}

