/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.misc.combinedresultset;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.misc.combinedresultset.SortCriteria;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetPosManager
implements Runnable,
Comparable {
    private static final XLogger logger = XLogger.getLogger(ResultSetPosManager.class);
    private static final List<Object> END_MARK = new ArrayList<Object>();
    private ResultSet rs;
    private int colCount;
    private int distinctModifier;
    private List<SortCriteria> sortCriteriaList;
    private Object lastValue;
    private Object[] currentValue = null;
    private List currentRecord = null;
    int[] sortColPosition;
    private LinkedBlockingQueue<List<Object>> rowBuffer = new LinkedBlockingQueue(Props.XDB_COMBINED_RESULTSET_BUFFER);
    private volatile boolean closed = false;
    private static Executor fetchPool = Executors.newCachedThreadPool();
    private long rowCount = 0L;
    private long fetchTime = 0L;
    private long waitForNextRow = 0L;
    private long waitForClient = 0L;

    public ResultSetPosManager(ResultSet resultSet, List<SortCriteria> list, int n) {
        this.rs = resultSet;
        try {
            this.colCount = resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.sortCriteriaList = list;
        this.distinctModifier = n;
        this.sortColPosition = new int[list.size()];
        int n2 = 0;
        for (SortCriteria sortCriteria : this.sortCriteriaList) {
            int n3 = sortCriteria.getColumnPosition();
            this.sortColPosition[n2++] = n3 - 1;
        }
        fetchPool.execute(this);
    }

    public boolean next() {
        long l = System.currentTimeMillis();
        try {
            this.currentRecord = null;
            while (this.currentRecord == null) {
                this.currentRecord = this.rowBuffer.poll(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.currentRecord = null;
            return false;
        }
        this.waitForNextRow += System.currentTimeMillis() - l;
        if (this.currentRecord == END_MARK) {
            this.currentRecord = null;
            return false;
        }
        this.currentValue = new Object[this.sortColPosition.length];
        for (int i = 0; i < this.sortColPosition.length; ++i) {
            this.currentValue[i] = this.currentRecord.get(this.sortColPosition[i]);
        }
        return true;
    }

    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.colCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.currentRecord == null) {
            throw new SQLException("No current record");
        }
        this.lastValue = this.currentRecord.get(n - 1);
        return this.lastValue;
    }

    public boolean lastValueWasNull() {
        return this.lastValue == null;
    }

    public void close() {
        this.closed = true;
        this.rowBuffer.clear();
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
        }
        logger.log(Level.DEBUG, "Performance statistics:\nRow count: %0%\nOverall fetch time: %1%ms\nTotal time spent by client waiting for next record: %2%ms\nTotal time spent by Fetch Thread while buffer is full: %3%ms", new Object[]{new Long(this.rowCount), new Long(this.fetchTime), new Long(this.waitForNextRow), new Long(this.waitForClient)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long l = System.currentTimeMillis();
            try {
                while (this.rs.next()) {
                    if (this.closed) {
                        return;
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(this.colCount);
                    for (int i = 1; i <= this.colCount; ++i) {
                        arrayList.add(this.rs.getObject(i));
                    }
                    long l2 = System.currentTimeMillis();
                    try {
                        this.rowBuffer.put(arrayList);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waitForClient += System.currentTimeMillis() - l2;
                    ++this.rowCount;
                }
            }
            finally {
                this.fetchTime = System.currentTimeMillis() - l;
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
        }
        finally {
            while (!this.rowBuffer.offer(END_MARK)) {
            }
        }
    }

    public int compareTo(Object object) {
        ResultSetPosManager resultSetPosManager = this;
        ResultSetPosManager resultSetPosManager2 = (ResultSetPosManager)object;
        Object[] objectArray = resultSetPosManager.currentValue;
        Object[] objectArray2 = resultSetPosManager2.currentValue;
        int n = 0;
        for (SortCriteria sortCriteria : this.sortCriteriaList) {
            if (objectArray[n] == null && objectArray2[n] == null) {
                ++n;
                continue;
            }
            if (objectArray[n] == null) {
                switch (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE) {
                    case 1: {
                        return -1;
                    }
                    case 0: {
                        return 1;
                    }
                    case 3: {
                        return sortCriteria.getDirection() == 2 ? -1 : 1;
                    }
                }
                return sortCriteria.getDirection() == 2 ? 1 : -1;
            }
            if (objectArray2[n] == null) {
                switch (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE) {
                    case 1: {
                        return 1;
                    }
                    case 0: {
                        return -1;
                    }
                    case 3: {
                        return sortCriteria.getDirection() == 2 ? 1 : -1;
                    }
                }
                return sortCriteria.getDirection() == 2 ? -1 : 1;
            }
            int n2 = this.compare(objectArray[n], objectArray2[n]);
            if (n2 == 0) {
                ++n;
                continue;
            }
            return sortCriteria.getDirection() == 2 ? n2 : -n2;
        }
        return resultSetPosManager.distinctModifier == resultSetPosManager2.distinctModifier ? 0 : (resultSetPosManager.distinctModifier > resultSetPosManager2.distinctModifier ? 1 : -1);
    }

    private int compare(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            long l;
            boolean bl;
            boolean bl2 = bl = object instanceof Float || object instanceof Double || object instanceof BigDecimal || object2 instanceof Float || object2 instanceof Double || object2 instanceof BigDecimal;
            if (bl) {
                double d;
                double d2 = ((Number)object).doubleValue();
                if (d2 == (d = ((Number)object2).doubleValue())) {
                    return 0;
                }
                return d2 > d ? 1 : -1;
            }
            long l2 = ((Number)object).longValue();
            if (l2 == (l = ((Number)object2).longValue())) {
                return 0;
            }
            return l2 > l ? 1 : -1;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).compareTo((Date)object2);
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return object.equals(object2) ? 0 : ((Boolean)object != false ? 1 : -1);
        }
        String string = object.toString();
        String string2 = object2.toString();
        if (Props.XDB_COMBINED_RESULTSET_SORT_TRIM) {
            string = string.trim();
            string2 = string2.trim();
        }
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (!Props.XDB_COMBINED_RESULTSET_SORT_CASE_SENSITIVE) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) continue;
            return c > c2 ? 1 : -1;
        }
        return string.length() > n ? 1 : (string2.length() > n ? -1 : 0);
    }

    public boolean equals(Object object) {
        return this == object || this.compareTo(object) == 0;
    }

    public String toString() {
        String string = "";
        int n = 0;
        for (SortCriteria sortCriteria : this.sortCriteriaList) {
            string = string + "Column Postion  : " + sortCriteria.getColumnPosition() + "        Value : " + this.currentValue[n];
            ++n;
        }
        return string;
    }
}

