/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.scheduler.RequestCost;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Scheduler
implements Runnable {
    private static final int QUERY_LIMIT = Property.getInt("xdb.jdbc.pool.query.count", Property.getInt("xdb.jdbc.pool.maxsize", 10));
    private static final int LARGE_QUERY_LIMIT = Property.getInt("xdb.jdbc.pool.largequery.count", 2);
    private final TreeMap<RequestCost, XDBSessionContext> serviceQueue = new TreeMap();
    private final AtomicInteger queryCount = new AtomicInteger(0);
    private final AtomicInteger largeQueryCount = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(RequestCost requestCost, XDBSessionContext xDBSessionContext) {
        boolean bl;
        Object object = this;
        synchronized (object) {
            bl = this.serviceQueue.isEmpty();
            this.serviceQueue.put(requestCost, xDBSessionContext);
            this.notifyAll();
        }
        if (!bl) {
            object = xDBSessionContext;
            synchronized (object) {
                try {
                    xDBSessionContext.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.queryCount.incrementAndGet();
        if (requestCost.isLarge()) {
            this.largeQueryCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDBSessionContext removeRequest(RequestCost requestCost) {
        XDBSessionContext xDBSessionContext;
        this.queryCount.decrementAndGet();
        if (requestCost.isLarge()) {
            this.largeQueryCount.decrementAndGet();
        }
        Object object = this;
        synchronized (object) {
            xDBSessionContext = this.serviceQueue.remove(requestCost);
            this.notifyAll();
        }
        if (xDBSessionContext != null) {
            object = xDBSessionContext;
            synchronized (object) {
                xDBSessionContext.notifyAll();
            }
        }
        return xDBSessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void holdRequest(RequestCost requestCost) {
        XDBSessionContext xDBSessionContext = this.removeRequest(requestCost);
        if (xDBSessionContext != null) {
            Scheduler scheduler = this;
            synchronized (scheduler) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.addRequest(requestCost, xDBSessionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            for (Map.Entry<RequestCost, XDBSessionContext> entry : this.serviceQueue.entrySet()) {
                if (QUERY_LIMIT <= this.queryCount.get()) break;
                if (entry.getKey().isLarge() && LARGE_QUERY_LIMIT <= this.largeQueryCount.get()) continue;
                XDBSessionContext xDBSessionContext = entry.getValue();
                synchronized (xDBSessionContext) {
                    entry.getValue().notifyAll();
                }
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

