/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.metadata.scheduler.ITransaction;
import com.edb.gridsql.metadata.scheduler.Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockTable<T extends ITransaction, MO>
implements Cloneable {
    private HashMap<T, HashMap<MO, Lock<MO>>> storage = new HashMap();
    private HashMap<MO, HashMap<T, Lock<MO>>> index = new HashMap();

    public HashMap<MO, Lock<MO>> getLocksByTransaction(T t) {
        return this.storage.get(t);
    }

    public HashMap<T, Lock<MO>> getLocksByManagedObject(MO MO) {
        return this.index.get(MO);
    }

    public synchronized void removeLocks(T t) {
        HashMap<MO, Lock<MO>> hashMap = this.storage.remove(t);
        if (hashMap != null) {
            for (MO MO : hashMap.keySet()) {
                HashMap<T, Lock<MO>> hashMap2 = this.index.get(MO);
                hashMap2.remove(t);
                if (!hashMap2.isEmpty()) continue;
                this.index.remove(MO);
            }
        }
    }

    public synchronized void addLocks(T t, Collection<Lock<MO>> collection) {
        for (Lock<MO> lock : collection) {
            Lock<MO> lock2;
            HashMap<Object, Lock<Object>> hashMap = this.storage.get(t);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.storage.put(t, hashMap);
            }
            if ((lock2 = hashMap.get(lock.getManagedObject())) == null) {
                hashMap.put(lock.getManagedObject(), lock);
                HashMap<Object, Lock<Object>> hashMap2 = this.index.get(lock.getManagedObject());
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    this.index.put(lock.getManagedObject(), hashMap2);
                }
                hashMap2.put(t, lock);
                continue;
            }
            lock2.merge(lock);
        }
    }

    public synchronized boolean checkLocks(T t, Collection<Lock<MO>> collection) {
        for (Lock<MO> lock : collection) {
            Cloneable cloneable;
            HashMap<MO, Lock<MO>> hashMap = this.storage.get(t);
            if (hashMap != null && !lock.stricterThan((Lock<MO>)(cloneable = hashMap.get(lock.getManagedObject()))) || (cloneable = this.index.get(lock.getManagedObject())) == null) continue;
            for (Map.Entry entry : ((HashMap)cloneable).entrySet()) {
                if (entry.getKey() == t || lock.isCompatible((Lock)entry.getValue(), t.getTransactionIsolation(), ((ITransaction)entry.getKey()).getTransactionIsolation())) continue;
                return false;
            }
        }
        return true;
    }

    Collection<T> getTransactions() {
        return new ArrayList<T>(this.storage.keySet());
    }

    public synchronized Object clone() {
        LockTable lockTable = null;
        try {
            lockTable = (LockTable)super.clone();
            lockTable.storage = (HashMap)this.storage.clone();
            for (Map.Entry<T, HashMap<MO, Lock<MO>>> entry : this.storage.entrySet()) {
                lockTable.storage.put(entry.getKey(), (HashMap)entry.getValue().clone());
            }
            lockTable.index = (HashMap)this.index.clone();
            for (Map.Entry<Object, HashMap<Object, Lock<MO>>> entry : this.index.entrySet()) {
                lockTable.index.put(entry.getKey(), (HashMap)entry.getValue().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return lockTable;
    }

    public String toString() {
        return "<LockTable: " + this.storage + ">";
    }
}

