/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.metadata.scheduler.LockType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lock<MO>
implements Cloneable {
    static final XLogger CATEGORY_LOCK = XLogger.getLogger("Locks");
    private MO managedObject;
    private HashSet<LockType> lockTable = new HashSet();

    public Lock(MO MO) {
        this.managedObject = MO;
    }

    public Lock(MO MO, LockType lockType) {
        this.managedObject = MO;
        this.lockTable.add(lockType);
    }

    public Lock(MO MO, Collection<LockType> collection) {
        this.managedObject = MO;
        this.lockTable.addAll(collection);
    }

    boolean stricterThan(Lock<MO> lock) {
        if (lock != null) {
            for (LockType lockType : lock.lockTable) {
                for (LockType lockType2 : this.lockTable) {
                    if (lockType2.stricterThen(lockType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    void merge(Lock<MO> lock) {
        for (LockType lockType : lock.lockTable) {
            boolean bl = true;
            Iterator<LockType> iterator = this.lockTable.iterator();
            while (iterator.hasNext()) {
                LockType lockType2 = iterator.next();
                if (lockType.stricterThen(lockType2)) {
                    iterator.remove();
                }
                if (!lockType2.stricterThen(lockType)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.lockTable.add(lockType);
        }
    }

    boolean isCompatible(Lock<MO> lock, int n, int n2) {
        if (lock == null || lock.managedObject != this.managedObject) {
            return true;
        }
        for (LockType lockType : lock.lockTable) {
            for (LockType lockType2 : this.lockTable) {
                if (lockType.isCompatible(lockType2, n, n2)) continue;
                return false;
            }
        }
        return true;
    }

    boolean forRead() {
        for (LockType lockType : this.lockTable) {
            if (!lockType.forRead()) continue;
            return true;
        }
        return false;
    }

    boolean forWrite() {
        for (LockType lockType : this.lockTable) {
            if (!lockType.forWrite()) continue;
            return true;
        }
        return false;
    }

    public MO getManagedObject() {
        return this.managedObject;
    }

    public String toString() {
        return "<" + this.managedObject + this.lockTable + ">";
    }
}

