/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBGeneratorException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysSerialGenerator;
import java.sql.ResultSet;
import java.util.Map;

public class SysSerialIDHandler
extends SysSerialGenerator {
    private SysColumn column;
    private XDBSessionContext client;

    SysSerialIDHandler(SysColumn sysColumn) {
        this.column = sysColumn;
        switch (sysColumn.getColType()) {
            case 5: {
                this.setMaxValue(32767L);
                break;
            }
            case 4: {
                this.setMaxValue(Integer.MAX_VALUE);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateRange(long l, XDBSessionContext xDBSessionContext) throws XDBGeneratorException {
        this.client = xDBSessionContext;
        try {
            long l2 = this.allocateRange(l);
            return l2;
        }
        finally {
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() throws XDBGeneratorException {
        if (this.client == null) {
            throw new XDBGeneratorException("Can not update SerialID generator - client session is not supplied");
        }
        String string = "select max(" + this.column.getColName() + " ) from " + this.column.getSysTable().getTableName();
        Engine engine = Engine.getInstance();
        try {
            long l = 0L;
            Map<Integer, ResultSet> map = engine.executeQueryOnMultipleNodes(string, this.column.getSysTable().getJoinNodeList(), this.client);
            for (ResultSet resultSet : map.values()) {
                try {
                    long l2;
                    if (!resultSet.next() || (l2 = resultSet.getLong(1)) <= l) continue;
                    l = l2;
                }
                finally {
                    resultSet.close();
                }
            }
            this.update(l + 1L);
        }
        catch (Exception exception) {
            throw new XDBGeneratorException("Failed to update SerialID generator", exception);
        }
    }
}

