/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.HelperSysIndex;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysRowIDHandler;
import com.edb.gridsql.metadata.SysSerialIDHandler;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.scheduler.Balancer;
import com.edb.gridsql.metadata.scheduler.LockManager;
import com.edb.gridsql.metadata.scheduler.Scheduler;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysDatabase {
    private static final XLogger logger = XLogger.getLogger(SysDatabase.class);
    private static final int MIN_TEMP_TABLE_ID = 0x7FFFF000;
    private static final int MAX_TEMP_TABLE_ID = Integer.MAX_VALUE;
    private static SysDatabase ADMIN_DATABASE;
    private int dbid;
    private String dbname;
    private Hashtable<Integer, SysTable> sysTableIndex;
    private Hashtable<String, SysTable> sysTables;
    private Hashtable<String, SysView> sysViews;
    private Hashtable<Integer, SysView> sysViewsIndex;
    private Hashtable<String, SysTable> sysTempTables;
    private Hashtable<Integer, SysUser> sysUserList;
    private TreeMap<Integer, DBNode> dbNodeList;
    private int tempTableID = 0x7FFFF000;
    private long counter = 0L;
    private boolean started = false;
    private Scheduler sc;
    private Balancer balancer;
    private LockManager lm;

    static SysDatabase getAdminDatabase() {
        if (ADMIN_DATABASE == null) {
            ADMIN_DATABASE = new SysDatabase(-1, Props.XDB_ADMIN_DATABASE);
            SysDatabase.ADMIN_DATABASE.started = true;
            ADMIN_DATABASE.readLoginInfo();
        }
        return ADMIN_DATABASE;
    }

    SysDatabase(int n, String string) {
        this.dbid = n;
        this.dbname = string;
        this.sysTableIndex = new Hashtable();
        this.sysTables = new Hashtable();
        this.sysViews = new Hashtable();
        this.sysViewsIndex = new Hashtable();
        this.sysTempTables = new Hashtable();
        this.dbNodeList = new TreeMap();
        this.sysUserList = new Hashtable();
        this.initSchedulingMechanism();
        this.initBalancer();
    }

    public int getDbid() {
        return this.dbid;
    }

    void setDbid(int n) {
        if (this.dbid == -1) {
            this.dbid = n;
        }
    }

    public int getInitialNodeID() {
        if (this.dbNodeList.isEmpty()) {
            this.readDatabaseInfo();
        }
        int n = this.chooseTempNodeId();
        return n;
    }

    public String getDbname() {
        return this.dbname;
    }

    public LockManager getLm() {
        return this.lm;
    }

    private void initSchedulingMechanism() {
        this.sc = new Scheduler();
        Thread thread = new Thread((Runnable)this.sc, this.dbname + " Scheduler Thread");
        thread.setDaemon(true);
        thread.start();
        this.lm = new LockManager();
    }

    private void initBalancer() {
        this.balancer = new Balancer(this);
    }

    public Scheduler getScheduler() {
        return this.sc;
    }

    public Balancer getBalancer() {
        return this.balancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void admin() {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            if (this.dbNodeList.isEmpty()) {
                this.readDatabaseInfo();
            }
            object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBNode> start() {
        LinkedList<DBNode> linkedList = new LinkedList<DBNode>();
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            this.started = true;
            if (this.dbNodeList.isEmpty()) {
                this.readDatabaseInfo();
            }
            for (DBNode dBNode : this.getDBNodeList()) {
                DBNode dBNode2 = dBNode;
                if (dBNode2.isOnline() || !dBNode2.getNode().isUp()) continue;
                linkedList.add(dBNode2);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBNode> stop() {
        LinkedList<DBNode> linkedList = new LinkedList<DBNode>();
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            this.started = false;
            for (DBNode dBNode : this.getDBNodeList()) {
                if (!dBNode.isOnline() || !dBNode.getNode().isUp()) continue;
                linkedList.add(dBNode);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            return this.started;
        }
    }

    synchronized void addDbNode(DBNode dBNode) {
        this.dbNodeList.put(dBNode.getNode().getNodeid(), dBNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline() {
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            if (!this.started) {
                return false;
            }
            for (DBNode dBNode : this.dbNodeList.values()) {
                if (dBNode.isOnline()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForOnline(long l) {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            long l2 = System.currentTimeMillis();
            long l3 = l;
            while (l3 > 0L) {
                if (this.isOnline()) {
                    return true;
                }
                try {
                    object.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l3 = l2 + l - System.currentTimeMillis();
            }
            LinkedList<DBNode> linkedList = new LinkedList<DBNode>();
            for (DBNode dBNode : this.dbNodeList.values()) {
                if (dBNode.isOnline()) continue;
                linkedList.add(dBNode);
            }
            if (!linkedList.isEmpty()) {
                XLogger.getLogger("Server").log(Level.INFO, "DB Nodes are not online: %0%", new Object[]{linkedList});
            }
        }
        return this.isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readLoginInfo() throws XDBServerException {
        MetaData metaData = MetaData.getMetaData();
        for (SysLogin sysLogin : metaData.getSysLogins()) {
            int n = sysLogin.getLoginID();
            SysUser sysUser = new SysUser(n, sysLogin, this);
            this.insertUser(sysUser);
        }
    }

    private synchronized void readDatabaseInfo() throws XDBServerException {
        try {
            Object object;
            Object object3;
            Object object4;
            MetaData metaData = MetaData.getMetaData();
            this.readLoginInfo();
            String string = "SELECT nodeid FROM xsysdbnodes WHERE dbid = " + this.dbid;
            ResultSet resultSet = metaData.executeQuery(string);
            while (resultSet.next()) {
                object4 = metaData.getNode(resultSet.getInt("nodeid"));
                new DBNode((Node)object4, this);
            }
            object4 = metaData.executeQuery("SELECT * from xsystables WHERE dbid = " + this.dbid);
            while (object4.next()) {
                int n;
                int n2;
                object3 = object4.getString("partcol");
                String object22 = object4.getString("clusteridx");
                if (object3 != null) {
                    object3 = ((String)object3).trim();
                }
                object = null;
                int n3 = object4.getInt("owner");
                if (n3 > 0) {
                    object = this.getSysUser(n3);
                }
                if ((n2 = object4.getInt("parentid")) <= 0) {
                    n2 = -1;
                }
                if ((n = object4.getInt("tablespaceid")) <= 0) {
                    n = -1;
                }
                SysTable sysTable = new SysTable(this, object4.getInt("tableid"), object4.getString("tablename").trim(), object4.getLong("numrows"), object4.getShort("partscheme"), (String)object3, (SysUser)object, n2, n, object22);
                this.addSysTable(sysTable);
            }
            for (SysTable sysTable : this.sysTables.values()) {
                sysTable.readTableInfo(false);
            }
            object3 = this.getAllTables();
            while (object3.hasMoreElements()) {
                SysTable sysTable = (SysTable)object3.nextElement();
                sysTable.updateCrossReferences();
            }
            ResultSet resultSet2 = metaData.executeQuery("SELECT * from xsysviews WHERE dbid = " + this.dbid);
            while (resultSet2.next()) {
                object = new SysView(this, resultSet2.getInt("viewid"), resultSet2.getString("viewname").trim(), resultSet2.getString("viewtext").trim());
                this.addSysView((SysView)object);
            }
            this.initSchedulingMechanism();
            this.initBalancer();
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, sQLException, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SysUser getSysUser(int n) throws XDBServerException {
        Integer n2 = new Integer(n);
        SysUser sysUser = this.sysUserList.get(n2);
        if (sysUser == null) {
            XDBServerException xDBServerException = new XDBServerException("User " + n + " is not found");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        SysUser sysUser2 = sysUser;
        return sysUser2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized SysUser getSysUser(String string) throws XDBServerException {
        SysUser sysUser;
        SysUser sysUser2;
        Object object = this.sysUserList.values().iterator();
        do {
            if (object.hasNext()) continue;
            object = new XDBServerException("User \"" + string + "\" is not found");
            logger.throwing((Throwable)object);
            throw object;
        } while (!string.equals((sysUser2 = (sysUser = object.next())).getName()));
        return sysUser2;
    }

    public Collection<SysUser> getSysUsers() {
        return this.sysUserList.values();
    }

    public Collection<SysView> getSysViews() {
        return this.sysViews.values();
    }

    public synchronized void addSysTable(SysTable sysTable) {
        this.sysTables.put(sysTable.getTableName(), sysTable);
        this.sysTableIndex.put(sysTable.getTableId(), sysTable);
    }

    public synchronized void addSysView(SysView sysView) {
        this.sysViews.put(sysView.getViewName(), sysView);
        this.sysViewsIndex.put(new Integer(sysView.getViewid()), sysView);
    }

    public synchronized void addSysTempTable(SysTable sysTable) {
        this.sysTempTables.put(sysTable.getTableName(), sysTable);
        this.sysTableIndex.put(new Integer(sysTable.getTableId()), sysTable);
    }

    public synchronized SysTable getSysTable(String string) {
        SysTable sysTable = null;
        sysTable = this.sysTables.get(string);
        if (sysTable == null) {
            sysTable = this.sysTempTables.get(string);
        }
        if (sysTable == null) {
            XDBServerException xDBServerException = new XDBServerException("Table " + string + " has not been found in database " + this.dbname);
            throw xDBServerException;
        }
        return sysTable;
    }

    public synchronized SysTable checkForSysTable(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        SysTable sysTable = null;
        sysTable = this.sysTables.get(string);
        if (sysTable == null) {
            sysTable = this.sysTempTables.get(string);
        }
        return sysTable;
    }

    public synchronized SysView getSysView(String string) {
        SysView sysView = null;
        sysView = this.sysViews.get(string);
        if (sysView == null) {
            XDBServerException xDBServerException = new XDBServerException("View " + string + " has not been found in database " + this.dbname);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        return sysView;
    }

    public synchronized SysTable getSysTable(int n) {
        return this.sysTableIndex.get(new Integer(n));
    }

    public synchronized SysView getSysView(int n) {
        return this.sysViewsIndex.get(new Integer(n));
    }

    public synchronized void dropSysTable(String string) {
        SysTable sysTable = !this.sysTempTables.containsKey(string) ? this.sysTables.remove(string) : this.sysTempTables.remove(string);
        if (sysTable != null) {
            this.sysTableIndex.remove(new Integer(sysTable.getTableId()));
            SysUser sysUser = sysTable.getOwner();
            if (sysUser != null) {
                sysUser.removeOwned(sysTable);
            }
            sysTable.setParentTableID(-1);
        }
    }

    public synchronized void dropSysView(String string) {
        SysView sysView = this.sysViews.remove(string);
        if (sysView != null) {
            this.sysViewsIndex.remove(new Integer(sysView.getViewid()));
        }
    }

    public synchronized Enumeration getAllTables() {
        return Collections.enumeration(this.sysTableIndex.values());
    }

    public synchronized Enumeration getAllViews() {
        return Collections.enumeration(this.sysViewsIndex.values());
    }

    public synchronized HelperSysIndex getSysIndexByName(String string) throws XDBServerException {
        HelperSysIndex helperSysIndex = null;
        Enumeration<SysTable> enumeration = this.sysTables.elements();
        while (enumeration.hasMoreElements()) {
            SysTable sysTable = enumeration.nextElement();
            SysIndex sysIndex = sysTable.getSysIndex(string);
            if (sysIndex == null || sysTable.getParentTable() != null && sysTable.getParentTable().getSysIndex(sysIndex.idxid) == sysIndex) continue;
            if (helperSysIndex != null) {
                throw new XDBServerException("Ambiguous index name.");
            }
            helperSysIndex = new HelperSysIndex(sysTable, sysIndex);
        }
        return helperSysIndex;
    }

    public synchronized Collection<DBNode> getDBNodeList() {
        return this.dbNodeList.values();
    }

    public synchronized DBNode getDBNode(int n) throws XDBServerException {
        DBNode dBNode = this.dbNodeList.get(n);
        if (dBNode == null) {
            XDBServerException xDBServerException = new XDBServerException("Node " + n + " is not used by Database " + this.dbname);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        return dBNode;
    }

    synchronized void removeDBNode(int n) {
        this.dbNodeList.remove(n);
    }

    public String getUniqueTableName(String string, String string2, XDBSessionContext xDBSessionContext) {
        return this.getUniqueTempTableName(string);
    }

    public String getUniqueTempTableName(String string) {
        if (!string.startsWith(Props.XDB_TEMPTABLEPREFIX)) {
            string = Props.XDB_TEMPTABLEPREFIX + string;
        }
        String string2 = string;
        while (this.isTableExists(string2)) {
            if (this.counter == Long.MAX_VALUE) {
                this.counter = 0L;
            }
            string2 = string + "_" + this.counter++;
        }
        return string2;
    }

    private int getNextTempTableID() {
        block3: {
            int n = 4095;
            do {
                int n2;
                if (this.tempTableID == Integer.MAX_VALUE) {
                    n2 = this.tempTableID = 0x7FFFF000;
                } else {
                    n2 = this.tempTableID + 1;
                    this.tempTableID = this.tempTableID;
                }
                if (this.getSysTable(n2) == null) break block3;
            } while (n-- >= 0);
            throw new XDBServerException("Out of temp table name space");
        }
        return this.tempTableID;
    }

    public synchronized SysTable createTempSysTable(String string, short s, PartitionMap partitionMap, String string2, SysSerialIDHandler sysSerialIDHandler, SysRowIDHandler sysRowIDHandler, Collection<SysColumn> collection) throws Exception {
        SysTable sysTable = new SysTable(this, this.getNextTempTableID(), this.getUniqueTempTableName(string), 0L, s, string2, null, -1, -1, null);
        sysTable.setTableTemporary(true);
        sysTable.setPartitionMap(partitionMap);
        int n = 1;
        for (SysColumn sysColumn : collection) {
            SysColumn sysColumn2 = new SysColumn(sysTable, n, n, sysColumn.getColName(), sysColumn.getColType(), sysColumn.getColLength(), sysColumn.getColScale(), sysColumn.getColPrecision(), sysColumn.isNullable(), sysColumn.isSerial(), sysColumn.getNativeColDef(), sysColumn.getSelectivity(), sysColumn.getDefaultExpr());
            sysTable.addSysColumn(sysColumn2);
            ++n;
        }
        sysTable.refreshAssociatedInfo();
        sysTable.setSerialIDHandler(sysSerialIDHandler);
        sysTable.setRowIDHandler(sysRowIDHandler);
        this.addSysTempTable(sysTable);
        return sysTable;
    }

    public synchronized SysTable createSysTable(String string, short s, PartitionMap partitionMap, String string2, SysSerialIDHandler sysSerialIDHandler, SysRowIDHandler sysRowIDHandler, List<SqlCreateTableColumn> list, SysTablespace sysTablespace, boolean bl, XDBSessionContext xDBSessionContext) throws Exception {
        SysTable sysTable = new SysTable(this, this.getNextTempTableID(), bl ? this.getUniqueTempTableName(string) : string, 0L, s, string2, null, -1, -1, null);
        sysTable.setTableTemporary(bl);
        sysTable.setPartitionMap(partitionMap);
        int n = 1;
        for (SqlCreateTableColumn sqlCreateTableColumn : list) {
            SysColumn sysColumn = new SysColumn(sysTable, n, n, sqlCreateTableColumn.columnName, sqlCreateTableColumn.getColumnType(), sqlCreateTableColumn.getColumnLength(), sqlCreateTableColumn.getColumnScale(), sqlCreateTableColumn.getColumnPrecision(), true, false, sqlCreateTableColumn.rebuildString(), 0.0, null);
            sysTable.addSysColumn(sysColumn);
            ++n;
        }
        sysTable.refreshAssociatedInfo();
        sysTable.setSerialIDHandler(sysSerialIDHandler);
        sysTable.setRowIDHandler(sysRowIDHandler);
        sysTable.setTablespace(sysTablespace);
        sysTable.setOwner(xDBSessionContext.getCurrentUser());
        return sysTable;
    }

    public synchronized boolean isTableExists(String string) {
        return this.sysTables.containsKey(string) || this.sysTempTables.containsKey(string);
    }

    public synchronized boolean isViewExists(String string) {
        return this.sysViews.containsKey(string);
    }

    public DBNode getLowestNode() {
        Iterator<DBNode> iterator = this.getDBNodeList().iterator();
        DBNode dBNode = null;
        while (iterator.hasNext()) {
            DBNode dBNode2 = iterator.next();
            if (dBNode == null) {
                dBNode = dBNode2;
                continue;
            }
            if (dBNode.getNodeId() <= dBNode2.getNodeId()) continue;
            dBNode = dBNode2;
        }
        return dBNode;
    }

    public void renameSysTable(String string, String string2) {
        SysTable sysTable = this.sysTables.remove(string);
        sysTable.setName(string2);
        this.sysTables.put(string2, sysTable);
    }

    public synchronized Collection<SysTable> getSysTables() {
        return this.sysTables.values();
    }

    public synchronized boolean hasSysUser(String string) {
        String string2 = string.toUpperCase();
        for (SysUser sysUser : this.sysUserList.values()) {
            SysUser sysUser2 = sysUser;
            if (!string2.equals(sysUser2.getName().toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public void insertUser(SysUser sysUser) {
        this.sysUserList.put(new Integer(sysUser.getUserID()), sysUser);
    }

    public void removeUser(String string) {
        Iterator<SysUser> iterator = this.sysUserList.values().iterator();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().getName())) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return "Db:" + this.dbname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBNode> createDBNodes(Collection<Integer> collection) {
        ArrayList<DBNode> arrayList;
        ArrayList<DBNode> arrayList2 = new ArrayList<DBNode>(collection.size());
        ArrayList<DBNode> arrayList3 = arrayList = MetaData.getMetaData().getStartupLock();
        synchronized (arrayList3) {
            SysDatabase sysDatabase = this;
            synchronized (sysDatabase) {
                MetaData metaData = MetaData.getMetaData();
                for (Integer n : collection) {
                    arrayList2.add(new DBNode(metaData.getNode(n), this));
                }
            }
            arrayList.notifyAll();
        }
        this.initBalancer();
        arrayList3 = arrayList2;
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteDBNodes(Collection<DBNode> collection) {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            SysDatabase sysDatabase = this;
            synchronized (sysDatabase) {
                for (DBNode dBNode : collection) {
                    this.dbNodeList.remove(dBNode.getNodeId());
                }
            }
            object.notifyAll();
        }
        this.initBalancer();
    }

    private synchronized int chooseTempNodeId() {
        Integer n;
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        for (SysTable sysTable : this.sysTables.values()) {
            for (DBNode object : sysTable.getNodeList()) {
                n = (Integer)hashtable.get(object.getNodeId());
                if (n == null) {
                    hashtable.put(object.getNodeId(), 1);
                    continue;
                }
                hashtable.put(object.getNodeId(), n + 1);
            }
        }
        int n2 = 0;
        int n3 = 0;
        for (Integer n4 : hashtable.keySet()) {
            n = (Integer)hashtable.get(n4);
            if (n > n2) {
                n3 = n4;
                n2 = n;
                continue;
            }
            if (n != n2 || n4 != Props.XDB_COORDINATOR_NODE) continue;
            n3 = n4;
        }
        if (n3 == 0) {
            for (DBNode dBNode : this.getDBNodeList()) {
                if (dBNode.getNodeId() == Props.XDB_COORDINATOR_NODE) {
                    return Props.XDB_COORDINATOR_NODE;
                }
                n3 = dBNode.getNodeId();
            }
        }
        return n3;
    }
}

