/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysColumn {
    private SysTable table;
    private int colid;
    private int colseq;
    private String colname;
    private int coltype;
    private int collength;
    private int colscale;
    private int colprecision;
    private boolean isnullable;
    private boolean isserial;
    private String nativecoldef;
    private int indextype;
    private double selectivity;
    private String defaultExpr = "";
    public boolean isWithTimeZone;
    private Vector<SysIndex> indexUsage;
    public SysIndex bestIndex;
    public int bestIndexColPos;
    public int bestIndexRowsPerPage;

    public SysColumn(SysTable sysTable, int n, int n2, String string, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, String string2, double d, String string3) {
        this.table = sysTable;
        this.colid = n;
        this.colseq = n2;
        this.colname = string;
        this.coltype = n3;
        this.collength = n4;
        this.colscale = n5;
        this.colprecision = n6;
        this.isnullable = bl;
        this.isserial = bl2;
        this.nativecoldef = string2;
        this.indextype = 6;
        this.selectivity = d;
        this.defaultExpr = string3;
    }

    public Enumeration<Integer> getChildColumns() {
        Vector<Integer> vector = new Vector<Integer>();
        String string = "select colid from xsysforeignkeys where refcolid = '" + this.colid + " '";
        try {
            ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
            while (resultSet.next()) {
                int n = resultSet.getInt("colid");
                vector.add(new Integer(n));
            }
            return vector.elements();
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + "( " + string + " )", sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
        }
    }

    public int hashCode() {
        return this.table == null ? this.colname.hashCode() : this.table.hashCode() + this.colname.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SysColumn) {
            SysColumn sysColumn = (SysColumn)object;
            return sysColumn.table == this.table && sysColumn.colname.equals(this.colname);
        }
        return false;
    }

    public void setSelectivity(double d) {
        this.selectivity = d;
    }

    public int getColumnLength() {
        int n;
        switch (this.coltype) {
            case -7: {
                n = 1;
                break;
            }
            case 1: {
                n = this.collength;
                break;
            }
            case 12: {
                n = this.collength / 3;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 91: {
                n = 2;
                break;
            }
            case 92: {
                n = 2;
                break;
            }
            case 93: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            case 16: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public void addIndexUsage(SysIndex sysIndex, int n) {
        if (this.indexUsage == null || n < this.bestIndexColPos || n == this.bestIndexColPos && sysIndex.estRowsPerPage < this.bestIndexRowsPerPage) {
            this.bestIndex = sysIndex;
            this.bestIndexColPos = n;
            this.bestIndexRowsPerPage = sysIndex.estRowsPerPage;
        }
        if (this.indexUsage == null) {
            this.indexUsage = new Vector();
        }
        this.indexUsage.add(sysIndex);
    }

    public String getColumnDefinition() {
        return this.nativecoldef;
    }

    public boolean hasDefault() {
        return this.defaultExpr != null && !this.defaultExpr.equals("null");
    }

    public String getDefaultValue(XDBSessionContext xDBSessionContext) throws Exception {
        if (this.isserial) {
            return "" + this.table.getSerialHandler().allocateRange(1L, xDBSessionContext);
        }
        if ("xrowid".equalsIgnoreCase(this.colname)) {
            return "" + this.table.getRowIDHandler().allocateRange(1L, xDBSessionContext);
        }
        if (this.defaultExpr != null) {
            switch (this.coltype) {
                case 91: 
                case 92: 
                case 93: {
                    if (this.defaultExpr.equalsIgnoreCase("CURRENT_DATE")) {
                        return "date '" + new Date(System.currentTimeMillis()) + "'";
                    }
                    if (this.defaultExpr.equalsIgnoreCase("CURRENT_TIMESTAMP") || this.defaultExpr.equalsIgnoreCase("NOW") || this.defaultExpr.equalsIgnoreCase("LOCALTIMESTAMP") || this.defaultExpr.equalsIgnoreCase("CLOCK_TIMESTAMP")) {
                        return "timestamp '" + new Timestamp(System.currentTimeMillis()) + "'";
                    }
                    if (!this.defaultExpr.equalsIgnoreCase("CURRENT_TIME") && !this.defaultExpr.equalsIgnoreCase("LOCALTIME")) break;
                    return "time '" + new Time(System.currentTimeMillis()) + "'";
                }
            }
        }
        return this.defaultExpr;
    }

    public SysTable getSysTable() {
        return this.table;
    }

    public int getColID() {
        return this.colid;
    }

    public int getColSeq() {
        return this.colseq;
    }

    public String getColName() {
        return this.colname;
    }

    public int getColType() {
        return this.coltype;
    }

    public int getColLength() {
        return this.collength == 0 ? this.colprecision : this.collength;
    }

    public int getColScale() {
        return this.colscale;
    }

    public int getColPrecision() {
        return this.colprecision;
    }

    public boolean isNullable() {
        return this.isnullable;
    }

    public boolean isSerial() {
        return this.isserial;
    }

    public String getNativeColDef() {
        return this.nativecoldef;
    }

    public void setIndexType(int n) {
        this.indextype = n;
    }

    public int getIndexType() {
        return this.indextype;
    }

    public double getSelectivity() {
        return this.selectivity;
    }

    public String getDefaultExpr() {
        return this.defaultExpr;
    }
}

