/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.SqlCreateView;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SyncCreateView
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncCreateView.class);
    private SqlCreateView parent;
    private SysDatabase database;
    private int viewid;

    public SyncCreateView(SqlCreateView sqlCreateView) {
        this.parent = sqlCreateView;
    }

    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        this.execute(xDBSessionContext.getSysDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SysDatabase sysDatabase) throws Exception {
        block12: {
            Serializable serializable;
            this.database = sysDatabase;
            MetaData metaData = MetaData.getMetaData();
            ResultSet resultSet = metaData.executeQuery("SELECT max(viewid) FROM xsysviews");
            try {
                resultSet.next();
                this.viewid = resultSet.getInt(1) + 1;
            }
            finally {
                resultSet.close();
            }
            String string = "INSERT INTO xsysviews (dbid, viewid, viewname, viewtext) VALUES (?, ?, ?, ?)";
            PreparedStatement preparedStatement = metaData.prepareStatement(string);
            preparedStatement.setInt(1, sysDatabase.getDbid());
            preparedStatement.setInt(2, this.viewid);
            preparedStatement.setString(3, this.parent.getViewName());
            preparedStatement.setString(4, this.parent.getSelectString());
            if (preparedStatement.executeUpdate() != 1) {
                XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsysviews\"");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            if (this.parent.getColList() == null) break block12;
            int n = -1;
            resultSet = metaData.executeQuery("SELECT max(viewcolid) FROM xsysviewscolumns");
            try {
                resultSet.next();
                n = resultSet.getInt(1) + 1;
            }
            finally {
                resultSet.close();
            }
            int n2 = 0;
            for (Object object : this.parent.getColList()) {
                serializable = (ExpressionType)this.parent.getColDef().elementAt(n2);
                string = "INSERT INTO xsysviewscolumns (viewcolid, viewid, viewcolseqno, viewcolumn,coltype,collength,colscale,colprecision) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                preparedStatement = metaData.prepareStatement(string);
                preparedStatement.setInt(1, n++);
                preparedStatement.setInt(2, this.viewid);
                preparedStatement.setInt(3, ++n2);
                preparedStatement.setString(4, (String)object);
                preparedStatement.setInt(5, serializable.type);
                preparedStatement.setInt(6, serializable.length);
                preparedStatement.setInt(7, serializable.scale);
                preparedStatement.setInt(8, serializable.precision);
                if (preparedStatement.executeUpdate() == 1) continue;
                XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsysviewscolumns\"");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            for (Object object : this.parent.getDependedSysCol()) {
                string = "INSERT INTO xsysviewdeps ( viewid, columnid, tableid ) VALUES (?, ?, ?)";
                preparedStatement = metaData.prepareStatement(string);
                preparedStatement.setInt(1, this.viewid);
                preparedStatement.setInt(2, ((SysColumn)object).getColID());
                preparedStatement.setInt(3, ((SysColumn)object).getSysTable().getTableId());
                if (preparedStatement.executeUpdate() == 1) continue;
                serializable = new XDBServerException("Failed to insert row into \"xsysviewdeps\"");
                logger.throwing((Throwable)serializable);
                throw serializable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        SysView sysView = new SysView(this.database, this.viewid, this.parent.getViewName(), this.parent.getSelectString());
        this.database.addSysView(sysView);
    }
}

