/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.parser.SqlCreateUser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SyncCreateUser
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncCreateUser.class);
    private SqlCreateUser parent;
    private int userid;

    public SyncCreateUser(SqlCreateUser sqlCreateUser) {
        this.parent = sqlCreateUser;
    }

    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        this.execute(xDBSessionContext.getSysDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SysDatabase sysDatabase) throws Exception {
        MetaData metaData = MetaData.getMetaData();
        ResultSet resultSet = metaData.executeQuery("SELECT max(userid) FROM xsysusers");
        try {
            resultSet.next();
            this.userid = resultSet.getInt(1) + 1;
        }
        finally {
            resultSet.close();
        }
        String string = "INSERT INTO xsysusers (userid, username, userpwd, usertype) VALUES (?, ?, ?, ?)";
        PreparedStatement preparedStatement = metaData.prepareStatement(string);
        preparedStatement.setInt(1, this.userid);
        preparedStatement.setString(2, this.parent.getUserName());
        preparedStatement.setString(3, SysLogin.encryptPassword(this.parent.getPassword()));
        preparedStatement.setString(4, this.parent.getUserClassStr());
        if (preparedStatement.executeUpdate() != 1) {
            XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsysusers\"");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        SysLogin sysLogin = new SysLogin(this.userid, this.parent.getUserName(), SysLogin.encryptPassword(this.parent.getPassword()), this.parent.getUserClassStr());
        MetaData.getMetaData().insertLogin(sysLogin);
    }
}

