/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.MetaUtils;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlCreateIndex;
import com.edb.gridsql.parser.SqlCreateIndexKey;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class SyncCreateIndex
implements IMetaDataUpdate {
    public static final String SYSTEM_CREATED = "XSYSINDEX_SYSTEM_CREATED";
    private SysDatabase database;
    private SqlCreateIndex aSqlCreateIndex;
    private int tableID = 0;
    private Hashtable<String, Integer> colMapHashtable;

    public SyncCreateIndex(SqlCreateIndex sqlCreateIndex, SysDatabase sysDatabase) {
        this.aSqlCreateIndex = sqlCreateIndex;
        SysTable sysTable = sysDatabase.getSysTable(sqlCreateIndex.getIndexTableName());
        if (sysTable == null) {
            throw new XDBServerException("The table specified does not exist in the database");
        }
        this.tableID = sysTable.getTableId();
        this.colMapHashtable = new Hashtable();
        for (SysColumn sysColumn : sysTable.getColumns()) {
            this.colMapHashtable.put(sysColumn.getColName().toUpperCase(), new Integer(sysColumn.getColID()));
        }
    }

    public SyncCreateIndex(SqlCreateIndex sqlCreateIndex, int n, Hashtable hashtable, XDBSessionContext xDBSessionContext) {
        this.aSqlCreateIndex = sqlCreateIndex;
        this.tableID = n;
        this.colMapHashtable = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            Integer n2 = new Integer(string2);
            this.colMapHashtable.put(string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        int n;
        this.database = xDBSessionContext.getSysDatabase();
        List<SqlCreateIndexKey> list = this.aSqlCreateIndex.getIndexKeyDefinitions();
        SqlCreateIndexKey[] sqlCreateIndexKeyArray = list.toArray(new SqlCreateIndexKey[list.size()]);
        for (n = 0; n < sqlCreateIndexKeyArray.length; ++n) {
            sqlCreateIndexKeyArray[n].setKeyColumnId(this.colMapHashtable.get(sqlCreateIndexKeyArray[n].getKeyColumnName().toUpperCase()));
        }
        n = MetaUtils.createIndex(-1, this.aSqlCreateIndex.getIndexName(), this.tableID, false, sqlCreateIndexKeyArray, this.aSqlCreateIndex.getTablespace() == null ? -1 : this.aSqlCreateIndex.getTablespace().getTablespaceID(), this.aSqlCreateIndex.getUsingType(), this.aSqlCreateIndex.getWherePred());
        if (this.aSqlCreateIndex.isUnique()) {
            int n2;
            String string = "SELECT max(constid) FROM xsysconstraints";
            ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
            try {
                resultSet.next();
                n2 = resultSet.getInt(1) + 1;
            }
            finally {
                resultSet.close();
            }
            String string2 = "INSERT INTO xsysconstraints (constid, tableid, consttype, Idxid, issoft) VALUES (" + n2 + "," + this.tableID + "," + "'U'" + "," + n + "," + "0)";
            MetaData.getMetaData().executeUpdate(string2);
        }
    }

    public void refresh() throws Exception {
        this.database.getSysTable(this.aSqlCreateIndex.getIndexTableName()).readTableInfo();
    }
}

