/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private int nodeid;
    private String jdbcDriver = "";
    private String jdbcUrl = "";
    private String host = "";
    private int port = 0;
    private String jdbcUser = "";
    private String jdbcPassword = "";
    private boolean up = false;
    private Map<String, DBNode> dbNodeList = new HashMap<String, DBNode>();

    Node(int n, String string, String string2, String string3, int n2, String string4, String string5) {
        this.nodeid = n;
        this.jdbcDriver = string;
        this.jdbcUrl = string2;
        this.jdbcUser = string4;
        this.jdbcPassword = string5;
        this.host = string3;
        this.port = n2;
    }

    public String getJdbcString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dbhost", this.host);
        hashMap.put("dbport", "" + this.port);
        hashMap.put("database", this.getNodeDatabaseString(string));
        return ParseCmdLine.substitute(this.jdbcUrl, hashMap);
    }

    public String getNodeDatabaseString(String string) {
        return string + "N" + this.nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUp() {
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            return this.up;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBNode> setUp() {
        Object object;
        LinkedList<DBNode> linkedList = new LinkedList<DBNode>();
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            this.up = true;
            for (DBNode dBNode : this.getDBNodeList()) {
                if (!dBNode.getDatabase().isStarted()) continue;
                dBNode.setOffline();
                linkedList.add(dBNode);
            }
            object.notifyAll();
        }
        return linkedList;
    }

    synchronized void addDbNode(DBNode dBNode) {
        this.dbNodeList.put(dBNode.getDatabase().getDbname(), dBNode);
    }

    public synchronized Collection getDBNodeList() {
        return this.dbNodeList.values();
    }

    public synchronized DBNode getDBNode(String string) {
        return this.dbNodeList.get(string);
    }

    synchronized void removeDBNode(String string) {
        this.dbNodeList.remove(string);
    }

    public int getNodeid() {
        return this.nodeid;
    }

    public String getSJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getSHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDown() {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            this.up = false;
            for (DBNode dBNode : this.getDBNodeList()) {
                dBNode.setOffline();
                object.notifyAll();
            }
        }
    }

    public String toString() {
        return "Nd:" + this.nodeid;
    }

    public NodeDBConnectionInfo getNodeDBConnectionInfo(String string) {
        DBNode dBNode = this.getDBNode(string);
        if (dBNode != null) {
            return dBNode.getNodeDBConnectionInfo();
        }
        Properties properties = new Properties();
        String string2 = "xdb.default.custom.";
        String string3 = "xdb.node." + this.nodeid + ".custom.";
        Enumeration<?> enumeration = Property.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5;
            String string6 = (String)enumeration.nextElement();
            if (string6.startsWith(string3)) {
                string5 = string6.substring(string3.length());
                string4 = Property.get(string6);
                properties.setProperty(string5, string4);
                continue;
            }
            if (!string6.startsWith(string2)) continue;
            string5 = string6.substring(string3.length());
            string4 = Property.get(string6);
            if (properties.containsKey(string5)) continue;
            properties.setProperty(string5, string4);
        }
        return new NodeDBConnectionInfo(this.nodeid, this.host, this.port, this.getNodeDatabaseString(string), this.jdbcUser, this.jdbcPassword, properties);
    }
}

