/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.SysUser;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    private static final XLogger logger = XLogger.getLogger(MetaData.class);
    public static final int INDEX_TYPE_PRIMARY_KEY = 1;
    public static final int INDEX_TYPE_UNIQUE = 2;
    public static final int INDEX_TYPE_SINGLE = 3;
    public static final int INDEX_TYPE_FIRST_IN_COMPOSITE = 4;
    public static final int INDEX_TYPE_NOT_FIRST_IN_COMPOSITE = 5;
    public static final int INDEX_TYPE_NONE = 6;
    private static final int MAXRETRIES = 10;
    private HashMap<String, SysDatabase> sysDatabaseList = new HashMap();
    private Hashtable<Integer, Node> nodeList = new Hashtable();
    private Hashtable<String, SysTablespace> tablespaces = new Hashtable();
    private Hashtable<String, SysLogin> sysLoginList = new Hashtable();
    private String metadataJdbcDriver;
    private String metadataJdbc;
    private String metadataHost;
    private int metadataPort;
    private String metadataDatabase;
    private String metadataJdbcUser;
    private String metadataJdbcPassword;
    private Connection oConn;
    private Object connectionMutex = new Object();
    private Thread transactionThread = null;
    private static MetaData metaData = null;
    private Object startupLock = new Object();
    private static NodeDBConnectionInfo connectionInfo;

    private MetaData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaData getMetaData() throws XDBServerException {
        Class<MetaData> clazz = MetaData.class;
        synchronized (MetaData.class) {
            MetaData metaData;
            if (MetaData.metaData == null) {
                metaData = new MetaData();
                metaData.loadMetaData();
                MetaData.metaData = metaData;
            }
            metaData = MetaData.metaData;
            // ** MonitorExit[var0] (shouldn't be in output)
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Node> getNodes() {
        Collection<Node> collection = this.nodeList.values();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<SysDatabase> getSysDatabases() {
        ArrayList<SysDatabase> arrayList = new ArrayList<SysDatabase>(this.sysDatabaseList.values());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node getNode(int n) throws XDBServerException {
        Node node = this.nodeList.get(n);
        if (node == null) {
            XDBServerException xDBServerException = new XDBServerException("Node " + n + " has not been registered. Please, check your config file.");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        Node node2 = node;
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SysDatabase getSysDatabase(String string) throws XDBServerException {
        SysDatabase sysDatabase = this.sysDatabaseList.get(string);
        if (sysDatabase == null) {
            XDBServerException xDBServerException = new XDBServerException("Database " + string + " has not been registered");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        SysDatabase sysDatabase2 = sysDatabase;
        return sysDatabase2;
    }

    public Collection<SysTablespace> getTablespaces() {
        return this.tablespaces.values();
    }

    public boolean hasTablespace(String string) {
        return string != null && this.tablespaces.containsKey(string);
    }

    public SysTablespace getTablespace(String string) {
        SysTablespace sysTablespace = null;
        if (string != null) {
            sysTablespace = this.tablespaces.get(string);
        }
        if (sysTablespace == null) {
            throw new XDBServerException("Tablespace " + string + " is not found");
        }
        return sysTablespace;
    }

    void addTablespace(SysTablespace sysTablespace) {
        String string = sysTablespace.getTablespaceName();
        if (this.tablespaces.containsKey(string)) {
            throw new XDBServerException("Tablespace " + string + " already exists");
        }
        this.tablespaces.put(string, sysTablespace);
    }

    void removeTablespace(SysTablespace sysTablespace) {
        String string = sysTablespace.getTablespaceName();
        this.tablespaces.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetaData() throws XDBServerException {
        this.initConfigValues();
        this.initConnection();
        this.readMetaDataInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigValues() throws XDBServerException {
        this.metadataJdbcDriver = Property.get("xdb.metadata.jdbcdriver", Props.XDB_DEFAULT_JDBCDRIVER);
        this.metadataHost = Property.get("xdb.metadata.dbhost", "localhost");
        this.metadataPort = Property.getInt("xdb.metadata.dbport", Props.XDB_DEFAULT_DBPORT);
        this.metadataDatabase = Property.get("xdb.metadata.database");
        if (this.metadataDatabase == null) {
            throw new XDBServerException("Metadata database is not specified");
        }
        this.metadataJdbcUser = Property.get("xdb.metadata.dbusername", Props.XDB_DEFAULT_DBUSER);
        if (this.metadataJdbcUser == null) {
            throw new XDBServerException("User name for metadata database is not specified");
        }
        this.metadataJdbcPassword = Property.get("xdb.metadata.dbpassword", Props.XDB_DEFAULT_DBPASSWORD);
        if (this.metadataJdbcPassword == null) {
            throw new XDBServerException("Password for metadata database is not specified");
        }
        this.metadataJdbc = Property.get("xdb.metadata.jdbcstring", Props.XDB_DEFAULT_JDBCSTRING);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dbhost", this.metadataHost);
        hashMap.put("dbport", "" + this.metadataPort);
        hashMap.put("database", this.metadataDatabase);
        hashMap.put("dbusername", this.metadataJdbcUser);
        hashMap.put("dbpassword", this.metadataJdbcPassword);
        this.metadataJdbc = ParseCmdLine.substitute(this.metadataJdbc, hashMap);
        for (int i = 1; i <= Props.XDB_NODECOUNT; ++i) {
            String string = "xdb.node." + i + ".";
            String string2 = Property.get(string + "jdbcdriver", Props.XDB_DEFAULT_JDBCDRIVER);
            String string3 = Property.get(string + "jdbcstring", Props.XDB_DEFAULT_JDBCSTRING);
            String string4 = Property.get(string + "host", "localhost");
            String string5 = Property.get(string + "dbhost", string4);
            int n = Property.getInt(string + "dbport", Props.XDB_DEFAULT_DBPORT);
            String string6 = Property.get(string + "dbusername", Props.XDB_DEFAULT_DBUSER);
            String string7 = Property.get(string + "dbpassword", Props.XDB_DEFAULT_DBPASSWORD);
            this.nodeList.put(i, new Node(i, string2.trim(), string3.trim(), string5.trim(), n, string6, string7));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDriver(String string) throws XDBServerException {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = ErrorMessageRepository.CLASS_PATH_ERROR + " (" + string + " )";
            XDBServerException xDBServerException = new XDBServerException(string2, classNotFoundException, ErrorMessageRepository.CLASS_PATH_ERROR_CODE);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() throws XDBServerException {
        this.checkDriver(this.metadataJdbcDriver);
        try {
            this.oConn = DriverManager.getConnection(this.metadataJdbc, this.metadataJdbcUser, this.metadataJdbcPassword);
            this.oConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            String string = ErrorMessageRepository.CANNOT_INITIALIZE_NODE_CONNECTION + " ( " + this.metadataJdbc + " Password :" + this.metadataJdbcPassword + "  User :" + this.metadataJdbcUser + " )";
            XDBServerException xDBServerException = new XDBServerException(string, sQLException, ErrorMessageRepository.CANNOT_INITIALIZE_NODE_CONNECTION_CODE);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetaDataInfo() throws XDBServerException {
        Object object;
        Object object2;
        String string;
        ResultSet resultSet;
        try {
            resultSet = this.executeQuery("SELECT * from xsysusers");
            while (resultSet.next()) {
                int n = resultSet.getInt("userid");
                string = resultSet.getString("username").trim();
                object2 = resultSet.getString("userpwd").trim();
                String string2 = resultSet.getString("usertype").trim();
                object = new SysLogin(n, string, (String)object2, string2);
                this.sysLoginList.put(string, (SysLogin)object);
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            String string3 = ErrorMessageRepository.SQL_EXEC_FAILURE + "( " + " SELECT dbname from xsysdatabases " + " , " + this.metadataJdbc + " )";
            XDBServerException xDBServerException = new XDBServerException(string3, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.sysDatabaseList.put(Props.XDB_ADMIN_DATABASE, SysDatabase.getAdminDatabase());
        try {
            resultSet = this.executeQuery("SELECT * from xsysdatabases");
            while (resultSet.next()) {
                SysDatabase sysDatabase = new SysDatabase(resultSet.getInt("dbid"), resultSet.getString("dbname"));
                this.sysDatabaseList.put(sysDatabase.getDbname().trim(), sysDatabase);
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            string = ErrorMessageRepository.SQL_EXEC_FAILURE + "( " + " SELECT dbname from xsysdatabases " + " , " + this.metadataJdbc + " )";
            object2 = new XDBServerException(string, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            logger.throwing((Throwable)object2);
            throw object2;
        }
        this.beginTransaction();
        try {
            PreparedStatement preparedStatement = null;
            resultSet = this.executeQuery("SELECT * from xsystablespaces");
            while (resultSet.next()) {
                int n = resultSet.getInt("tablespaceid");
                object2 = resultSet.getString("tablespacename");
                int n2 = resultSet.getInt("tablespaceid");
                object = new HashMap();
                if (preparedStatement == null) {
                    preparedStatement = this.prepareStatement("select nodeid, filepath from xsystablespacelocs where tablespaceid = ?");
                }
                preparedStatement.setInt(1, n);
                ResultSet resultSet2 = preparedStatement.executeQuery();
                while (resultSet2.next()) {
                    object.put(new Integer(resultSet2.getInt(1)), resultSet2.getString(2));
                }
                resultSet2.close();
                SysTablespace sysTablespace = new SysTablespace(n, (String)object2, n2, (Map<Integer, String>)object);
                this.tablespaces.put((String)object2, sysTablespace);
            }
            this.commitTransaction(null);
        }
        catch (SQLException sQLException) {
            this.rollbackTransaction();
            logger.catching(sQLException);
            string = "Can not load tablespaces";
            object2 = new XDBServerException(string, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            logger.throwing((Throwable)object2);
            throw object2;
        }
    }

    public synchronized void insertLogin(SysLogin sysLogin) {
        this.sysLoginList.put(sysLogin.getName(), sysLogin);
        for (SysDatabase sysDatabase : this.sysDatabaseList.values()) {
            sysDatabase.insertUser(new SysUser(sysLogin.getLoginID(), sysLogin, sysDatabase));
        }
    }

    public synchronized SysLogin getSysLogin(String string) {
        SysLogin sysLogin = this.sysLoginList.get(string);
        if (sysLogin == null) {
            XDBServerException xDBServerException = new XDBServerException("User " + string + " has not been registered");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        return sysLogin;
    }

    public synchronized Collection<SysLogin> getSysLogins() {
        return new ArrayList<SysLogin>(this.sysLoginList.values());
    }

    public synchronized void removeLogin(SysLogin sysLogin) {
        this.sysLoginList.remove(sysLogin.getName());
        for (SysDatabase sysDatabase : this.sysDatabaseList.values()) {
            sysDatabase.removeUser(sysLogin.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SysDatabase createDatabase(String string, SysLogin sysLogin) throws XDBServerException {
        if (this.sysDatabaseList.containsKey(string)) {
            String string2 = ErrorMessageRepository.DUP_DATABASE_ERROR + " " + string;
            throw new XDBServerException(string2, 2, ErrorMessageRepository.DUP_DATABASE_ERROR_CODE);
        }
        SysDatabase sysDatabase = new SysDatabase(-1, string);
        for (SysLogin sysLogin2 : this.sysLoginList.values()) {
            SysUser sysUser = new SysUser(sysLogin2.getLoginID(), sysLogin2, sysDatabase);
            sysDatabase.insertUser(sysUser);
        }
        this.sysDatabaseList.put(string, null);
        SysDatabase sysDatabase2 = sysDatabase;
        return sysDatabase2;
    }

    public synchronized void dropTempDatabase(String string) {
        if (this.sysDatabaseList.containsKey(string) && this.sysDatabaseList.get(string) == null) {
            this.sysDatabaseList.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeDbPersistent(SysDatabase sysDatabase) throws XDBServerException {
        if (sysDatabase.getDbid() != -1) {
            String string = ErrorMessageRepository.DUP_DATABASE_ERROR + " " + sysDatabase.getDbname();
            throw new XDBServerException(string, 2, ErrorMessageRepository.DUP_DATABASE_ERROR_CODE);
        }
        if (sysDatabase.getDBNodeList().isEmpty()) {
            throw new XDBServerException("No nodes are defined in database " + sysDatabase.getDbname());
        }
        String string = null;
        this.beginTransaction();
        try {
            string = "SELECT max(dbid) FROM xsysdatabases";
            ResultSet resultSet = this.executeQuery(string);
            try {
                resultSet.next();
                sysDatabase.setDbid(resultSet.getInt(1) + 1);
            }
            finally {
                resultSet.close();
            }
            string = "INSERT INTO xsysdatabases (dbid, dbname) VALUES (" + sysDatabase.getDbid() + "," + "'" + sysDatabase.getDbname() + "')";
            if (this.executeUpdate(string) == 0) {
                XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsysdatabases\"");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            this.makeDBNodesPersistent(sysDatabase.getDBNodeList());
            this.commitTransaction(null);
        }
        catch (Exception exception) {
            logger.catching(exception);
            this.rollbackTransaction();
            String string2 = ErrorMessageRepository.SQL_EXEC_FAILURE + "(" + string + "," + this.metadataJdbc + ")";
            XDBServerException xDBServerException = new XDBServerException(string2, exception, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.sysDatabaseList.put(sysDatabase.getDbname(), sysDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeDBNodesPersistent(Collection<DBNode> collection) throws SQLException {
        int n;
        String string = null;
        ResultSet resultSet = this.executeQuery("SELECT max(dbnodeid) FROM xsysdbnodes");
        try {
            resultSet.next();
            n = resultSet.getInt(1) + 1;
        }
        finally {
            resultSet.close();
        }
        for (DBNode dBNode : collection) {
            string = "INSERT INTO xsysdbnodes (dbnodeid, dbid, nodeid) VALUES (" + n++ + ", " + dBNode.getDatabase().getDbid() + ", " + dBNode.getNodeId() + ")";
            this.executeUpdate(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropDatabase(String string) throws SQLException {
        String string2 = "";
        Object object = this.getStartupLock();
        synchronized (object) {
            SysDatabase sysDatabase = this.getSysDatabase(string);
            if (sysDatabase.isStarted()) {
                throw new SQLException("Database is running, please stop it first");
            }
            SysDatabase sysDatabase2 = sysDatabase;
            synchronized (sysDatabase2) {
                this.beginTransaction();
                try {
                    string2 = "DELETE FROM xsyschecks WHERE constid IN (SELECT constid FROM xsysconstraints WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + "))";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysviewdeps WHERE viewid IN (SELECT viewid FROM xsysviews WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysviewscolumns WHERE viewid IN (SELECT viewid FROM xsysviews WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysviews WHERE dbid = " + sysDatabase.getDbid();
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsystabprivs WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysforeignkeys WHERE refid IN (SELECT refid FROM xsysreferences WHERE constid IN (SELECT constid FROM xsysconstraints WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")))";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysreferences WHERE constid IN (SELECT constid FROM xsysconstraints WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + "))";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysconstraints WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysindexkeys WHERE idxid IN (SELECT idxid FROM xsysindexes WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + "))";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysindexes WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsyscolumns WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsystabparthash WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsystabparts WHERE tableid IN (SELECT tableid FROM xsystables WHERE dbid = " + sysDatabase.getDbid() + ")";
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsystables WHERE dbid = " + sysDatabase.getDbid();
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysdbnodes WHERE dbid = " + sysDatabase.getDbid();
                    this.executeUpdate(string2);
                    string2 = "DELETE FROM xsysdatabases WHERE dbid = " + sysDatabase.getDbid();
                    this.executeUpdate(string2);
                    this.commitTransaction(null);
                }
                catch (Exception exception) {
                    logger.catching(exception);
                    this.rollbackTransaction();
                    String string3 = ErrorMessageRepository.SQL_EXEC_FAILURE + "(" + string2 + "," + this.metadataJdbc + ")";
                    XDBServerException xDBServerException = new XDBServerException(string3, exception, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
                Iterator<Node> iterator = this.getNodes().iterator();
                while (iterator.hasNext()) {
                    iterator.next().removeDBNode(string);
                }
            }
            this.sysDatabaseList.remove(string);
            this.getStartupLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() throws XDBServerException {
        Object object = this.connectionMutex;
        synchronized (object) {
            int n;
            if (this.transactionThread == Thread.currentThread()) {
                return;
            }
            for (n = 0; this.transactionThread != null && n < 10; ++n) {
                try {
                    this.connectionMutex.wait(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (n > 10) {
                XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.METADATA_LOCKED, 0, ErrorMessageRepository.METADATA_LOCKED_CODE);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            this.transactionThread = Thread.currentThread();
        }
        try {
            if (this.oConn == null || this.oConn.isClosed()) {
                this.initConnection();
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            this.oConn = null;
            XDBServerException xDBServerException = new XDBServerException("Failed to check is connection closed", sQLException);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(IMetaDataUpdate iMetaDataUpdate) throws XDBServerException {
        try {
            Object object = this.connectionMutex;
            synchronized (object) {
                if (this.transactionThread != Thread.currentThread()) {
                    XDBServerException xDBServerException = new XDBServerException("Illegal attempt to commit transaction. Current thread: " + Thread.currentThread() + ", transaction was started by thread: " + this.transactionThread);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
                this.oConn.commit();
                if (iMetaDataUpdate != null) {
                    iMetaDataUpdate.refresh();
                }
                this.transactionThread = null;
                this.connectionMutex.notifyAll();
            }
        }
        catch (Exception exception) {
            logger.catching(exception);
            XDBServerException xDBServerException = new XDBServerException("Failed to commit transaction", exception);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws XDBServerException {
        Object object = this.connectionMutex;
        synchronized (object) {
            if (this.transactionThread != Thread.currentThread()) {
                XDBServerException xDBServerException = new XDBServerException("Illegal attempt to rollback transaction. Current thread: " + Thread.currentThread() + ", transaction was started by thread: " + this.transactionThread);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            try {
                this.oConn.rollback();
            }
            catch (Exception exception) {
                logger.catching(exception);
                XDBServerException xDBServerException = new XDBServerException("Failed to rollback transaction", exception);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            finally {
                this.transactionThread = null;
                this.connectionMutex.notifyAll();
            }
        }
    }

    public ResultSet executeQuery(String string) throws XDBServerException {
        ResultSet resultSet = null;
        Object object = this.connectionMutex;
        synchronized (object) {
            try {
                Statement statement = this.oConn.createStatement();
                ResultSet resultSet2 = resultSet = statement.executeQuery(string);
                return resultSet2;
            }
            catch (SQLException sQLException) {
                XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.SQL_STATEMENT_CREATE_FAILURE, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
    }

    public int executeUpdate(String string) {
        Object object = this.connectionMutex;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = this.transactionThread == null;
            if (bl) {
                this.beginTransaction();
            }
            try {
                Statement statement = this.oConn.createStatement();
                int n = statement.executeUpdate(string);
                if (bl) {
                    this.commitTransaction(null);
                }
                int n2 = n;
                return n2;
            }
            catch (SQLException sQLException) {
                logger.catching(sQLException);
                if (bl) {
                    this.rollbackTransaction();
                }
                XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
    }

    Object getStartupLock() {
        return this.startupLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedStatement prepareStatement(String string) throws XDBServerException {
        Object object = this.connectionMutex;
        synchronized (object) {
            if (Thread.currentThread() != this.transactionThread) {
                return null;
            }
            try {
                return this.oConn.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                logger.catching(sQLException);
                XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
    }

    public static final NodeDBConnectionInfo getMetadataDBConnectionInfo() {
        if (connectionInfo == null) {
            MetaData metaData;
            if (MetaData.metaData == null) {
                metaData = new MetaData();
                metaData.initConfigValues();
            } else {
                metaData = MetaData.metaData;
            }
            Properties properties = new Properties();
            String string = "xdb.default.custom.";
            String string2 = "xdb.node.metadata.custom.";
            Enumeration<?> enumeration = Property.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4;
                String string5 = (String)enumeration.nextElement();
                if (string5.startsWith(string2)) {
                    string4 = string5.substring(string2.length());
                    string3 = Property.get(string5);
                    properties.setProperty(string4, string3);
                    continue;
                }
                if (!string5.startsWith(string)) continue;
                string4 = string5.substring(string2.length());
                string3 = Property.get(string5);
                if (properties.containsKey(string4)) continue;
                properties.setProperty(string4, string3);
            }
            return new NodeDBConnectionInfo(0, metaData.metadataHost, metaData.metadataPort, metaData.metadataDatabase, metaData.metadataJdbcUser, metaData.metadataJdbcPassword, properties);
        }
        return connectionInfo;
    }

    public NodeDBConnectionInfo[] getNodeDBConnectionInfos(Collection<String> collection) {
        ArrayList<NodeDBConnectionInfo> arrayList = new ArrayList<NodeDBConnectionInfo>();
        for (String string : collection) {
            SysDatabase sysDatabase = metaData.getSysDatabase(string);
            sysDatabase.admin();
            for (DBNode dBNode : sysDatabase.getDBNodeList()) {
                arrayList.add(dBNode.getNodeDBConnectionInfo());
            }
        }
        return arrayList.toArray(new NodeDBConnectionInfo[arrayList.size()]);
    }
}

