/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.exception.XDBDataReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamReaderThread
implements Callable<Boolean> {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private DataReaderAndProcessorBuffer<byte[]> loadBuffer;
    private InputStream dataSourceFile;
    private int lineDelimiterStyle = 0;
    private byte[] readBuffer = new byte[1024];
    private int readPos = 0;
    private int readEnd = 0;
    private boolean eof = false;
    private boolean skipLF = false;
    private byte[] buffer = new byte[128];
    private int bufferIdx;
    private boolean preserveLineEnd;

    public StreamReaderThread(InputStream inputStream, DataReaderAndProcessorBuffer<byte[]> dataReaderAndProcessorBuffer, boolean bl) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (dataReaderAndProcessorBuffer == null) {
            throw new NullPointerException("buffer");
        }
        this.dataSourceFile = inputStream;
        this.loadBuffer = dataReaderAndProcessorBuffer;
        this.preserveLineEnd = bl;
    }

    public void close() {
        try {
            this.dataSourceFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean readLineFromStream() throws XDBDataReaderException {
        try {
            boolean bl = false;
            while (!bl) {
                if (this.readPos == this.readEnd) {
                    this.fill();
                }
                int n = this.readPos;
                block7: while (!bl && this.readPos < this.readEnd) {
                    switch (this.readBuffer[this.readPos++]) {
                        case 10: {
                            if (this.skipLF) {
                                n = this.readPos;
                                this.setLineDelimiterStyle(3);
                                this.skipLF = false;
                                continue block7;
                            }
                            this.ensureBufferCapacity(this.bufferIdx + this.readPos - n);
                            System.arraycopy(this.readBuffer, n, this.buffer, this.bufferIdx, this.readPos - n);
                            this.bufferIdx += this.readPos - n - 1;
                            this.setLineDelimiterStyle(2);
                            return true;
                        }
                        case 13: {
                            this.skipLF = true;
                            bl = true;
                            continue block7;
                        }
                    }
                    if (this.skipLF) {
                        this.setLineDelimiterStyle(1);
                    }
                    this.skipLF = false;
                }
                this.ensureBufferCapacity(this.bufferIdx + this.readPos - n);
                System.arraycopy(this.readBuffer, n, this.buffer, this.bufferIdx, this.readPos - n);
                this.bufferIdx += this.readPos - n - (bl ? 1 : 0);
                if (!this.eof) continue;
                break;
            }
            return !this.eof || this.readPos < this.readEnd;
        }
        catch (IOException iOException) {
            throw new XDBDataReaderException(iOException);
        }
    }

    private void fill() throws IOException {
        this.readPos = 0;
        this.readEnd = this.dataSourceFile.read(this.readBuffer);
        this.eof = this.readEnd < 0;
    }

    private void ensureBufferCapacity(int n) {
        if (this.buffer.length < n) {
            byte[] byArray = new byte[Math.max(2 * this.buffer.length, n)];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    private void setLineDelimiterStyle(int n) throws XDBDataReaderException {
        if (this.preserveLineEnd) {
            byte[] byArray = new byte[this.bufferIdx + (n == 3 ? 2 : 1)];
            System.arraycopy(this.buffer, 0, byArray, 0, this.bufferIdx);
            if ((n & 1) == 1) {
                byArray[this.bufferIdx++] = 13;
            }
            if ((n & 2) == 2) {
                byArray[this.bufferIdx++] = 10;
            }
            this.loadBuffer.putRowValue(byArray);
            this.bufferIdx = 0;
        } else if (n != this.lineDelimiterStyle) {
            if (this.lineDelimiterStyle == 0) {
                this.lineDelimiterStyle = n;
            } else {
                throw new XDBDataReaderException("The data file has mixed line ends");
            }
        }
    }

    public boolean mixedLineEndsFound() {
        return this.lineDelimiterStyle == 4;
    }

    @Override
    public Boolean call() throws XDBDataReaderException {
        try {
            Object object;
            while (this.readLineFromStream()) {
                if (this.preserveLineEnd) continue;
                object = new byte[this.bufferIdx];
                System.arraycopy(this.buffer, 0, object, 0, this.bufferIdx);
                this.loadBuffer.putRowValue((byte[])object);
                this.bufferIdx = 0;
            }
            if (this.bufferIdx > 0) {
                object = new byte[this.bufferIdx];
                System.arraycopy(this.buffer, 0, object, 0, this.bufferIdx);
                this.loadBuffer.putRowValue((byte[])object);
                this.bufferIdx = 0;
            }
            object = true;
            return object;
        }
        catch (XDBDataReaderException xDBDataReaderException) {
            throw xDBDataReaderException;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
        finally {
            this.close();
            if (this.loadBuffer != null) {
                this.loadBuffer.markFinished();
            }
        }
    }
}

