/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.exception.XDBDataReaderException;
import java.sql.ResultSet;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetReaderThread
implements Callable<Boolean> {
    private DataReaderAndProcessorBuffer<String[]> loadBuffer;
    private int columns;
    private ResultSet dataSourceRS;

    public ResultSetReaderThread(ResultSet resultSet, DataReaderAndProcessorBuffer<String[]> dataReaderAndProcessorBuffer) throws XDBDataReaderException {
        try {
            this.dataSourceRS = resultSet;
            this.columns = this.dataSourceRS.getMetaData().getColumnCount();
            this.loadBuffer = dataReaderAndProcessorBuffer;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
    }

    public void close() {
        try {
            if (this.dataSourceRS != null) {
                this.dataSourceRS.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] readLineFromResultSet() throws XDBDataReaderException {
        try {
            if (!this.dataSourceRS.next()) {
                return null;
            }
            String[] stringArray = new String[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                stringArray[i] = this.dataSourceRS.getString(i + 1);
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
    }

    @Override
    public Boolean call() throws XDBDataReaderException {
        try {
            String[] stringArray;
            while ((stringArray = this.readLineFromResultSet()) != null) {
                this.loadBuffer.putRowValue(stringArray);
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
        finally {
            this.close();
            if (this.loadBuffer != null) {
                this.loadBuffer.markFinished();
            }
        }
    }
}

