/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.PGConnection;
import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XDBPipedInputStream;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDBWriter
implements INodeWriter {
    private static final XLogger logger = XLogger.getLogger(EDBWriter.class);
    private String writerID;
    private NodeDBConnectionInfo connectionInfo;
    private volatile boolean success = true;
    private String header;
    private String footer;
    private final Map<String, String> m;
    private int totalRows = 0;
    private String copyQuery;
    private ExecutorService executorService = null;
    private Future<Boolean> copyThreadHandle = null;
    private Connection conn = null;
    private PGConnection pconn = null;
    private PipedOutputStream pos = null;
    private XDBPipedInputStream pis = null;
    private byte[] ROW_VALUES_DELIMITER = Props.XDB_LOADER_NODEWRITER_ROW_DELIMITER.getBytes();
    private int rowCount = 0;

    public EDBWriter(NodeDBConnectionInfo nodeDBConnectionInfo, String string, Map<String, String> map) {
        this.connectionInfo = nodeDBConnectionInfo;
        this.writerID = nodeDBConnectionInfo.getDbName() + "@" + nodeDBConnectionInfo.getDbHost();
        map.put("dbhost", nodeDBConnectionInfo.getDbHost());
        if (nodeDBConnectionInfo.getDbPort() > 0) {
            map.put("dbport", "" + nodeDBConnectionInfo.getDbPort());
        }
        map.put("database", nodeDBConnectionInfo.getDbName());
        map.put("dbusername", nodeDBConnectionInfo.getDbUser());
        map.put("dbpassword", nodeDBConnectionInfo.getDbPassword());
        this.copyQuery = ParseCmdLine.substitute(string, map);
        this.header = map.get("outHeader");
        this.footer = map.get("outFooter");
        this.m = map;
    }

    @Override
    public void start() throws IOException {
        try {
            String string = "xdb.node." + this.connectionInfo.getNodeID() + ".";
            String string2 = Property.get(string + "jdbcstring", Props.XDB_DEFAULT_JDBCSTRING);
            Class.forName(Property.get(string + "jdbcdriver", Props.XDB_DEFAULT_JDBCDRIVER));
            this.conn = DriverManager.getConnection(ParseCmdLine.substitute(string2, this.m), this.m.get("dbusername"), this.m.get("dbpassword"));
            this.pconn = (PGConnection)this.conn;
            this.runEDBCopyThread();
        }
        catch (Exception exception) {
            this.success = false;
            throw new IOException("Can not start Writer " + this.writerID + ":" + exception.getMessage());
        }
    }

    private synchronized void runEDBCopyThread() throws IOException {
        this.pis = new XDBPipedInputStream(Props.XDB_LOADER_BUFFER_SIZE);
        this.pos = new PipedOutputStream(this.pis);
        this.executorService = Executors.newSingleThreadExecutor();
        this.copyThreadHandle = this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                Statement statement = EDBWriter.this.conn.createStatement();
                statement.executeUpdate("BEGIN");
                EDBWriter.this.pconn.getCopyAPI().copyInQuery(EDBWriter.this.copyQuery, (InputStream)EDBWriter.this.pis);
                return true;
            }
        });
        if (this.header != null) {
            this.pos.write(this.header.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopEDBCopyThread(boolean bl) throws IOException {
        if (this.executorService == null) {
            return;
        }
        try {
            if (bl) {
                if (this.footer != null) {
                    this.pos.write(this.footer.getBytes());
                }
                this.pos.flush();
            }
            try {
                this.pos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.executorService.shutdown();
            boolean bl2 = false;
            try {
                bl2 = this.executorService.awaitTermination(Props.XDB_STEP_ENDWAITTIME, TimeUnit.MILLISECONDS);
                if (bl2) {
                    bl2 = this.copyThreadHandle.get();
                }
            }
            catch (ExecutionException executionException) {
                throw new IOException(this.writerID + ": loader failed to load data: " + executionException.getMessage());
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.pos = null;
                this.pis = null;
            }
            if (!bl2) {
                this.success = false;
                throw new IOException(this.writerID + ": loader was terminated due to network error");
            }
            logger.log(Level.DEBUG, " %0%: writing of %1% rows is finished %2%", new Object[]{this.writerID, this.rowCount, this.success ? "successfully" : "with errors"});
        }
        finally {
            this.totalRows += this.rowCount;
            this.rowCount = 0;
        }
    }

    @Override
    public synchronized void writeRow(byte[] byArray) throws IOException {
        this.writeRow(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void writeRow(byte[] byArray, int n, int n2) throws IOException {
        this.pos.write(byArray, n, n2);
        this.pos.write(this.ROW_VALUES_DELIMITER);
        ++this.rowCount;
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.stopEDBCopyThread(true);
        }
        catch (IOException iOException) {
            throw new SQLException("I/O exception while tried to stop loading");
        }
        Statement statement = this.conn.createStatement();
        statement.executeUpdate("COMMIT");
        if (this.executorService != null) {
            try {
                this.runEDBCopyThread();
            }
            catch (IOException iOException) {
                throw new SQLException("I/O exception while tried to start loading");
            }
        }
        this.success = true;
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.stopEDBCopyThread(false);
        }
        catch (IOException iOException) {
            throw new SQLException("I/O exception while tried to stop loading");
        }
        Statement statement = this.conn.createStatement();
        statement.executeUpdate("ROLLBACK");
        if (this.executorService != null) {
            try {
                this.runEDBCopyThread();
            }
            catch (IOException iOException) {
                throw new SQLException("I/O exception while tried to start loading");
            }
        }
        this.success = true;
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
    }

    @Override
    public synchronized void finish(boolean bl) throws IOException {
        this.stopEDBCopyThread(bl);
        this.executorService = null;
        if (bl && !this.success) {
            throw new IOException(this.writerID + ": loader error occurred");
        }
    }

    @Override
    public String getStatistics() {
        return "";
    }

    @Override
    public long getRowCount() {
        return this.totalRows;
    }
}

