/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderAndProcessorBuffer<T> {
    private static final XLogger logger = XLogger.getLogger(DataReaderAndProcessorBuffer.class);
    private long waitForFullBuffer = 0L;
    private long waitForEmptyBuffer = 0L;
    private T[] rowsBuffer;
    private int in;
    private int out;
    private int bufferLimit;
    private int currentSize;
    private boolean hasFinished;

    public DataReaderAndProcessorBuffer(int n, Loader.DATA_SOURCE dATA_SOURCE) {
        this.initialize(n, dATA_SOURCE);
    }

    public void initialize(int n, Loader.DATA_SOURCE dATA_SOURCE) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.bufferLimit = n;
        this.rowsBuffer = new Object[n];
        this.in = 0;
        this.out = 0;
        this.hasFinished = false;
    }

    public synchronized void markFinished() {
        this.hasFinished = true;
        this.notify();
        if (this.waitForFullBuffer > 0L) {
            logger.debug("Wait for full buffer: " + this.waitForFullBuffer);
        }
        if (this.waitForEmptyBuffer > 0L) {
            logger.debug("Wait for empty buffer: " + this.waitForEmptyBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putRowValue(T t) {
        try {
            while (this.currentSize == this.bufferLimit) {
                try {
                    long l = System.currentTimeMillis();
                    this.wait();
                    this.waitForFullBuffer += System.currentTimeMillis() - l;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.in == this.bufferLimit) {
                this.in = 0;
            }
            ++this.currentSize;
            this.rowsBuffer[this.in++] = t;
        }
        finally {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T getNextRowValue() {
        try {
            while (this.currentSize == 0) {
                if (this.hasFinished) {
                    T t = null;
                    return t;
                }
                try {
                    long l = System.currentTimeMillis();
                    this.wait();
                    this.waitForEmptyBuffer += System.currentTimeMillis() - l;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.out == this.bufferLimit) {
                this.out = 0;
            }
            --this.currentSize;
            T t = this.rowsBuffer[this.out++];
            return t;
        }
        finally {
            this.notify();
        }
    }
}

