/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.engine.loader.ILoaderConfigInformation;
import com.edb.gridsql.engine.loader.TextProcessorThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvProcessorThread
extends TextProcessorThread {
    private byte[] nullValueTemplate;
    private StringBuilder strBuilder = new StringBuilder();

    public CsvProcessorThread(ILoaderConfigInformation iLoaderConfigInformation, int n, DataReaderAndProcessorBuffer<byte[]> dataReaderAndProcessorBuffer) throws Exception {
        super(iLoaderConfigInformation, n, dataReaderAndProcessorBuffer);
        this.nullValueTemplate = this.NULLValue.getBytes();
    }

    @Override
    protected byte[] encodeValue(String string) {
        int n;
        int n2;
        if (string == null) {
            return this.nullValueTemplate;
        }
        boolean bl = string.length() > 0 && string.charAt(0) == this.getQuoteChar() || string.equals(this.nullValueTemplate);
        for (n = 0; n < string.length() && !bl; bl |= (n2 = string.charAt(n)) == this.separator || n2 == 13 || n2 == 10, ++n) {
        }
        if (bl) {
            this.strBuilder.append(this.getQuoteChar());
            n = 0;
            n2 = string.indexOf(this.getQuoteChar(), n);
            while (n2 != -1) {
                this.strBuilder.append(string.substring(n, n2 - 1));
                this.strBuilder.append(this.getQuoteEscape()).append(this.getQuoteChar());
                n = n2 + 1;
                n2 = string.indexOf(this.getQuoteChar(), n);
            }
            this.strBuilder.append(string.substring(n));
            this.strBuilder.append(this.getQuoteChar());
            return this.strBuilder.toString().getBytes();
        }
        return string.getBytes();
    }

    @Override
    protected boolean parseRow() throws Exception {
        this.outputRow = (byte[])this.getNextRowValue();
        if (this.outputRow == null) {
            return false;
        }
        boolean bl = false;
        this.columnEnds = new int[this.getColumnCount()];
        this.colCount = 0;
        int n = 0;
        int n2 = 0;
        while (this.colCount < this.columnEnds.length) {
            if (bl) {
                n2 = this.find(this.outputRow, (byte)this.getQuoteChar(), n);
                if (n2 == -1) {
                    byte[] byArray;
                    byte[] byArray2 = (byte[])this.getNextRowValue();
                    if (byArray2 == null) {
                        throw new Exception("Closing quote not found");
                    }
                    try {
                        byArray = new byte[this.outputRow.length + byArray2.length];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.outputRow = null;
                        throw new Exception("Not enough heap memory, probably doe to malformed input");
                    }
                    System.arraycopy(this.outputRow, 0, byArray, 0, this.outputRow.length);
                    System.arraycopy(byArray2, 0, byArray, this.outputRow.length, byArray2.length);
                    this.outputRow = byArray;
                    continue;
                }
                if (this.getQuoteChar() == this.getQuoteEscape() && n2 < this.outputRow.length - 1 && this.outputRow[n2 + 1] == this.getQuoteChar()) {
                    n = n2 + 2;
                    continue;
                }
                if (this.getQuoteChar() != this.getQuoteEscape() && this.outputRow[n2 - 1] == this.getQuoteEscape()) {
                    n = n2 + 1;
                    continue;
                }
                this.columnEnds[this.colCount++] = ++n2;
                if (n2 == this.outputRow.length || this.outputRow[n2] == 10 || this.outputRow[n2] == 13) {
                    return true;
                }
                if (this.outputRow[n2] == this.separator) {
                    n = n2 + 1;
                    bl = false;
                    continue;
                }
                throw new Exception("Delimiter is expected after closing quote");
            }
            if (n < this.outputRow.length && this.outputRow[n] == this.getQuoteChar()) {
                bl = true;
                ++n;
                continue;
            }
            n2 = this.find(this.outputRow, (byte)this.separator, n);
            if (n2 == -1) {
                for (n2 = this.outputRow.length; n2 > 1 && (this.outputRow[n2 - 1] == 10 || this.outputRow[n2 - 1] == 13); --n2) {
                }
                this.columnEnds[this.colCount++] = n2;
                return true;
            }
            this.columnEnds[this.colCount++] = n2;
            n = n2 + 1;
        }
        throw new Exception("Extra data found afer last field");
    }
}

