/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.io;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.datatypes.BigDecimalType;
import com.edb.gridsql.engine.datatypes.BlobType;
import com.edb.gridsql.engine.datatypes.BooleanType;
import com.edb.gridsql.engine.datatypes.ByteArrayType;
import com.edb.gridsql.engine.datatypes.ByteType;
import com.edb.gridsql.engine.datatypes.ClobType;
import com.edb.gridsql.engine.datatypes.DateType;
import com.edb.gridsql.engine.datatypes.FloatType;
import com.edb.gridsql.engine.datatypes.IntegerType;
import com.edb.gridsql.engine.datatypes.LongType;
import com.edb.gridsql.engine.datatypes.ShortType;
import com.edb.gridsql.engine.datatypes.TimeType;
import com.edb.gridsql.engine.datatypes.TimestampType;
import com.edb.gridsql.engine.datatypes.VarcharType;
import com.edb.gridsql.engine.datatypes.XData;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.engine.io.ResponseMessage;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetResponse
extends ResponseMessage {
    public static final byte LAST_PACKET_TRUE = 1;
    public static final byte LAST_PACKET_FALSE = 0;
    private static XLogger logger = XLogger.getLogger(ResultSetResponse.class);
    private final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int columnCount = 0;
    private ColumnMetaData[] columnMeta = null;
    private List<XData[]> rows = null;
    private short packetSequence = 0;
    private boolean isLastPacket = false;
    private boolean isFirstTime = true;
    private String resultSetId = null;
    private int fetchSize = 200;
    private ResultSet rs = null;
    private int packetSeq = 2;
    private boolean exhaustedData = false;
    private long totalRows = 0L;
    private boolean[] columnIsBinary;

    public ResultSetResponse() {
    }

    public ResultSetResponse(int n, String string, ResultSet resultSet) {
        super((byte)66, n);
        this.setResultSetId(string);
        this.setResultSet(resultSet);
    }

    public ColumnMetaData[] getColumnMetaData() {
        return this.columnMeta;
    }

    public void setColumnMetaData(ColumnMetaData[] columnMetaDataArray) {
        this.columnMeta = columnMetaDataArray;
    }

    public List<XData[]> getRows() {
        return this.rows;
    }

    public boolean isLastPacket() {
        return this.isLastPacket;
    }

    public String getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(String string) {
        this.resultSetId = string;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
        if (resultSet != null) {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.columnMeta = new ColumnMetaData[resultSetMetaData.getColumnCount()];
                for (int i = 0; i < this.columnMeta.length; ++i) {
                    short s = 0;
                    if (resultSetMetaData.isAutoIncrement(i + 1)) {
                        s = (short)(s | 0x20);
                    }
                    if (resultSetMetaData.isCaseSensitive(i + 1)) {
                        s = (short)(s | 0x10);
                    }
                    if (resultSetMetaData.isCurrency(i + 1)) {
                        s = (short)(s | 4);
                    }
                    if (resultSetMetaData.isDefinitelyWritable(i + 1)) {
                        s = (short)(s | 2);
                    }
                    if (resultSetMetaData.isNullable(i + 1) == 1) {
                        s = (short)(s | 1);
                    }
                    if (resultSetMetaData.isReadOnly(i + 1)) {
                        s = (short)(s | 0x40);
                    }
                    if (resultSetMetaData.isSearchable(i + 1)) {
                        s = (short)(s | 0x80);
                    }
                    if (resultSetMetaData.isSigned(i + 1)) {
                        s = (short)(s | 8);
                    }
                    if (resultSetMetaData.isWritable(i + 1)) {
                        s = (short)(s | 2);
                    }
                    this.columnMeta[i] = new ColumnMetaData(resultSetMetaData.getColumnName(i + 1), resultSetMetaData.getColumnLabel(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1), resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1), resultSetMetaData.getTableName(i + 1), s, true);
                }
            }
            catch (SQLException sQLException) {
                logger.catching(sQLException);
            }
        }
    }

    public void setFetchSize(int n) {
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public ResponseMessage nextResults(int n) throws SQLException {
        int n2 = n > 0 ? n : this.fetchSize;
        ++this.packetSeq;
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        ResponseMessage responseMessage = new ResponseMessage(66, 0);
        responseMessage.initSize(Short.MAX_VALUE);
        int n3 = this.columnIsBinary == null ? resultSetMetaData.getColumnCount() : this.columnIsBinary.length;
        if (this.exhaustedData) {
            responseMessage.storeByte((byte)1);
        } else {
            responseMessage.storeByte((byte)0);
        }
        responseMessage.storeString(this.resultSetId);
        responseMessage.storeShort(this.packetSeq);
        responseMessage.storeShort(n3);
        if (this.columnIsBinary == null) {
            this.setMeta(responseMessage, resultSetMetaData);
        }
        int n4 = 0;
        boolean bl = false;
        while (this.rs.next()) {
            ++this.totalRows;
            responseMessage.storeByte((byte)1);
            for (int i = 1; i <= n3; ++i) {
                if (this.columnIsBinary[i - 1]) {
                    responseMessage.storeBytes(this.rs.getBytes(i));
                    continue;
                }
                responseMessage.storeString(this.rs.getString(i));
            }
            if (++n4 < n2) continue;
            bl = true;
            break;
        }
        responseMessage.storeByte((byte)0);
        if (!bl) {
            this.exhaustedData = true;
            responseMessage.getMessage()[0] = 1;
        }
        return responseMessage;
    }

    private void setMeta(ResponseMessage responseMessage, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        short s = 0;
        this.columnIsBinary = new boolean[n];
        for (int i = 1; i <= n; ++i) {
            int n2;
            if (this.resultSetId == null) {
                responseMessage.storeString(null);
                responseMessage.storeString(null);
                responseMessage.storeString(null);
                responseMessage.storeShort(0);
                n2 = resultSetMetaData.getColumnType(i);
                responseMessage.storeShort((short)n2);
                this.columnIsBinary[i - 1] = DataTypes.isBinary(n2);
                responseMessage.storeShort(0);
                responseMessage.storeShort(0);
                responseMessage.storeShort(0);
                continue;
            }
            if (resultSetMetaData.isAutoIncrement(i)) {
                s = (short)(s | 0x20);
            }
            if (resultSetMetaData.isCaseSensitive(i)) {
                s = (short)(s | 0x10);
            }
            if (resultSetMetaData.isCurrency(i)) {
                s = (short)(s | 4);
            }
            if (resultSetMetaData.isDefinitelyWritable(i)) {
                s = (short)(s | 2);
            }
            if (resultSetMetaData.isNullable(i) == 1) {
                s = (short)(s | 1);
            }
            if (resultSetMetaData.isReadOnly(i)) {
                s = (short)(s | 0x40);
            }
            if (resultSetMetaData.isSearchable(i)) {
                s = (short)(s | 0x80);
            }
            if (resultSetMetaData.isSigned(i)) {
                s = (short)(s | 8);
            }
            if (resultSetMetaData.isWritable(i)) {
                s = (short)(s | 2);
            }
            responseMessage.storeString(resultSetMetaData.getTableName(i));
            responseMessage.storeString(resultSetMetaData.getColumnName(i));
            responseMessage.storeString(resultSetMetaData.getColumnLabel(i));
            responseMessage.storeShort((short)resultSetMetaData.getColumnDisplaySize(i));
            n2 = resultSetMetaData.getColumnType(i);
            responseMessage.storeShort((short)n2);
            this.columnIsBinary[i - 1] = DataTypes.isBinary(n2);
            responseMessage.storeShort(s);
            short s2 = -1;
            try {
                s2 = (short)resultSetMetaData.getPrecision(i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            responseMessage.storeShort(s2);
            short s3 = -1;
            try {
                s3 = (short)resultSetMetaData.getScale(i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            responseMessage.storeShort(s3);
        }
    }

    private void reset() throws SQLException {
        boolean bl = this.readByte() == 1;
        this.resultSetId = this.readString();
        if (bl) {
            this.isLastPacket = bl;
        }
        short s = this.readShort();
        short s2 = this.readShort();
        if (!(this.isFirstTime || s == this.packetSequence + 1 || s == Short.MIN_VALUE && this.packetSequence == Short.MAX_VALUE)) {
            throw new SQLException("invalid packet sequence. last=" + s + ", curr=" + this.packetSequence);
        }
        this.packetSequence = s;
        if (s2 < 1) {
            throw new SQLException("invalid column count=" + s2);
        }
        if (this.isFirstTime) {
            this.columnCount = s2;
        }
    }

    private void readColumnNames() throws SQLException {
        this.columnMeta = new ColumnMetaData[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnMetaData columnMetaData;
            String string = this.readString();
            String string2 = this.readString();
            String string3 = this.readString();
            short s = this.readShort();
            short s2 = this.readShort();
            short s3 = this.readShort();
            short s4 = this.readShort();
            short s5 = this.readShort();
            this.columnMeta[i] = columnMetaData = new ColumnMetaData(string2, string3, s, s2, s4, s5, string, s3, true);
        }
    }

    public void resetRows() throws SQLException {
        if (this.getType() != 66) {
            logger.warn("err response detected, type=" + this.getType());
            this.isLastPacket = true;
            throw new SQLException("invalid operation");
        }
        if (this.isLastPacket) {
            this.rows = null;
            return;
        }
        try {
            if (this.isFirstTime) {
                this.reset();
                this.readColumnNames();
                this.isFirstTime = false;
            } else {
                this.reset();
            }
            ArrayList<XData[]> arrayList = new ArrayList<XData[]>();
            while (this.hasMoreDataToRead() && this.readByte() != 0) {
                String string = null;
                XData[] xDataArray = new XData[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    XData xData = null;
                    if (!DataTypes.isBinary(this.columnMeta[i].javaSqlType)) {
                        string = this.readString();
                    }
                    try {
                        switch (this.columnMeta[i].javaSqlType) {
                            case 1: 
                            case 12: {
                                xData = new VarcharType(string);
                                break;
                            }
                            case 91: {
                                Date date = null;
                                if (string != null) {
                                    date = new Date(this.datetimeFormat.parse(string + " 00:00:00").getTime());
                                }
                                xData = new DateType(date);
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                xData = new FloatType(string);
                                xData.setJavaType(this.columnMeta[i].javaSqlType);
                                break;
                            }
                            case 4: {
                                xData = new IntegerType(string);
                                break;
                            }
                            case -5: {
                                xData = new LongType(string);
                                break;
                            }
                            case 3: {
                                xData = new BigDecimalType(string);
                                xData.setJavaType(3);
                                break;
                            }
                            case 2: {
                                xData = new BigDecimalType(string);
                                xData.setJavaType(2);
                                break;
                            }
                            case 5: {
                                xData = new ShortType(string);
                                break;
                            }
                            case 93: {
                                Object object;
                                Timestamp timestamp = null;
                                String string2 = null;
                                if (string != null) {
                                    object = new ParsePosition(0);
                                    timestamp = new Timestamp(this.datetimeFormat.parse(string, (ParsePosition)object).getTime());
                                    int n = ((ParsePosition)object).getIndex();
                                    if (n < string.length() && string.charAt(n) == '.') {
                                        ++n;
                                        int n2 = 0;
                                        for (int j = 0; j < 9; ++j) {
                                            n2 *= 10;
                                            if (string.charAt(n) < '0' || string.charAt(n) > '9') continue;
                                            n2 += string.charAt(n++) - 48;
                                        }
                                        timestamp.setNanos(n2);
                                    }
                                    string2 = string.substring(n);
                                }
                                xData = new TimestampType(timestamp, string2);
                                break;
                            }
                            case 92: {
                                Object object = null;
                                String string2 = null;
                                if (string != null) {
                                    ParsePosition parsePosition = new ParsePosition(0);
                                    object = new Time(this.datetimeFormat.parse("1970-01-01 " + string, parsePosition).getTime());
                                    string2 = string.substring(parsePosition.getIndex() - 11);
                                }
                                xData = new TimeType((Time)object, string2);
                                break;
                            }
                            case 16: {
                                xData = new BooleanType(string);
                                break;
                            }
                            case -6: {
                                xData = new ByteType(string);
                                break;
                            }
                            case 2004: {
                                int n = this.readInt();
                                xData = new BlobType(this.readBytes(n));
                                break;
                            }
                            case 2005: {
                                xData = new ClobType(string);
                                break;
                            }
                            case -7: 
                            case -4: 
                            case -3: 
                            case -2: {
                                int n = this.readInt();
                                xData = new ByteArrayType(this.readBytes(n));
                                xData.setJavaType(this.columnMeta[i].javaSqlType);
                                break;
                            }
                            default: {
                                xData = new VarcharType(string);
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        xData = new VarcharType(string);
                    }
                    xDataArray[i] = xData;
                    if (string == null) continue;
                    this.columnMeta[i].maxLength = string.length() > this.columnMeta[i].maxLength ? string.length() : this.columnMeta[i].maxLength;
                }
                arrayList.add(xDataArray);
            }
            this.rows = arrayList;
        }
        catch (Throwable throwable) {
            logger.catching(throwable);
            throw new SQLException(throwable.getMessage());
        }
    }
}

