/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.io;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.parser.handler.TypeConstants;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

public class DataTypes {
    public static String getJavaTypeDesc(SysColumn sysColumn) {
        String string = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = sysColumn.getColLength();
        hashMap.put("length", "" + n);
        hashMap.put("precision", "" + sysColumn.getColPrecision());
        hashMap.put("scale", "" + sysColumn.getColScale());
        switch (sysColumn.getColType()) {
            case 92: {
                string = n > 0 ? (sysColumn.isWithTimeZone ? TypeConstants.TIMEWITHLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIMEWITHLENGTH_WITHOUT_TIMEZONE_TEMPLATE) : (sysColumn.isWithTimeZone ? TypeConstants.TIMEWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIMEWITHOUTLENGTH_WITHOUT_TIMEZONE_TEMPLATE);
                return ParseCmdLine.substitute(string, hashMap);
            }
            case 93: {
                string = n > 0 ? (sysColumn.isWithTimeZone ? TypeConstants.TIMESTAMPWITHLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIMESTAMPWITHLENGTH_WITHOUT_TIMEZONE_TEMPLATE) : (sysColumn.isWithTimeZone ? TypeConstants.TIMESTAMPWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE : TypeConstants.TIMESTAMPWITHOUTLENGTH_WITHOUT_TIMEZONE_TEMPLATE);
                return ParseCmdLine.substitute(string, hashMap);
            }
        }
        return DataTypes.getJavaTypeDesc(sysColumn.getColType());
    }

    public static String getJavaTypeDesc(int n) {
        switch (n) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return null;
    }

    public static int getJavaType(String string) {
        if ("BIT".equals(string = string.trim().toUpperCase())) {
            return -7;
        }
        if ("TINYINT".equals(string)) {
            return -6;
        }
        if ("SMALLINT".equals(string)) {
            return 5;
        }
        if ("INTEGER".equals(string)) {
            return 4;
        }
        if ("BIGINT".equals(string)) {
            return -5;
        }
        if ("FLOAT".equals(string)) {
            return 6;
        }
        if ("REAL".equals(string)) {
            return 7;
        }
        if ("DOUBLE PRECISION".equals(string)) {
            return 8;
        }
        if ("NUMERIC".equals(string)) {
            return 2;
        }
        if ("DECIMAL".equals(string)) {
            return 3;
        }
        if ("CHAR".equals(string)) {
            return 1;
        }
        if ("VARCHAR".equals(string)) {
            return 12;
        }
        if ("LONGVARCHAR".equals(string)) {
            return -1;
        }
        if ("DATE".equals(string)) {
            return 91;
        }
        if ("TIME".equals(string)) {
            return 92;
        }
        if ("TIMESTAMP".equals(string)) {
            return 93;
        }
        if ("BINARY".equals(string)) {
            return -2;
        }
        if ("VARBINARY".equals(string)) {
            return -3;
        }
        if ("LONGVARBINARY".equals(string)) {
            return -4;
        }
        if ("NULL".equals(string)) {
            return 0;
        }
        if ("OTHER".equals(string)) {
            return 1111;
        }
        if ("JAVA_OBJECT".equals(string)) {
            return 2000;
        }
        if ("DISTINCT".equals(string)) {
            return 2001;
        }
        if ("STRUCT".equals(string)) {
            return 2002;
        }
        if ("ARRAY".equals(string)) {
            return 2003;
        }
        if ("BLOB".equals(string)) {
            return 2004;
        }
        if ("CLOB".equals(string)) {
            return 2005;
        }
        if ("REF".equals(string)) {
            return 2006;
        }
        if ("DATALINK".equals(string)) {
            return 70;
        }
        if ("BOOLEAN".equals(string)) {
            return 16;
        }
        return 0;
    }

    public static boolean isNumeric(int n) {
        return n == -7 || n == -6 || n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 8 || n == 2 || n == 3;
    }

    public static boolean isString(int n) {
        return n == 1 || n == 12 || n == -1;
    }

    public static boolean isBinary(int n) {
        return n == -2 || n == -7 || n == -3 || n == -4 || n == 2004;
    }

    public static void setParameter(PreparedStatement preparedStatement, int n, String string, int n2) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -5: {
                preparedStatement.setLong(n, Long.parseLong(string));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                preparedStatement.setInt(n, Integer.parseInt(string));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                preparedStatement.setDouble(n, Double.parseDouble(string));
                break;
            }
            default: {
                preparedStatement.setString(n, string);
            }
        }
    }
}

