/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.datatypes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class XClob
implements Clob {
    private String val = null;

    public XClob(String string) {
        this.val = string;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.val == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.val.getBytes("US-ASCII"));
        }
        catch (Throwable throwable) {
            throw new SQLException("error converting to ascii charset");
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.val == null) {
            return null;
        }
        return new StringReader(this.val);
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.val == null) {
            return null;
        }
        return this.val.substring((int)l, (int)l + n - 1);
    }

    public long length() throws SQLException {
        if (this.val == null) {
            return 0L;
        }
        return this.val.length();
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }

    public long position(String string, long l) throws SQLException {
        if (this.val == null) {
            return -1L;
        }
        int n = this.val.indexOf(string, (int)l - 1);
        if (n >= 0) {
            return ++n;
        }
        return -1L;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        return new XClobOutputStream(l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        return new XClobWriter(l);
    }

    public int setString(long l, String string) throws SQLException {
        throw new SQLException("not supported with this version");
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw new SQLException("not supported with this version");
    }

    public void truncate(long l) throws SQLException {
        throw new SQLException("not supported with this version");
    }

    public String toString() {
        return this.val;
    }

    public void free() throws SQLException {
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        return null;
    }

    private class XClobWriter
    extends StringWriter {
        private long pos;

        private XClobWriter(long l) {
            this.pos = l;
        }

        public void flush() {
            try {
                XClob.this.setString(this.pos, this.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.flush();
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }

    private class XClobOutputStream
    extends ByteArrayOutputStream {
        private long pos;

        private XClobOutputStream(long l) {
            this.pos = l;
        }

        public void flush() throws IOException {
            try {
                XClob.this.setString(this.pos, new String(this.toByteArray(), "US-ASCII"));
            }
            catch (Exception exception) {
                throw new IOException("Can not write data to CLOB field: " + exception.getMessage());
            }
            super.flush();
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }
}

