/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.CommandLog;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.CoordinatorAgent;
import com.edb.gridsql.engine.BatchInsertGroup;
import com.edb.gridsql.engine.CoordinatorPools;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutableRequest;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.ServerStatement;
import com.edb.gridsql.engine.io.MessageTypes;
import com.edb.gridsql.engine.io.ResponseMessage;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.metadata.scheduler.ITransaction;
import com.edb.gridsql.metadata.scheduler.Scheduler;
import com.edb.gridsql.parser.SqlModifyTable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDBSessionContext
implements MessageTypes,
ITransaction {
    private static final XLogger logger = XLogger.getLogger(XDBSessionContext.class);
    private XLogger logSession;
    private static final Collection<XDBSessionContext> sessions = new HashSet<XDBSessionContext>();
    private static volatile int lastSessionID = 0;
    private boolean usedSet = false;
    private long statementId;
    private int sessionID;
    private String dbName;
    private SysDatabase database;
    private String userName;
    private SysUser currentUser;
    private volatile boolean connected = false;
    private String mode = null;
    private boolean isInBatch = false;
    private BatchInsertGroup batchGroup = null;
    private HashSet<SysTable> dirtyWriteTables = null;
    private HashSet<SysTable> dirtyReadTables = null;
    private Connection coordConnection;
    private int requestId = 0;
    private Object executorAccess = new Object();
    private MultinodeExecutor lastExecutor = null;
    private HashMap<String, String> savepointTable;
    private boolean isInTransaction;
    private int isolationLevel = 2;
    private Hashtable<String, String> tempTableMap;
    private LinkedList<ExecutableRequest> executables = new LinkedList();
    private Map<String, ServerStatement> statements = new HashMap<String, ServerStatement>();
    private Map<String, ServerStatement> cursors = new HashMap<String, ServerStatement>();
    private boolean forcePersistent = false;
    private Map<String, Collection<DBNode>> preparedCommands = new HashMap<String, Collection<DBNode>>();

    public static final XDBSessionContext createSession() throws XDBServerException {
        XDBSessionContext xDBSessionContext = new XDBSessionContext();
        Collection<XDBSessionContext> collection = sessions;
        synchronized (collection) {
            if (sessions.size() < Props.XDB_MAXCONNECTIONS) {
                sessions.add(xDBSessionContext);
                return xDBSessionContext;
            }
            throw new XDBServerException("Too many connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult shutdownDatabase() throws XDBSecurityException {
        this.checkPrivileged();
        LinkedList<XDBSessionContext> linkedList = new LinkedList<XDBSessionContext>();
        Object object = sessions;
        synchronized (object) {
            for (XDBSessionContext xDBSessionContext : sessions) {
                if (xDBSessionContext.getSysDatabase() != this.getSysDatabase() || this == xDBSessionContext) continue;
                SysUser sysUser = xDBSessionContext.getCurrentUser();
                if (sysUser == null || sysUser == this.getCurrentUser() || sysUser.getUserClass() != 0) {
                    linkedList.add(xDBSessionContext);
                    continue;
                }
                XDBServerException xDBServerException = new XDBServerException("Can not get exclusive access to database " + this.getDBName() + ": there is active DBA connection");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
        for (XDBSessionContext xDBSessionContext : linkedList) {
            try {
                xDBSessionContext.close();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
        }
        object = this.database;
        this.logout();
        CommandLog.cmdLogger.info((Object)(this.sessionID + " - Stop database: " + object));
        CoordinatorAgent.getInstance().shutdownDatabase((SysDatabase)object);
        CoordinatorPools.destoryPool(((SysDatabase)object).getDbname());
        return ExecutionResult.createSuccessResult(36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void shutdown() throws XDBSecurityException {
        void var2_7;
        Collection<XDBSessionContext> collection = sessions;
        synchronized (collection) {
            for (XDBSessionContext xDBSessionContext : sessions) {
                if (this == xDBSessionContext) continue;
                throw new XDBServerException("There are active connections");
            }
        }
        XLogger.getLogger("Server").info("*** Server is going down");
        for (SysDatabase sysDatabase : MetaData.getMetaData().getSysDatabases()) {
            if (!sysDatabase.isStarted() || sysDatabase.getDbname().equalsIgnoreCase(Props.XDB_ADMIN_DATABASE)) continue;
            throw new XDBServerException("Database " + sysDatabase.getDbname() + " is running");
        }
        CoordinatorAgent.getInstance().resetNodes(false);
        int n = 60;
        boolean bl = false;
        while (var2_7 < n) {
            boolean bl2 = true;
            for (Node node : MetaData.getMetaData().getNodes()) {
                bl2 = bl2 && !node.isUp();
            }
            if (bl2) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++var2_7;
        }
        CoordinatorAgent.releaseInstance();
        XLogger.getLogger("Server").info("*** Server is down, exiting...");
        System.exit(0);
    }

    private XDBSessionContext() {
        this.sessionID = ++lastSessionID;
        this.tempTableMap = new Hashtable();
        this.savepointTable = new HashMap();
        this.logSession = XLogger.getLogger(XDBSessionContext.class.getName() + "." + this.sessionID);
        this.logSession.debug("Session object is created");
    }

    public ExecutionResult close() throws IOException {
        this.logSession.debug("Closing session");
        this.logout();
        CoordinatorAgent.getInstance().removeProcess(new Integer(this.sessionID));
        this.logSession.debug("Session is closed");
        return ExecutionResult.createSuccessResult(38);
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getDBName() {
        return this.dbName;
    }

    public SysDatabase getSysDatabase() {
        return this.database;
    }

    public SysUser getCurrentUser() {
        return this.currentUser;
    }

    private void checkPrivileged() throws XDBSecurityException {
        if (this.currentUser.getUserClass() != 0) {
            throw new XDBSecurityException("Only DBA user can perform this task");
        }
    }

    public void useDB(String string, String string2) {
        if (string.equals(this.dbName)) {
            return;
        }
        if (this.connected) {
            this.logout();
        }
        this.dbName = string;
        this.mode = "C".equals(string2) ? "C" : ("A".equals(string2) ? "A" : ("P".equals(string2) ? "P" : "N"));
        if ("C" != this.mode) {
            this.database = MetaData.getMetaData().getSysDatabase(string);
            if ("A" != this.mode && !this.database.isStarted()) {
                throw new XDBServerException("Database " + string + " is not started");
            }
        }
        this.checkDbUser();
    }

    public void setUser(String string) {
        if (string.equals(this.userName)) {
            return;
        }
        if (this.connected) {
            this.logout();
        }
        this.userName = string;
        this.checkDbUser();
    }

    private void checkDbUser() {
        if (this.database != null && this.userName != null) {
            if (this.mode == "A" && !this.database.isOnline()) {
                this.database.admin();
            }
            this.currentUser = this.database.getSysUser(this.userName);
        }
    }

    public ExecutionResult login(String string) throws XDBSecurityException, XDBServerException {
        if (this.userName == null) {
            throw new XDBServerException("User name is not specified");
        }
        SysLogin sysLogin = MetaData.getMetaData().getSysLogin(this.userName);
        sysLogin.checkPassword(string);
        return this.login(sysLogin);
    }

    public ExecutionResult login(SysLogin sysLogin) throws XDBSecurityException, XDBServerException {
        if ("C" == this.mode) {
            this.logSession.debug("This is createdb request");
            if (this.dbName == null) {
                throw new XDBServerException("Database name is not specified");
            }
            this.database = MetaData.getMetaData().createDatabase(this.dbName, sysLogin);
            this.logSession.debug("Temp database and user have been created");
        }
        if (this.database == null) {
            throw new XDBServerException("Database name is not specified");
        }
        if ("A" == this.mode) {
            if (sysLogin.getUserClass() != 0) {
                throw new XDBSecurityException("Non-privileged user can not perform privileged task");
            }
            this.database.admin();
        }
        this.currentUser = this.database.getSysUser(sysLogin.getName());
        this.connected = true;
        return ExecutionResult.createSuccessResult(37);
    }

    public ExecutionResult login(String string, String string2, String string3, String string4) throws XDBSecurityException, XDBServerException {
        this.logSession.debug("User " + string2 + " is logging in to database " + string);
        this.useDB(string, string4);
        this.setUser(string2);
        return this.login(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        this.logSession.debug("User " + this.currentUser + " is logging out");
        try {
            Collection<String> collection;
            if (!this.connected) {
                this.logSession.debug("Ooops, not connected !");
                return;
            }
            this.connected = false;
            if (this.mode == "C") {
                this.logSession.debug("We were creating new database, cleaning up");
                MetaData.getMetaData().dropTempDatabase(this.dbName);
            }
            this.logSession.debug("Cleaning up ExecutableRequests");
            Object object = this;
            synchronized (object) {
                for (ExecutableRequest iterator : this.executables) {
                    iterator.cancel();
                }
                this.executables.clear();
                this.notifyAll();
            }
            this.logSession.debug("Releasing query responses and temp tables...");
            object = Engine.getInstance();
            try {
                if (!this.isInTransaction) {
                    ((Engine)object).beginTransaction(this, this.database.getDBNodeList());
                }
                for (ServerStatement serverStatement : this.cursors.values()) {
                    try {
                        serverStatement.close();
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                    }
                }
                this.cursors.clear();
                collection = this.getTempTableNames();
                for (String string : collection) {
                    this.database.dropSysTable(string);
                }
                ((Engine)object).dropNodeTempTables(collection, this.database.getDBNodeList(), this);
                ((Engine)object).commitTransaction(this, this.database.getDBNodeList());
            }
            catch (Throwable throwable) {
                logger.catching(throwable);
            }
            this.logSession.debug("...done");
            collection = this.database.getScheduler();
            synchronized (collection) {
                this.logSession.debug("Releasing locks from LM, if still held");
                this.database.getLm().notifyTransactionEnd(this);
            }
        }
        finally {
            sessions.remove(this);
            this.clearCoordinatorConnection();
            this.releaseExecutor();
            this.currentUser = null;
            this.userName = null;
            this.database = null;
            this.dbName = null;
            this.logSession.debug("Logout is completed");
        }
    }

    void setInBatch(boolean bl) {
        this.isInBatch = bl;
        this.batchGroup = null;
        this.dirtyWriteTables = null;
        this.dirtyReadTables = null;
    }

    public BatchInsertGroup getInsertGroup(SqlModifyTable sqlModifyTable) {
        if (this.dirtyReadTables != null && this.dirtyReadTables.contains(sqlModifyTable.getTargetTable())) {
            this.batchGroup = null;
            this.dirtyReadTables = null;
            this.dirtyWriteTables = null;
        }
        if (this.dirtyWriteTables != null) {
            for (SysTable sysTable : sqlModifyTable.getReadTables()) {
                if (!this.dirtyWriteTables.contains(sysTable)) continue;
                this.batchGroup = null;
                this.dirtyReadTables = null;
                this.dirtyWriteTables = null;
                break;
            }
        }
        if (this.batchGroup == null) {
            this.batchGroup = new BatchInsertGroup(sqlModifyTable);
        } else {
            this.batchGroup.addMember(sqlModifyTable);
        }
        return this.batchGroup;
    }

    public void closeInsertGroup(SqlModifyTable sqlModifyTable) {
        if (this.batchGroup != null) {
            if (this.dirtyReadTables == null) {
                this.dirtyReadTables = new HashSet<SysTable>(sqlModifyTable.getReadTables());
            } else {
                this.dirtyReadTables.addAll(sqlModifyTable.getReadTables());
            }
            if (this.dirtyWriteTables == null) {
                this.dirtyWriteTables = new HashSet();
            }
            this.dirtyWriteTables.add(sqlModifyTable.getTargetTable());
        }
    }

    public Connection getAndSetCoordinatorConnection() {
        if (this.coordConnection == null) {
            this.coordConnection = CoordinatorPools.getConnection(this.dbName);
        }
        return this.coordConnection;
    }

    public Connection resetCoordinatorConnection() {
        if (this.coordConnection != null && !this.isPersistent()) {
            CoordinatorPools.destroyConnection(this.dbName, this.coordConnection);
            this.coordConnection = CoordinatorPools.getConnection(this.dbName);
        }
        return this.coordConnection;
    }

    private void clearCoordinatorConnection() {
        if (this.coordConnection != null) {
            try {
                this.coordConnection.rollback();
                CoordinatorPools.releaseConnection(this.dbName, this.coordConnection);
            }
            catch (Exception exception) {
                logger.catching(exception);
                CoordinatorPools.destroyConnection(this.dbName, this.coordConnection);
            }
            this.coordConnection = null;
        }
    }

    public int getRequestId() {
        return this.requestId == Integer.MAX_VALUE ? (this.requestId = 0) : (this.requestId = this.requestId + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExecutor() {
        Object object = this.executorAccess;
        synchronized (object) {
            if (this.lastExecutor != null) {
                this.logSession.debug("Releasing MultinodeExecutor");
                this.lastExecutor.releaseNodeThreads();
                this.lastExecutor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultinodeExecutor getMultinodeExecutor(Collection<DBNode> collection) {
        Object object = this.executorAccess;
        synchronized (object) {
            if (this.lastExecutor == null) {
                this.logSession.debug("Creating new MultinodeExecutor");
                this.lastExecutor = new MultinodeExecutor(collection, this);
            } else {
                this.lastExecutor.addNeededNodes(collection);
            }
            return this.lastExecutor;
        }
    }

    void setSavepoint(String string) {
        this.savepointTable.put(string, string);
    }

    void clearSavepoint(String string) {
        this.savepointTable.remove(string);
    }

    @Override
    public boolean isInSubTransaction() {
        return this.savepointTable.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInTransaction(boolean bl) {
        if (!bl) {
            this.savepointTable.clear();
            if (this.database != null) {
                this.logSession.debug("Transaction is completed, releasing all the locks");
                Scheduler scheduler = this.database.getScheduler();
                synchronized (scheduler) {
                    this.database.getLm().notifyTransactionEnd(this);
                }
            }
        }
        this.isInTransaction = bl;
    }

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    @Override
    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    public int setTransactionIsolation(int n) {
        if (n != this.isolationLevel) {
            switch (n) {
                case 1: 
                case 2: {
                    this.isolationLevel = 2;
                }
            }
            this.isolationLevel = 8;
        }
        return this.isolationLevel;
    }

    public void registerTempTableWithSession(String string, String string2) {
        this.tempTableMap.put(string.toUpperCase(), string2);
    }

    public void deregisterTempTableWithSession(String string) {
        this.tempTableMap.remove(string.toUpperCase());
    }

    public String getTempTableName(String string) {
        return this.tempTableMap.get(string.toUpperCase());
    }

    public Collection<String> getTempTableNames() {
        return new ArrayList<String>(this.tempTableMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ExecutableRequest, XDBSessionContext> getRequests() {
        HashMap<ExecutableRequest, XDBSessionContext> hashMap = new HashMap<ExecutableRequest, XDBSessionContext>();
        Collection<XDBSessionContext> collection = sessions;
        synchronized (collection) {
            for (XDBSessionContext xDBSessionContext : sessions) {
                if (this.currentUser.getUserClass() != 0 && this.currentUser != xDBSessionContext.currentUser) continue;
                XDBSessionContext xDBSessionContext2 = xDBSessionContext;
                synchronized (xDBSessionContext2) {
                    for (ExecutableRequest executableRequest : xDBSessionContext.executables) {
                        hashMap.put(executableRequest, xDBSessionContext);
                    }
                }
            }
        }
        return hashMap;
    }

    public void createStatement(String string, ExecutableRequest executableRequest) {
        ServerStatement serverStatement = this.statements.put(string, new ServerStatement(string, executableRequest, this));
        if (serverStatement != null) {
            serverStatement.close();
        }
    }

    public void setParameterTypes(String string, int[] nArray) {
        ServerStatement serverStatement = this.statements.get(string);
        if (serverStatement == null) {
            throw new XDBServerException("Statement does not exist");
        }
        serverStatement.setParameterTypes(nArray);
    }

    public void bindStatement(String string, String string2, String[] stringArray) {
        ServerStatement serverStatement = this.statements.get(string);
        if (serverStatement == null) {
            throw new XDBServerException("Statement does not exist");
        }
        ServerStatement serverStatement2 = this.cursors.put(string2, serverStatement);
        if (serverStatement2 != null) {
            serverStatement2.close();
        }
        serverStatement.bind(string2, stringArray);
    }

    public ResponseMessage describeStatement(String string, String string2) {
        ServerStatement serverStatement = null;
        if (string2 != null) {
            serverStatement = this.cursors.get(string2);
        }
        if (serverStatement == null && string != null) {
            serverStatement = this.statements.get(string);
        }
        if (serverStatement == null) {
            throw new XDBServerException("Statement or cursor does not exist");
        }
        return serverStatement.describe();
    }

    public int[] getParameterTypes(String string) {
        ServerStatement serverStatement = this.statements.get(string);
        if (serverStatement == null) {
            throw new XDBServerException("Statement or cursor does not exist");
        }
        return serverStatement.getParameterTypes();
    }

    public ExecutionResult executeRequest(String string) {
        ServerStatement serverStatement = this.cursors.get(string);
        if (serverStatement == null) {
            throw new XDBServerException("Cursor does not exist");
        }
        return serverStatement.execute();
    }

    public void createResultSet(String string, ExecutionResult executionResult) {
        ServerStatement serverStatement = this.cursors.put(string, new ServerStatement(string, executionResult, this));
        if (serverStatement != null) {
            serverStatement.close();
        }
    }

    public ResultSet getResultSet(String string) {
        ServerStatement serverStatement = this.cursors.get(string);
        if (serverStatement == null) {
            throw new XDBServerException("Cursor does not exist");
        }
        return serverStatement.getResultSet();
    }

    public void closeStatement(String string) {
        ServerStatement serverStatement = this.statements.remove(string);
        if (serverStatement != null) {
            serverStatement.close();
        }
    }

    public void closeCursor(String string) {
        ServerStatement serverStatement = this.cursors.remove(string);
        if (serverStatement != null) {
            serverStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionResult executeRequest(ExecutableRequest executableRequest) {
        Object object = this;
        synchronized (object) {
            this.executables.addLast(executableRequest);
            while (!this.executables.isEmpty() && this.executables.getFirst() != executableRequest && !executableRequest.cancelled()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (executableRequest.cancelled()) {
                this.executables.remove(executableRequest);
                this.notifyAll();
                return ExecutionResult.createErrorResult(new XDBServerException("Request has been cancelled"));
            }
        }
        object = null;
        SysDatabase sysDatabase = this.database;
        try {
            Scheduler scheduler = sysDatabase.getScheduler();
            scheduler.addRequest(executableRequest.getCost(), this);
            ILockCost iLockCost = executableRequest.getCost().getSqlObject();
            try {
                while (object == null) {
                    boolean bl = true;
                    if (iLockCost != null) {
                        if (iLockCost.needCoordinatorConnection()) {
                            try {
                                this.getAndSetCoordinatorConnection();
                            }
                            catch (Exception exception) {
                                bl = false;
                            }
                        }
                        if (bl) {
                            bl = sysDatabase.getLm().getLock(iLockCost.getLockSpecs(), this);
                        }
                    }
                    if (bl) {
                        object = executableRequest.execute(Engine.getInstance(), this);
                        if (object == null || !((ExecutionResult)object).hasResultSet()) {
                            this.tryToReleaseConnections();
                        }
                        sysDatabase.getLm().releaseLock(this);
                    } else {
                        this.tryToReleaseConnections();
                        scheduler.holdRequest(executableRequest.getCost());
                        if (executableRequest.cancelled()) {
                            sysDatabase.getLm().notifyRefusedRequest(this);
                            ExecutionResult executionResult = ExecutionResult.createErrorResult(new XDBServerException("Request has been cancelled"));
                            return executionResult;
                        }
                    }
                    if (object != null) continue;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                scheduler.removeRequest(executableRequest.getCost());
            }
        }
        catch (Exception exception) {
            object = ExecutionResult.createErrorResult(exception);
        }
        finally {
            XDBSessionContext xDBSessionContext = this;
            synchronized (xDBSessionContext) {
                this.executables.remove(executableRequest);
                this.notifyAll();
            }
        }
        return object;
    }

    public boolean isPersistent() {
        return this.forcePersistent || this.isInTransaction || this.savepointTable.size() != 0 || this.isInBatch || this.hasActiveResultSets() || this.tempTableMap.size() != 0 || this.hasPreparedStatements() || this.usedSet && Props.XDB_PERSIST_ON_SET || this.mode == "P";
    }

    void setPersistent(boolean bl) {
        this.forcePersistent = bl;
    }

    private void tryToReleaseConnections() {
        if (!this.isPersistent()) {
            this.releaseExecutor();
            this.clearCoordinatorConnection();
        }
    }

    boolean hasActiveResultSets() {
        for (ServerStatement serverStatement : this.cursors.values()) {
            if (!serverStatement.hasResultSet()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        XDBSessionContext xDBSessionContext = this;
        synchronized (xDBSessionContext) {
            if (!this.executables.isEmpty()) {
                this.kill(this.executables.getFirst());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(ExecutableRequest executableRequest) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            executableRequest.cancel();
            bl = this.executables.getFirst() == executableRequest;
            this.executables.remove(executableRequest);
            this.notifyAll();
        }
        if (bl) {
            object = this.executorAccess;
            synchronized (object) {
                if (this.lastExecutor != null) {
                    this.lastExecutor.kill();
                }
            }
        }
    }

    public ExecutionResult createDatabase(String[] stringArray) throws XDBSecurityException {
        this.checkPrivileged();
        if (this.database.getDbid() == -1 && this.database.getDBNodeList().isEmpty()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (String string : stringArray) {
                hashSet.add(new Integer(string));
            }
            this.database.createDBNodes(hashSet);
        }
        return ExecutionResult.createSuccessResult(32);
    }

    public ExecutionResult persistDatabase() throws XDBSecurityException {
        this.checkPrivileged();
        MetaData.getMetaData().makeDbPersistent(this.database);
        CoordinatorPools.setInitialNode(this.database.getInitialNodeID());
        CoordinatorPools.initPool(this.database.getDbname());
        CoordinatorAgent.getInstance().connectToDatabase(this.database);
        return ExecutionResult.createSuccessResult(33);
    }

    public ExecutionResult startDatabase(int n) throws XDBSecurityException {
        this.checkPrivileged();
        CommandLog.cmdLogger.info((Object)(this.sessionID + " - Start database: " + this.database));
        CoordinatorPools.setInitialNode(this.database.getInitialNodeID());
        CoordinatorPools.initPool(this.dbName);
        CoordinatorAgent.getInstance().connectToDatabase(this.database);
        if (n > 0 && !this.database.waitForOnline((long)n * 1000L)) {
            XDBServerException xDBServerException = new XDBServerException("Failed to bring database online in " + n + " seconds");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        return ExecutionResult.createSuccessResult(35);
    }

    public NodeDBConnectionInfo[] getConnectionInfos(String[] stringArray) throws XDBSecurityException {
        NodeDBConnectionInfo[] nodeDBConnectionInfoArray = null;
        if (stringArray == null || stringArray.length == 0) {
            if (this.database == null || this.database.getDbid() == -1) {
                Collection<Node> collection = MetaData.getMetaData().getNodes();
                nodeDBConnectionInfoArray = new NodeDBConnectionInfo[collection.size()];
                int n = 0;
                for (Node node : collection) {
                    nodeDBConnectionInfoArray[n++] = node.getNodeDBConnectionInfo(this.dbName);
                }
            } else {
                Collection<DBNode> collection = this.database.getDBNodeList();
                nodeDBConnectionInfoArray = new NodeDBConnectionInfo[collection.size()];
                int n = 0;
                for (DBNode dBNode : collection) {
                    nodeDBConnectionInfoArray[n++] = dBNode.getNodeDBConnectionInfo();
                }
            }
        } else {
            nodeDBConnectionInfoArray = new NodeDBConnectionInfo[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n = Integer.parseInt(stringArray[i]);
                Node node = MetaData.getMetaData().getNode(n);
                nodeDBConnectionInfoArray[i] = node.getNodeDBConnectionInfo(this.dbName);
            }
        }
        return nodeDBConnectionInfoArray;
    }

    public ExecutionResult dropDatabase() throws SQLException {
        this.checkPrivileged();
        if (this.database.getDbid() != -1) {
            MetaData.getMetaData().dropDatabase(this.dbName);
        }
        return ExecutionResult.createSuccessResult(34);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerPreparedStatement(String string, Collection<DBNode> collection) {
        int n = 0;
        String string2 = string;
        Map<String, Collection<DBNode>> map = this.preparedCommands;
        synchronized (map) {
            while (this.preparedCommands.containsKey(string2)) {
                string2 = string + n++;
            }
            this.preparedCommands.put(string2, collection);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPreparedStatement(String string) {
        Map<String, Collection<DBNode>> map = this.preparedCommands;
        synchronized (map) {
            this.preparedCommands.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBNode> getPreparedStatementNodes(String string) {
        Map<String, Collection<DBNode>> map = this.preparedCommands;
        synchronized (map) {
            return this.preparedCommands.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreparedStatements() {
        Map<String, Collection<DBNode>> map = this.preparedCommands;
        synchronized (map) {
            return !this.preparedCommands.isEmpty();
        }
    }

    public void setStatementId(long l) {
        this.statementId = l;
    }

    public long getStatementId() {
        return this.statementId;
    }

    public void setUsedSet() {
        this.usedSet = true;
    }
}

